/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.lib.uihandler.Decorable;
import org.netbeans.lib.uihandler.Decorations;
import org.netbeans.lib.uihandler.LogFormatter;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class LogRecords {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());
    private static final Formatter FORMATTER = new LogFormatter();
    private static final String RECORD_ELM_START = "<record>";
    private static final String RECORD_ELM_END = "</record>";

    private LogRecords() {
    }

    public static void decorate(LogRecord r, Decorable d) {
        Decorations.decorate(r, d);
    }

    public static void write(OutputStream os, LogRecord rec) throws IOException {
        String formated = FORMATTER.format(rec);
        byte[] arr = formated.getBytes("utf-8");
        os.write(arr);
        os.flush();
    }

    public static void scan(File f, Handler h) throws IOException {
        HandlerDelegate hd = new HandlerDelegate(h);
        FileInputStream is = null;
        ArrayList<LogRecord> errorLogRecords = new ArrayList<LogRecord>();
        try {
            is = new FileInputStream(f);
            LogRecords.scan(is, hd, errorLogRecords);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "LogRecords scan threw {0}", ex.toString());
            if (is != null) {
                ((InputStream)is).close();
            }
            is = null;
            if (LogRecords.repairFile(f)) {
                errorLogRecords.clear();
                LOG.info("LogRecords File repaired. :-)");
                hd.setContinueAfterLast();
                is = new FileInputStream(f);
                LogRecords.scan(is, (Handler)hd);
                return;
            }
            LOG.info("LogRecords File NOT repaired. :-(");
            LOG.severe("Throwing the original exception... :-(");
            throw ex;
        }
        finally {
            for (LogRecord lr : errorLogRecords) {
                LOG.log(lr);
            }
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(InputStream is, Handler h) throws IOException {
        ArrayList<LogRecord> errorLogRecords = new ArrayList<LogRecord>();
        try {
            LogRecords.scan(is, h, errorLogRecords);
        }
        finally {
            for (LogRecord lr : errorLogRecords) {
                LOG.log(lr);
            }
        }
    }

    private static void scan(InputStream is, Handler h, List<LogRecord> errorLogRecords) throws IOException {
        SAXParser p;
        PushbackInputStream wrap = new PushbackInputStream(is, 32);
        byte[] arr = new byte[5];
        int len = wrap.read(arr);
        if (len == -1) {
            return;
        }
        wrap.unread(arr, 0, len);
        if (arr[0] == 31 && arr[1] == -117) {
            len = (wrap = new PushbackInputStream(new GZIPInputStream(wrap), 32)).read(arr);
            if (len == -1) {
                return;
            }
            wrap.unread(arr, 0, len);
        }
        if (arr[0] == 60 && arr[1] == 63 && arr[2] == 120 && arr[3] == 109 && arr[4] == 108) {
            is = wrap;
        } else {
            ByteArrayInputStream header = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><uigestures version='1.0'>".getBytes());
            ByteArrayInputStream footer = new ByteArrayInputStream("</uigestures>".getBytes());
            is = new SequenceInputStream(new SequenceInputStream(header, wrap), footer);
        }
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        try {
            try {
                f.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            }
            catch (SAXNotRecognizedException snre) {
                LogRecord lr = new LogRecord(Level.INFO, null);
                lr.setThrown(snre);
                errorLogRecords.add(lr);
            }
            p = f.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            LogRecord lr = new LogRecord(Level.SEVERE, null);
            lr.setThrown(ex);
            errorLogRecords.add(lr);
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            LogRecord lr = new LogRecord(Level.SEVERE, null);
            lr.setThrown(ex);
            errorLogRecords.add(lr);
            throw new IOException(ex);
        }
        Parser parser = new Parser(h);
        try {
            p.parse(is, (DefaultHandler)parser);
        }
        catch (SAXParseException ex) {
            LogRecord lr = new LogRecord(Level.WARNING, "Line = " + ex.getLineNumber() + ", column = " + ex.getColumnNumber());
            lr.setThrown(ex);
            errorLogRecords.add(lr);
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            LogRecord lr = new LogRecord(Level.WARNING, null);
            lr.setThrown(ex);
            errorLogRecords.add(lr);
            throw new IOException(ex);
        }
        catch (InternalError error) {
            LogRecord lr = new LogRecord(Level.WARNING, "Input file corruption");
            lr.setThrown(error);
            errorLogRecords.add(lr);
            throw new IOException(error);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            LogRecord lr = new LogRecord(Level.WARNING, "Input file corruption");
            lr.setThrown(ex);
            errorLogRecords.add(lr);
            throw new IOException(ex);
        }
        finally {
            List<SAXParseException> fatalErrors = parser.getFatalErrors();
            if (fatalErrors != null) {
                for (SAXParseException ex : fatalErrors) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Fatal SAX Parse Exception: Line = " + ex.getLineNumber() + ", column = " + ex.getColumnNumber());
                    lr.setThrown(ex);
                    errorLogRecords.add(lr);
                }
            }
        }
    }

    static Level parseLevel(String lev) {
        return "USER".equals(lev) ? Level.SEVERE : Level.parse(lev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean repairFile(File f) {
        boolean repaired = false;
        RandomAccessFile raf = null;
        try {
            String line;
            raf = new RandomAccessFile(f, "rw");
            String lastLine = null;
            long recordEndPos = -1L;
            long recordStartPos = -1L;
            while ((line = raf.readLine()) != null) {
                if (line.equals(RECORD_ELM_END)) {
                    recordEndPos = raf.getFilePointer();
                }
                if (line.endsWith(RECORD_ELM_START)) {
                    long pos = raf.getFilePointer();
                    long elmStart = pos - (long)RECORD_ELM_START.length() - 1L;
                    if (0L < recordEndPos && recordEndPos < elmStart) {
                        LogRecords.deletePart(raf, recordEndPos, elmStart);
                        long diff = elmStart - recordEndPos;
                        raf.seek(pos - diff);
                        recordEndPos -= diff;
                        elmStart -= diff;
                        repaired = true;
                    } else if (recordStartPos < 0L && (recordEndPos < 0L || recordEndPos == elmStart)) {
                        LogRecords.deletePart(raf, 0L, elmStart);
                        raf.seek(0L);
                        recordEndPos = 0L;
                        elmStart = 0L;
                        repaired = true;
                    }
                    recordStartPos = elmStart;
                }
                if (line.trim().isEmpty()) continue;
                lastLine = line;
            }
            if (lastLine != null && !RECORD_ELM_END.equals(lastLine) && recordEndPos > 0L) {
                LogRecords.deletePart(raf, recordEndPos, raf.length());
                repaired = true;
            }
            boolean bl = repaired;
            return bl;
        }
        catch (IOException ioex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void deletePart(RandomAccessFile raf, long pos1, long pos2) throws IOException {
        if (pos1 == pos2) {
            return;
        }
        assert (pos1 < pos2) : "The first position is higher: " + pos1 + ", " + pos2 + ".";
        int buffLength = 3;
        byte[] buffer = new byte[buffLength];
        long length = raf.length();
        while (pos2 + (long)buffLength <= length) {
            raf.seek(pos2);
            raf.readFully(buffer);
            raf.seek(pos1);
            raf.write(buffer);
            pos1 += (long)buffLength;
            pos2 += (long)buffLength;
        }
        if (pos2 < length) {
            int l = (int)(length - pos2);
            raf.seek(pos2);
            raf.readFully(buffer, 0, l);
            raf.seek(pos1);
            raf.write(buffer, 0, l);
        }
        raf.setLength(length - (pos2 - pos1));
    }

    private static class HandlerDelegate
    extends Handler {
        private Handler hd;
        private boolean afterLast;
        private long lastNumber;

        HandlerDelegate(Handler hd) {
            this.hd = hd;
        }

        @Override
        public void publish(LogRecord record) {
            long sn = record.getSequenceNumber();
            if (this.afterLast) {
                if (sn <= this.lastNumber) {
                    return;
                }
                this.afterLast = false;
            }
            this.lastNumber = sn;
            this.hd.publish(record);
        }

        @Override
        public void flush() {
            this.hd.flush();
        }

        @Override
        public void close() throws SecurityException {
            this.hd.close();
        }

        public String toString() {
            return this.hd.toString();
        }

        void setContinueAfterLast() {
            this.afterLast = true;
        }
    }

    private static final class Parser
    extends DefaultHandler {
        private Handler callback;
        private Map<Elem, String> values = new EnumMap<Elem, String>(Elem.class);
        private Elem current;
        private FakeException currentEx;
        private Queue<FakeException> exceptions;
        private List<String> params;
        private StringBuilder chars = new StringBuilder();
        private List<SAXParseException> fatalErrors;

        public Parser(Handler c) {
            this.callback = c;
        }

        public List<SAXParseException> getFatalErrors() {
            return this.fatalErrors;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            this.callback.flush();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "uri: {0} localName: {1} qName: {2} atts: {3}", new Object[]{uri, localName, qName, atts});
            }
            try {
                this.current = Elem.valueOf(qName.toUpperCase());
                if (this.current == Elem.EXCEPTION) {
                    this.currentEx = new FakeException(new EnumMap<Elem, String>(this.values));
                }
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, "Uknown tag " + qName, ex);
                this.current = null;
            }
            this.chars = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.current != null) {
                String v = this.chars.toString();
                this.values.put(this.current, v);
                if (this.current == Elem.PARAM) {
                    if (this.params == null) {
                        this.params = new ArrayList<String>();
                    }
                    this.params.add(v);
                    if (this.params.size() > 1500) {
                        LOG.log(Level.SEVERE, "Too long params when reading a record. Deleting few. Msg: {0}", Elem.MESSAGE.parse(this.values));
                        for (String p : this.params) {
                            LOG.fine(p);
                        }
                        this.params.clear();
                    }
                }
            }
            this.current = null;
            this.chars = new StringBuilder();
            if (this.currentEx != null && this.currentEx.values != null) {
                if ("frame".equals(qName)) {
                    String line = Elem.LINE.parse(this.values);
                    StackTraceElement elem = new StackTraceElement(Elem.CLASS.parse(this.values), Elem.METHOD.parse(this.values), Elem.FILE.parse(this.values), line == null ? -1 : Integer.parseInt(line));
                    this.currentEx.trace.add(elem);
                    this.values.remove((Object)Elem.CLASS);
                    this.values.remove((Object)Elem.METHOD);
                    this.values.remove((Object)Elem.LINE);
                }
                if ("exception".equals(qName)) {
                    this.currentEx.message = this.values.get((Object)Elem.MESSAGE);
                    String more = this.values.get((Object)Elem.MORE);
                    if (more != null) {
                        this.currentEx.more = Integer.parseInt(more);
                    }
                    if (this.exceptions == null) {
                        this.exceptions = new LinkedList<FakeException>();
                    }
                    this.exceptions.add(this.currentEx);
                    this.values = this.currentEx.values;
                    this.currentEx = null;
                }
                return;
            }
            if ("record".equals(qName)) {
                String millis = Elem.MILLIS.parse(this.values);
                String seq = Elem.SEQUENCE.parse(this.values);
                String lev = Elem.LEVEL.parse(this.values);
                String thread = Elem.THREAD.parse(this.values);
                String msg = Elem.MESSAGE.parse(this.values);
                String key = Elem.KEY.parse(this.values);
                String catalog = Elem.CATALOG.parse(this.values);
                if (lev != null) {
                    LogRecord r = new LogRecord(LogRecords.parseLevel(lev), key != null && catalog != null ? key : msg);
                    try {
                        r.setThreadID(this.parseInt(thread));
                    }
                    catch (NumberFormatException ex) {
                        LOG.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    r.setSequenceNumber(this.parseLong(seq));
                    r.setMillis(this.parseLong(millis));
                    r.setResourceBundleName(key);
                    if (catalog != null && key != null) {
                        r.setResourceBundleName(catalog);
                        if (!"<null>".equals(catalog)) {
                            try {
                                ResourceBundle b = NbBundle.getBundle((String)catalog);
                                b.getObject(key);
                                r.setResourceBundle(b);
                            }
                            catch (MissingResourceException e) {
                                LOG.log(Level.CONFIG, "Cannot find resource bundle {0} for key {1}", new Object[]{catalog, key});
                                r.setResourceBundle(new FakeBundle(key, msg));
                            }
                        } else {
                            LOG.log(Level.CONFIG, "Cannot find resource bundle <null> for key {1}", key);
                        }
                    }
                    if (this.params != null) {
                        r.setParameters(this.params.toArray());
                    }
                    if (this.exceptions != null) {
                        r.setThrown(this.createThrown(null));
                    }
                    this.callback.publish(r);
                }
                this.currentEx = null;
                this.params = null;
                this.values.clear();
            }
        }

        private long parseLong(String str) {
            if (str == null) {
                return 0L;
            }
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException exc) {
                LOG.log(Level.INFO, exc.getMessage(), exc);
                return 0L;
            }
        }

        private int parseInt(String str) {
            if (str == null) {
                return 0;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException exc) {
                LOG.log(Level.INFO, exc.getMessage(), exc);
                return 0;
            }
        }

        private FakeException createThrown(FakeException last) {
            if (this.exceptions.size() == 0) {
                return null;
            }
            FakeException result = this.exceptions.poll();
            if (result.getMore() != 0) {
                assert (last != null) : "IF MORE IS NOT 0, LAST MUST BE SET NOT NULL";
                StackTraceElement[] trace = last.getStackTrace();
                for (int i = trace.length - result.getMore(); i < trace.length; ++i) {
                    result.trace.add(trace[i]);
                }
            }
            FakeException cause = this.createThrown(result);
            result.initCause(cause);
            return result;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.fatalErrors == null) {
                this.fatalErrors = new LinkedList<SAXParseException>();
            }
            this.fatalErrors.add(e);
            if (this.fatalErrors.size() > 100) {
                throw e;
            }
        }

        private static enum Elem {
            UIGESTURES,
            RECORD,
            DATE,
            MILLIS,
            SEQUENCE,
            LEVEL,
            THREAD,
            MESSAGE,
            KEY,
            PARAM,
            FRAME,
            CLASS,
            METHOD,
            LOGGER,
            EXCEPTION,
            LINE,
            CATALOG,
            MORE,
            FILE;


            public String parse(Map<Elem, String> values) {
                String v = values.get((Object)this);
                return v;
            }
        }
    }

    private static final class FakeException
    extends Exception {
        final List<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Map<Parser.Elem, String> values;
        String message;
        int more;

        public FakeException(Map<Parser.Elem, String> values) {
            this.values = values;
            this.more = 0;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.trace.toArray(new StackTraceElement[0]);
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public int getMore() {
            return this.more;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }

    private static final class FakeBundle
    extends ResourceBundle {
        private String key;
        private String value;

        public FakeBundle(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        protected Object handleGetObject(String arg0) {
            if (this.key.equals(arg0)) {
                return this.value;
            }
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(Collections.singleton(this.key));
        }
    }
}

