/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.search;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SkippedTaskDelays {
    private static final Logger logger = Logger.getLogger(SkippedTaskDelays.class.getName());
    private Map<String, SkippedTaskDelayAndCount> skippedTaskDelays = new HashMap<String, SkippedTaskDelayAndCount>();
    private static final long DEFAULT_DELAY = 10L;
    private static final int MAX_SKIP_COUNT = 5;

    public long getDelayForSkippedTaskName(String skippedTaskName) {
        long random = Math.round(Math.random() * 1000.0);
        SkippedTaskDelayAndCount r = this.skippedTaskDelays.get(skippedTaskName);
        if (r == null) {
            return 10L + random;
        }
        logger.info(String.format("getDelayForSkippedTaskName: %s %d %d", skippedTaskName, r.getDelay(), r.getSkipCount()));
        return r.getDelay() + random;
    }

    public void putDelayForSkippedTaskName(String skippedTaskName, long delay) {
        SkippedTaskDelayAndCount r = this.skippedTaskDelays.get(skippedTaskName);
        int skipCount = 0;
        if (r != null) {
            skipCount = r.getSkipCount() + 1;
        }
        this.skippedTaskDelays.put(skippedTaskName, new SkippedTaskDelayAndCount(this, delay, skipCount));
    }

    public boolean isSkipCountLimitExceeded(String skippedTaskName) {
        SkippedTaskDelayAndCount r = this.skippedTaskDelays.get(skippedTaskName);
        if (r == null) {
            return false;
        }
        return r.getSkipCount() >= 5;
    }

    public final class SkippedTaskDelayAndCount {
        private long delay;
        private int skipCount;

        public SkippedTaskDelayAndCount(SkippedTaskDelays this$0, long delay, int skipCount) {
            this.delay = delay;
            this.skipCount = skipCount;
        }

        public long getDelay() {
            return this.delay;
        }

        public int getSkipCount() {
            return this.skipCount;
        }
    }
}

