/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceExceptionMessage;
import rs.co.ast.aspen.api.service.ApiServiceExceptionType;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.gui.module.login.CompatibilityCheck;
import rs.co.ast.aspen.gui.module.login.JavaVersion;
import rs.co.ast.aspen.gui.module.login.LoginBannerPanel;
import rs.co.ast.aspen.gui.module.login.LoginPanel;
import rs.co.ast.aspen.gui.module.login.PingApiService;
import rs.co.ast.aspen.gui.module.login.SystemProperties;

public class Installer
extends ModuleInstall
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(Installer.class.getName());
    private final PingApiService pingApiService = (PingApiService)Lookup.getDefault().lookup(PingApiService.class);
    private final DialogDescriptor des;
    private Dialog d;
    private DialogDescriptor desB;
    private final LoginPanel loginPanel = new LoginPanel();
    private final LoginBannerPanel loginBannerPanel = new LoginBannerPanel();
    private boolean okClicked = false;
    private final JavaVersion REQUIRED_JAVA_VERSION = JavaVersion.JAVA_21;
    private String apiVersion = "UNKNOWN";

    public Installer() {
        this.checkJavaVersion();
        this.des = new DialogDescriptor((Object)this.loginPanel, NbBundle.getMessage(Installer.class, (String)"LoginDialog.title"), true, (ActionListener)this);
        this.des.setClosingOptions(new Object[0]);
        this.d = DialogDisplayer.getDefault().createDialog(this.des);
        Image img = new ImageIcon(Installer.class.getClassLoader().getResource("frame32_aspen_console.gif")).getImage();
        this.d.setIconImage(img);
        this.d.setResizable(false);
        this.d.setAlwaysOnTop(true);
        this.d.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!Installer.this.okClicked) {
                    System.exit(0);
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    private void checkJavaVersion() throws NumberFormatException, MissingResourceException, HeadlessException {
        try {
            Optional<JavaVersion> optVersion = JavaVersion.get(SystemProperties.getJavaSpecificationVersion());
            JavaVersion version = optVersion.orElseThrow();
            if (!version.isCompatible(this.REQUIRED_JAVA_VERSION)) {
                JOptionPane.showMessageDialog(this.loginPanel, String.format(NbBundle.getMessage(Installer.class, (String)"Login.java.version.vendor"), "\n", Runtime.class.getPackage().getSpecificationVendor(), Runtime.class.getPackage().getSpecificationVersion()), "Warning message", 2);
            }
        }
        catch (NoSuchElementException ex) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Installer.class, (String)"Login.java.version.unknown"), "Error message", 0);
            this.exit();
        }
    }

    public void restored() {
        this.d.setVisible(true);
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            String consoleVersion = ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.CONSOLE);
            String apiInterfaceVersion = ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.API_INTERFACE);
            StringBuilder title = new StringBuilder();
            String mainTitle = WindowManager.getDefault().getMainWindow().getTitle();
            System.out.println("mainTitle: " + mainTitle);
            mainTitle = mainTitle.replaceAll("[0-9]+-[a-z0-9]+", "");
            title.append(mainTitle);
            System.out.println(mainTitle);
            title.append(String.format(" v%s ", consoleVersion));
            System.out.println(title.toString());
            title.append(String.format("(API-interface v%s) ", apiInterfaceVersion));
            System.out.println(title.toString());
            title.append(NbBundle.getMessage(Installer.class, (String)"Windows.title.connectedTo")).append(" ");
            System.out.println(title.toString());
            String username = this.loginPanel.getUsername();
            String host = this.loginPanel.getServer().replace("http://", "").replace("https://", "");
            boolean ssl = this.loginPanel.getSsl();
            if (ssl) {
                title.append("https://");
            } else {
                title.append("http://");
            }
            System.out.println(title.toString());
            title.append(username);
            title.append("@");
            title.append(host);
            System.out.println(title.toString());
            title.append(" - API version: ");
            title.append(this.apiVersion);
            title.append(" - userdir: ");
            title.append(Places.getUserDirectory().toString());
            LOGGER.info(String.format("TITLE: %s", title.toString()));
            WindowManager.getDefault().getMainWindow().setTitle(title.toString());
            this.pingApiService.pingApiService();
            CompatibilityCheck.CompatibilityStatus compatibilityStatus = CompatibilityCheck.checkVersionCompatibility(this.apiVersion, apiInterfaceVersion);
            if (!compatibilityStatus.isCompatible()) {
                NotifyDescriptor.Message notDes = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(Installer.class, (String)"Login.compatibility.updateMessage"), apiInterfaceVersion, this.apiVersion), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notDes);
            }
        });
    }

    private void doLogin() throws ApiServiceException_Exception {
        ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
        apiService.logoff();
        String username = this.loginPanel.getUsername();
        String password = this.loginPanel.getPassword();
        boolean ssl = this.loginPanel.getSsl();
        Object host = this.loginPanel.getServer();
        if (!((String)host).contains("://")) {
            host = (ssl ? "https://" : "http://") + (String)host;
        }
        apiService.login((String)host, username, password);
        this.getApiVersion(apiService);
        NbPreferences.forModule(LoginPanel.class).put("server_" + (String)host, (String)host);
        NbPreferences.forModule(LoginPanel.class).put("lastUsedServer", (String)host);
        NbPreferences.forModule(LoginPanel.class).putBoolean("use_ssl", ssl);
    }

    private void getApiVersion(ApiService apiService) throws MissingResourceException {
        block3: {
            try {
                this.apiVersion = apiService.getServerApiVersion();
                if (!this.apiVersion.equals("UNKNOWN")) {
                    this.apiVersion = this.apiVersion.substring(0, this.apiVersion.indexOf("-"));
                }
            }
            catch (RuntimeException | ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                if (!ex.getMessage().contains("was not recognized") || !ex.getMessage().contains("WSDL")) break block3;
                this.showFunctionNotAvailablePopupMessage();
            }
        }
    }

    private void showFunctionNotAvailablePopupMessage() throws MissingResourceException {
        NotifyDescriptor.Message notDes = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(Installer.class, (String)"Login.compatibility.functionNotAvailable"), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.API_INTERFACE)), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notDes);
    }

    private void exit() {
        RequestProcessor.getDefault().post(() -> ((LifecycleManager)LifecycleManager.getDefault()).exit());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == DialogDescriptor.OK_OPTION) {
            try {
                this.okClicked = true;
                if (!this.loginBannerPanel.isDontShow()) {
                    this.displayLoginBannerPanel();
                }
                if (this.loginBannerPanel.isIAgree()) {
                    this.doLogin();
                    this.des.setClosingOptions(null);
                }
            }
            catch (ApiServiceException_Exception ex) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ApiServiceExceptionMessage.forType((ApiServiceExceptionType)ex.getFaultInfo().getType(), null));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
            catch (RuntimeException ex) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        } else {
            this.exit();
            this.des.setClosingOptions(null);
        }
    }

    private void displayLoginBannerPanel() {
        this.desB = new DialogDescriptor((Object)this.loginBannerPanel, NbBundle.getMessage(Installer.class, (String)"LoginDialog.warningTitle"), true, e -> {
            if (e.getSource() == DialogDescriptor.OK_OPTION) {
                NbPreferences.forModule(LoginPanel.class).putBoolean("IAgree", this.loginBannerPanel.isIAgree());
                NbPreferences.forModule(LoginPanel.class).putBoolean("DontShow", this.loginBannerPanel.isDontShow());
            }
        });
        this.desB.setValid(this.loginBannerPanel.isIAgree());
        this.loginBannerPanel.setDialogDescriptor(this.desB);
        this.d = DialogDisplayer.getDefault().createDialog(this.desB);
        this.d.setResizable(false);
        this.d.setVisible(true);
    }
}

