/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.usermgmt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ComplexityViolation;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.gui.module.usermgmt.ConsoleUserService;
import rs.co.ast.aspen.gui.module.usermgmt.PasswordPromptPanel;
import rs.co.ast.aspen.gui.module.usermgmt.UserDetailsPanel;

public class SetPasswordConsoleUserAction
implements ActionListener {
    private DialogDescriptor d;
    private ActionListener listener;
    private PasswordPromptPanel ppp;
    private ConsoleUser user;

    public SetPasswordConsoleUserAction(ConsoleUser user) {
        this.user = user;
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block7: {
                    int opt = (Integer)e.getSource();
                    if (DialogDescriptor.OK_OPTION.equals(opt)) {
                        String p1 = SetPasswordConsoleUserAction.this.ppp.getOne();
                        String p2 = SetPasswordConsoleUserAction.this.ppp.getTwo();
                        if (!p1.isEmpty() && p1.equals(p2)) {
                            try {
                                List<ComplexityViolation> checkPasswordComplexity = SetPasswordConsoleUserAction.this.checkPasswordComplexity(p1);
                                if (checkPasswordComplexity.isEmpty()) {
                                    SetPasswordConsoleUserAction.this.changePassword(p1);
                                    SetPasswordConsoleUserAction.this.d.setClosingOptions(null);
                                    break block7;
                                }
                                SetPasswordConsoleUserAction.this.ppp.setErrorMessage(SetPasswordConsoleUserAction.this.passwordComplexityViolationsToString(checkPasswordComplexity));
                            }
                            catch (ApiServiceException_Exception ex) {
                                SetPasswordConsoleUserAction.this.ppp.setErrorMessage(ex.getLocalizedMessage());
                            }
                        } else {
                            SetPasswordConsoleUserAction.this.ppp.setErrorMessage(NbBundle.getMessage(UserDetailsPanel.class, (String)"passwords_dont_match.text"));
                        }
                    } else {
                        SetPasswordConsoleUserAction.this.d.setClosingOptions(null);
                    }
                }
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ppp = new PasswordPromptPanel();
        this.d = new DialogDescriptor((Object)this.ppp, NbBundle.getMessage(SetPasswordConsoleUserAction.class, (String)"password_set.title"), true, this.listener);
        this.d.setClosingOptions(new Object[0]);
        DialogDisplayer.getDefault().createDialog(this.d).setVisible(true);
    }

    private List<ComplexityViolation> checkPasswordComplexity(String password) throws ApiServiceException_Exception {
        ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
        return cus.checkPasswordComplexity(password);
    }

    private void changePassword(String password) throws ApiServiceException_Exception {
        ConsoleUserService cus = (ConsoleUserService)Lookup.getDefault().lookup(ConsoleUserService.class);
        cus.changePassword(this.user.getId(), password);
    }

    private String passwordComplexityViolationsToString(List<ComplexityViolation> checkPasswordComplexity) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (ComplexityViolation cv : checkPasswordComplexity) {
            sb.append(cv.getMessage());
            sb.append("<br/>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

