/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.threats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ThreatIndicator;

public class ThreatTableModel
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.IOC"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.Type"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.confidence"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.description"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.created"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.lastUpdate"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.sources"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.tags")).collect(Collectors.toList());
    private List<ThreatIndicator> originalData = new ArrayList<ThreatIndicator>();
    private List<ThreatIndicator> data = new ArrayList<ThreatIndicator>();

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Long.class;
            }
            case 5: {
                return Long.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ThreatIndicator element = this.data.get(rowIndex);
        switch (this.columns.get(columnIndex)) {
            case "IOC": {
                return element.getId();
            }
            case "Type": {
                return element.getType().value();
            }
            case "Confidence": {
                return element.getConfidenceLevel().value();
            }
            case "Description": {
                return element.getDescription();
            }
            case "Created": {
                return element.getCreated();
            }
            case "Last Update": {
                return element.getLastUpdated();
            }
            case "Sources": {
                return element.getSources().stream().collect(Collectors.joining(";"));
            }
            case "Tags": {
                return element.getTags().stream().collect(Collectors.joining(";"));
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.unknown"));
    }

    public List<String> getColumnNames() {
        return this.columns;
    }

    public void resetData() {
        this.data = Collections.EMPTY_LIST;
        this.originalData = Collections.EMPTY_LIST;
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void update(List<ThreatIndicator> data) {
        this.data = data;
        this.originalData = data;
        this.fireTableDataChanged();
    }

    public void updateFiltered(List<ThreatIndicator> data) {
        this.data = data == null ? this.originalData : data;
        this.fireTableDataChanged();
    }

    public void filterTable(String filterText) {
        ArrayList<ThreatIndicator> filtered = new ArrayList<ThreatIndicator>();
        String[] keywords = filterText.split(" ");
        this.originalData.forEach(ti -> {
            boolean found = true;
            for (String s : keywords) {
                if (this.toString((ThreatIndicator)ti).contains(s)) continue;
                found = false;
                break;
            }
            if (found) {
                filtered.add((ThreatIndicator)ti);
            }
        });
        this.updateFiltered(filtered);
    }

    private String toString(ThreatIndicator ti) {
        return "ThreatIndicator={id='" + ti.getId() + "', description='" + ti.getDescription() + "', sources=" + String.valueOf(ti.getSources() != null ? ti.getSources() : "[]") + ", type=" + (ti.getType().name() != null ? ti.getType().name() : "null") + ", tags=" + String.valueOf(ti.getTags() != null ? ti.getTags() : "[]") + ", level=" + (ti.getConfidenceLevel().name() != null ? ti.getConfidenceLevel().name() : "null") + ", lastUpdated=" + ti.getLastUpdated() + ", created=" + ti.getCreated() + "}";
    }
}

