/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RuleSetNode;

public final class DeleteRuleSetAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DeleteRuleSetAction.class.getName());
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final ParsingRuleSetDTOWrapper ruleset;

    public DeleteRuleSetAction(ParsingRuleSetDTOWrapper ruleset) {
        this.ruleset = ruleset;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        RuleSetNode node;
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"DeleteRuleSetConfirmation.message"), NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"DeleteRuleSetConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION && this.ruleset != null && (node = (RuleSetNode)Utilities.actionsGlobalContext().lookup(RuleSetNode.class)) != null) {
            Set ruleNamesWithResetMatchedGroupId = this.model.removeRuleSet(this.ruleset.getId());
            LOGGER.info(String.format("ruleNamesWithResetMatchedGroupId: %s", ruleNamesWithResetMatchedGroupId));
            if (!ruleNamesWithResetMatchedGroupId.isEmpty()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RulesWithChangedJumpTo.message"), String.join((CharSequence)",", ruleNamesWithResetMatchedGroupId)), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            node.updateChildren(this.ruleset);
        }
    }
}

