/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.caret;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.CaretItem;
import org.netbeans.api.editor.caret.CaretMoveContext;
import org.netbeans.api.editor.caret.CaretTransaction;
import org.netbeans.api.editor.caret.EditorCaretEvent;
import org.netbeans.api.editor.caret.EditorCaretListener;
import org.netbeans.api.editor.caret.MoveCaretsOrigin;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.AtomicLockEvent;
import org.netbeans.api.editor.document.AtomicLockListener;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.EditorCaretTransferHandler;
import org.netbeans.modules.editor.lib2.RectangularSelectionCaretAccessor;
import org.netbeans.modules.editor.lib2.RectangularSelectionUtils;
import org.netbeans.modules.editor.lib2.actions.EditorActionUtilities;
import org.netbeans.modules.editor.lib2.caret.CaretFoldExpander;
import org.netbeans.modules.editor.lib2.document.DocumentPostModificationUtils;
import org.netbeans.modules.editor.lib2.document.UndoRedoDocumentEventResolver;
import org.netbeans.modules.editor.lib2.highlighting.CaretOverwriteModeHighlighting;
import org.netbeans.modules.editor.lib2.view.LockedViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyListener;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.caret.CaretMoveHandler;
import org.netbeans.spi.editor.caret.CascadingNavigationFilter;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class EditorCaret
implements Caret {
    private static final String RECTANGULAR_SELECTION_PROPERTY = "rectangular-selection";
    private static final String RECTANGULAR_SELECTION_REGIONS_PROPERTY = "rectangular-selection-regions";
    private static final String NAVIGATION_FILTER_PROPERTY = EditorCaret.class.getName() + ".navigationFilters";
    private static final String CHAIN_FILTER_PROPERTY = EditorCaret.class.getName() + ".chainFilter";
    static final Logger LOG = Logger.getLogger(EditorCaret.class.getName());
    static final boolean logPaint = Boolean.getBoolean("org.netbeans.api.editor.caret.EditorCaret.paint");
    static final Integer overrideCaretBlinkRate = Integer.getInteger("org.netbeans.api.editor.caret.EditorCaret.blinkRate");
    private static final boolean dndDisabled = Boolean.getBoolean("org.netbeans.editor.dnd.disabled");
    static final long serialVersionUID = 0L;
    @NonNull
    private GapList<CaretItem> caretItems;
    @NonNull
    private GapList<CaretItem> sortedCaretItems;
    private List<CaretInfo> caretInfos;
    private List<CaretInfo> sortedCaretInfos;
    private JTextComponent component;
    private boolean overwriteMode;
    private final ListenerList<EditorCaretListener> listenerList;
    private final ListenerList<ChangeListener> changeListenerList;
    private final ListenerImpl listenerImpl;
    private boolean visible;
    private boolean showing;
    private boolean selectionVisible;
    private CaretType type = CaretType.THICK_LINE_CARET;
    private int thickCaretWidth = 2;
    private MouseState mouseState = MouseState.DEFAULT;
    private int blinkDefaultDelay;
    private int blinkCurrentDelay;
    private long lastBlinkTime;
    private Timer blinkTimer;
    private ActionListener weakTimerListener;
    private Action selectWordAction;
    private Action selectLineAction;
    private AbstractDocument activeDoc;
    private Thread lockThread;
    private int lockDepth;
    private CaretTransaction activeTransaction;
    private boolean scrollToLastCaret;
    private transient boolean inAtomicSection = false;
    private transient boolean inAtomicUnlock = false;
    private int atomicSectionImplicitSetDotOffset;
    private boolean atomicSectionAnyCaretChange;
    private transient int atomicSectionStartChangeOffset;
    private transient int atomicSectionEndChangeOffset;
    private Preferences prefs = null;
    private PreferenceChangeListener weakPrefsListener = null;
    private boolean caretUpdatePending;
    private boolean updateLaterDuringPaint;
    private int minSelectionStartOffset;
    private int minSelectionEndOffset;
    private boolean rectangularSelection;
    private Rectangle rsDotRect;
    private Rectangle rsMarkRect;
    private Rectangle rsPaintRect;
    private List<Position> rsRegions;
    private boolean showingTextCursor = true;
    private int lastCaretVisualOffset = -1;

    public EditorCaret() {
        this.caretItems = new GapList();
        this.sortedCaretItems = new GapList();
        CaretItem singleCaret = new CaretItem(this, null, Position.Bias.Forward, null, Position.Bias.Forward);
        this.caretItems.add((Object)singleCaret);
        this.sortedCaretItems.add((Object)singleCaret);
        this.listenerList = new ListenerList();
        this.changeListenerList = new ListenerList();
        this.listenerImpl = new ListenerImpl();
    }

    @Override
    public int getDot() {
        return this.getLastCaret().getDot();
    }

    @NonNull
    public Position.Bias getDotBias() {
        return this.getLastCaret().getDotBias();
    }

    @Override
    public int getMark() {
        return this.getLastCaret().getMark();
    }

    @NonNull
    public Position.Bias getMarkBias() {
        return this.getLastCaret().getMarkBias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<CaretInfo> getCarets() {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            if (this.caretInfos == null) {
                int i = this.caretItems.size();
                Object[] infos = new CaretInfo[i--];
                while (i >= 0) {
                    infos[i] = ((CaretItem)this.caretItems.get(i)).getValidInfo();
                    --i;
                }
                this.caretInfos = ArrayUtilities.unmodifiableList((Object[])infos);
            }
            return this.caretInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<CaretInfo> getSortedCarets() {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            if (this.sortedCaretInfos == null) {
                int i = this.sortedCaretItems.size();
                Object[] sortedInfos = new CaretInfo[i--];
                while (i >= 0) {
                    sortedInfos[i] = ((CaretItem)this.sortedCaretItems.get(i)).getValidInfo();
                    --i;
                }
                this.sortedCaretInfos = ArrayUtilities.unmodifiableList((Object[])sortedInfos);
            }
            return this.sortedCaretInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CaretInfo getLastCaret() {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            return ((CaretItem)this.caretItems.get(this.caretItems.size() - 1)).getValidInfo();
        }
    }

    @CheckForNull
    public CaretInfo getCaretAt(int offset) {
        return null;
    }

    @Override
    public void setDot(int offset) {
        this.setDot(offset, Position.Bias.Forward, MoveCaretsOrigin.DEFAULT);
    }

    public void setDot(final int offset, Position.Bias bias, MoveCaretsOrigin origin) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("EditorCaret.setDot: offset=" + offset + ", bias=" + bias + ", origin=" + origin + "\n");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "    setDot call stack\n", new Exception());
            }
        }
        this.runTransaction(CaretTransaction.RemoveType.RETAIN_LAST_CARET, 0, null, new CaretMoveHandler(){

            @Override
            public void moveCarets(CaretMoveContext context) {
                Document doc = context.getComponent().getDocument();
                if (doc != null) {
                    try {
                        Position pos = doc.createPosition(offset);
                        context.setDot(context.getOriginalLastCaret(), pos, Position.Bias.Forward);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }, origin);
    }

    @Override
    public void moveDot(int offset) {
        this.moveDot(offset, Position.Bias.Forward, MoveCaretsOrigin.DEFAULT);
    }

    public void moveDot(final int offset, Position.Bias bias, MoveCaretsOrigin origin) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("EditorCaret.moveDot: offset=" + offset + ", bias=" + bias + ", origin=" + origin + "\n");
        }
        this.runTransaction(CaretTransaction.RemoveType.NO_REMOVE, 0, null, new CaretMoveHandler(){

            @Override
            public void moveCarets(CaretMoveContext context) {
                Document doc = context.getComponent().getDocument();
                if (doc != null) {
                    try {
                        Position pos = doc.createPosition(offset);
                        context.moveDot(context.getOriginalLastCaret(), pos, Position.Bias.Forward);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }, origin);
    }

    public int moveCarets(@NonNull CaretMoveHandler moveHandler) {
        Parameters.notNull((CharSequence)"moveHandler", (Object)moveHandler);
        return this.runTransaction(CaretTransaction.RemoveType.NO_REMOVE, 0, null, moveHandler);
    }

    public int moveCarets(@NonNull CaretMoveHandler moveHandler, MoveCaretsOrigin origin) {
        Parameters.notNull((CharSequence)"moveHandler", (Object)moveHandler);
        if (origin == null) {
            origin = MoveCaretsOrigin.DEFAULT;
        }
        return this.runTransaction(CaretTransaction.RemoveType.NO_REMOVE, 0, null, moveHandler, origin);
    }

    public int addCaret(@NonNull Position dotPos, @NonNull Position.Bias dotBias, @NonNull Position markPos, @NonNull Position.Bias markBias) {
        return this.runTransaction(CaretTransaction.RemoveType.NO_REMOVE, 0, new CaretItem[]{new CaretItem(this, dotPos, dotBias, markPos, markBias)}, null);
    }

    public int addCarets(@NonNull List<Position> dotAndMarkPosPairs, List<Position.Bias> dotAndMarkBiases) {
        return this.runTransaction(CaretTransaction.RemoveType.NO_REMOVE, 0, CaretTransaction.asCaretItems(this, dotAndMarkPosPairs, dotAndMarkBiases), null);
    }

    public int replaceCarets(@NonNull List<Position> dotAndMarkPosPairs, List<Position.Bias> dotAndMarkBiases) {
        if (dotAndMarkPosPairs.isEmpty()) {
            throw new IllegalArgumentException("dotAndSelectionStartPosPairs list must not be empty");
        }
        CaretItem[] addedItems = CaretTransaction.asCaretItems(this, dotAndMarkPosPairs, dotAndMarkBiases);
        return this.runTransaction(CaretTransaction.RemoveType.REMOVE_ALL_CARETS, 0, addedItems, null);
    }

    public int removeLastCaret() {
        return this.runTransaction(CaretTransaction.RemoveType.REMOVE_LAST_CARET, 0, null, null);
    }

    public int retainLastCaretOnly() {
        return this.runTransaction(CaretTransaction.RemoveType.RETAIN_LAST_CARET, 0, null, null);
    }

    public void addEditorCaretListener(@NonNull EditorCaretListener listener) {
        this.listenerList.add((EventListener)listener);
    }

    @Override
    public void addChangeListener(@NonNull ChangeListener l) {
        this.changeListenerList.add((EventListener)l);
    }

    public void removeEditorCaretListener(@NonNull EditorCaretListener listener) {
        this.listenerList.remove((EventListener)listener);
    }

    @Override
    public void removeChangeListener(@NonNull ChangeListener l) {
        this.changeListenerList.remove((EventListener)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVisible() {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            return this.visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean visible) {
        boolean log = LOG.isLoggable(Level.FINE);
        if (log && LOG.isLoggable(Level.FINER)) {
            LOG.finer("EditorCaret.setVisible(" + visible + ")\n");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "", new Exception());
            }
        }
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            if (this.blinkTimer != null) {
                if (this.visible && !visible) {
                    this.blinkTimer.stop();
                    this.setShowing(false);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("    " + (visible ? "Starting" : "Stopping") + " the caret blinking timer: " + this.dumpVisibility() + '\n');
                }
                this.visible = visible;
                if (visible) {
                    this.setShowing(true);
                    this.blinkTimer.start();
                } else {
                    this.blinkTimer.stop();
                }
            }
        }
        JTextComponent c = this.component;
        if (c != null) {
            List<CaretInfo> sortedCarets = this.getSortedCarets();
            int sortedCaretsSize = sortedCarets.size();
            for (int i = 0; i < sortedCaretsSize; ++i) {
                CaretInfo caret = sortedCarets.get(i);
                CaretItem caretItem = caret.getCaretItem();
                caretItem.repaintIfShowing(c, "setVisible", i);
            }
        }
    }

    @Override
    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    @Override
    public void setSelectionVisible(boolean v) {
        Document doc;
        if (this.selectionVisible == v) {
            return;
        }
        JTextComponent c = this.component;
        if (c != null && (doc = c.getDocument()) != null) {
            this.selectionVisible = v;
        }
    }

    @Override
    public void install(JTextComponent c) {
        assert (SwingUtilities.isEventDispatchThread());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("EditorCaret.install: Installing to " + EditorCaret.s2s(c) + "\n");
        }
        this.component = c;
        this.setVisible(c.hasFocus());
        this.modelChanged(null, c.getDocument());
        Boolean b = (Boolean)c.getClientProperty("caret-overwrite-mode");
        this.overwriteMode = b != null ? b : false;
        this.updateOverwriteModeLayer(true);
        this.requestUpdateAllCaretsBounds();
        if (this.getLastCaretItem().getCaretBounds() == null) {
            this.component.addComponentListener(this.listenerImpl);
        }
        this.component.addPropertyChangeListener(this.listenerImpl);
        this.component.addFocusListener(this.listenerImpl);
        this.component.addMouseListener(this.listenerImpl);
        this.component.addMouseMotionListener(this.listenerImpl);
        this.component.addKeyListener(this.listenerImpl);
        ViewHierarchy.get(this.component).addViewHierarchyListener(this.listenerImpl);
        EditorCaretTransferHandler.install(this.component);
        if (this.component.hasFocus()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("    Component has focus, calling EditorCaret.focusGained(); doc=" + this.component.getDocument().getProperty("title") + '\n');
            }
            this.listenerImpl.focusGained(null);
        }
        this.invalidateCaretBounds(0, Integer.MAX_VALUE);
        this.dispatchUpdate(false);
        this.resetBlink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(JTextComponent c) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("EditorCaret.deinstall: Deinstalling from " + EditorCaret.s2s(c) + "\n");
        }
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            if (this.blinkTimer != null) {
                this.setBlinkRate(0);
            }
        }
        c.removeComponentListener(this.listenerImpl);
        c.removePropertyChangeListener(this.listenerImpl);
        c.removeFocusListener(this.listenerImpl);
        c.removeMouseListener(this.listenerImpl);
        c.removeMouseMotionListener(this.listenerImpl);
        ViewHierarchy.get(c).removeViewHierarchyListener(this.listenerImpl);
        this.modelChanged(this.activeDoc, null);
    }

    private synchronized void maybeSaveCaretOffset(Rectangle cbounds) {
        Rectangle editorRect;
        if (this.component.getClientProperty("editorcaret.updateRetainsVisibleOnce") == null || this.lastCaretVisualOffset != -1) {
            return;
        }
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            editorRect = viewport.getViewRect();
        } else {
            Dimension size = this.component.getSize();
            editorRect = new Rectangle(0, 0, size.width, size.height);
        }
        if (cbounds.y >= editorRect.y && cbounds.y < editorRect.y + editorRect.height) {
            this.lastCaretVisualOffset = cbounds.y - editorRect.y;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("EditorCaret: saving caret offset. Bounds = " + cbounds + ", editor = " + editorRect + ", offset = " + this.lastCaretVisualOffset);
            }
        } else if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("EditorCaret: caret is off screen. Bounds = " + cbounds + ", editor = " + editorRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        block29: {
            JTextComponent c = this.component;
            if (c == null || !this.isShowing()) {
                return;
            }
            if (this.updateLaterDuringPaint) {
                this.updateLaterDuringPaint = false;
                this.update(true);
            }
            Color origColor = g.getColor();
            try {
                g.setColor(c.getCaretColor());
                Rectangle clipBounds = g.getClipBounds();
                LockedViewHierarchy lvh = ViewHierarchy.get(c).lock();
                try {
                    int clipStartOffset = lvh.yToParagraphStartOffset(clipBounds.y);
                    List<CaretInfo> sortedCarets = this.getSortedCarets();
                    CaretItem lastCaret = this.getLastCaretItem();
                    int low = 0;
                    int caretsSize = sortedCarets.size();
                    if (caretsSize > 1) {
                        int high = caretsSize - 1;
                        while (low <= high) {
                            int mid = low + high >>> 1;
                            CaretInfo midCaretInfo = sortedCarets.get(mid);
                            int midDot = midCaretInfo.getDot();
                            if (midDot < clipStartOffset) {
                                low = mid + 1;
                                continue;
                            }
                            if (midDot > clipStartOffset) {
                                high = mid - 1;
                                continue;
                            }
                            low = mid;
                            break;
                        }
                    }
                    for (int i = low; i < caretsSize; ++i) {
                        Rectangle caretBounds;
                        CaretInfo caretInfo = sortedCarets.get(i);
                        CaretItem caretItem = caretInfo.getCaretItem();
                        if (caretItem.getAndClearUpdateCaretBounds()) {
                            int dot = caretItem.getDot();
                            Rectangle newCaretBounds = lvh.modelToViewBounds(dot, Position.Bias.Forward);
                            Rectangle oldBounds = caretItem.setCaretBoundsWithRepaint(newCaretBounds, c, "EditorCaret.paint()", i);
                            if (caretItem == lastCaret && oldBounds != null) {
                                this.maybeSaveCaretOffset(oldBounds);
                            }
                        }
                        if ((caretBounds = caretItem.getCaretBounds()) == null) continue;
                        if (caretBounds.y > clipBounds.y + clipBounds.height) {
                            break;
                        }
                        boolean painted = false;
                        switch (this.type) {
                            case THICK_LINE_CARET: {
                                g.fillRect(caretBounds.x, caretBounds.y, this.thickCaretWidth, caretBounds.height - 1);
                                painted = true;
                                break;
                            }
                            case THIN_LINE_CARET: {
                                int upperX = caretBounds.x;
                                g.drawLine(upperX, caretBounds.y, caretBounds.x, caretBounds.y + caretBounds.height - 1);
                                painted = true;
                                break;
                            }
                            case BLOCK_CARET: {
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid caret type=" + (Object)((Object)this.type));
                            }
                        }
                        if (!painted) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("EditorCaret.paint: caretItem[" + i + "] item=" + caretItem.toStringDetail() + "\n");
                        }
                        caretItem.markCaretPainted();
                    }
                }
                finally {
                    lvh.unlock();
                }
                if (!this.rectangularSelection || this.rsPaintRect == null || !(g instanceof Graphics2D)) break block29;
                Graphics2D g2d = (Graphics2D)g;
                BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 2.0f}, 0.0f);
                Stroke origStroke = g2d.getStroke();
                try {
                    Color selColor = c.getSelectionColor();
                    g2d.setColor(selColor);
                    Composite origComposite = g2d.getComposite();
                    try {
                        g2d.setComposite(AlphaComposite.SrcOver.derive(0.2f));
                        g2d.fill(this.rsPaintRect);
                    }
                    finally {
                        g2d.setComposite(origComposite);
                    }
                    g.setColor(c.getCaretColor());
                    g2d.setStroke(stroke);
                    Rectangle onePointSmallerRect = new Rectangle(this.rsPaintRect);
                    --onePointSmallerRect.width;
                    --onePointSmallerRect.height;
                    g2d.draw(onePointSmallerRect);
                }
                finally {
                    g2d.setStroke(origStroke);
                }
            }
            finally {
                g.setColor(origColor);
            }
        }
    }

    @Override
    public void setMagicCaretPosition(final Point p) {
        this.runTransaction(CaretTransaction.RemoveType.NO_REMOVE, 0, null, new CaretMoveHandler(){

            @Override
            public void moveCarets(CaretMoveContext context) {
                context.setMagicCaretPosition(context.getOriginalLastCaret(), p);
            }
        }, MoveCaretsOrigin.DISABLE_FILTERS);
    }

    @Override
    public final Point getMagicCaretPosition() {
        return this.getLastCaretItem().getMagicCaretPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlinkRate(int rate) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("EditorCaret.setBlinkRate(" + rate + ") " + this.dumpVisibility() + '\n');
        }
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            this.blinkDefaultDelay = rate;
            this.blinkCurrentDelay = rate;
            if (this.blinkTimer == null && rate > 0) {
                this.blinkTimer = new Timer(rate, null);
                this.weakTimerListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listenerImpl, (Object)this.blinkTimer);
                this.blinkTimer.addActionListener(this.weakTimerListener);
            }
            if (this.blinkTimer != null) {
                if (rate > 0) {
                    if (this.blinkTimer.getDelay() != rate) {
                        this.blinkTimer.setInitialDelay(rate);
                        this.blinkTimer.setDelay(rate);
                    }
                } else {
                    this.blinkTimer.stop();
                    if (this.weakTimerListener != null) {
                        this.blinkTimer.removeActionListener(this.weakTimerListener);
                    }
                    this.blinkTimer = null;
                    this.setShowing(true);
                    LOG.finer("    Zero blink rate - no blinking. blinkTimer=null; showing=true\n");
                }
            }
        }
    }

    @CheckForNull
    public static NavigationFilter getNavigationFilter(@NonNull JTextComponent component, @NonNull MoveCaretsOrigin origin) {
        Parameters.notNull((CharSequence)"origin", (Object)origin);
        if (origin == MoveCaretsOrigin.DEFAULT) {
            return component.getNavigationFilter();
        }
        if (origin == MoveCaretsOrigin.DISABLE_FILTERS) {
            return null;
        }
        NavigationFilter navi = EditorCaret.doGetNavigationFilter(component, origin.getActionType());
        return navi != null ? navi : EditorCaret.getChainNavigationFilter(component);
    }

    @CheckForNull
    NavigationFilter getNavigationFilterNoDefault(@NonNull MoveCaretsOrigin origin) {
        if (origin == MoveCaretsOrigin.DEFAULT) {
            return this.component.getNavigationFilter();
        }
        if (origin == MoveCaretsOrigin.DISABLE_FILTERS) {
            return null;
        }
        NavigationFilter navi2 = EditorCaret.doGetNavigationFilter(this.component, origin.getActionType());
        return navi2 != null ? navi2 : this.component.getNavigationFilter();
    }

    public static void setNavigationFilter(JTextComponent component, MoveCaretsOrigin origin, @NullAllowed NavigationFilter naviFilter) {
        if (origin == null) {
            origin = MoveCaretsOrigin.DEFAULT;
        }
        NavigationFilter prev = EditorCaret.getNavigationFilter(component, origin);
        if (naviFilter != null) {
            if (!(naviFilter instanceof CascadingNavigationFilter)) {
                final NavigationFilter del = naviFilter;
                naviFilter = new CascadingNavigationFilter(){

                    @Override
                    public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                        del.setDot(fb, dot, bias);
                    }

                    @Override
                    public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                        del.moveDot(fb, dot, bias);
                    }

                    @Override
                    public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                        return del.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
                    }
                };
            }
            ((CascadingNavigationFilter)naviFilter).setOwnerAndPrevious(component, origin, prev);
        }
        if (MoveCaretsOrigin.DEFAULT == origin) {
            component.setNavigationFilter(naviFilter);
        } else {
            EditorCaret.doPutNavigationFilter(component, origin.getActionType(), prev);
        }
    }

    private static NavigationFilter getChainNavigationFilter(JTextComponent component) {
        NavigationFilter chain = (NavigationFilter)component.getClientProperty(CHAIN_FILTER_PROPERTY);
        if (chain == null) {
            chain = new ChainNavigationFilter(component);
            component.putClientProperty(CHAIN_FILTER_PROPERTY, chain);
        }
        return chain;
    }

    private static void doPutNavigationFilter(JTextComponent component, String type, NavigationFilter n) {
        if (component == null) {
            throw new IllegalStateException("Not attached to a Component");
        }
        HashMap<String, NavigationFilter> m = (HashMap<String, NavigationFilter>)component.getClientProperty(NAVIGATION_FILTER_PROPERTY);
        if (m == null) {
            if (n == null) {
                return;
            }
            m = new HashMap<String, NavigationFilter>();
            component.putClientProperty(NAVIGATION_FILTER_PROPERTY, m);
        }
        if (n == null) {
            m.remove(type);
        } else {
            m.put(type, n);
        }
    }

    private static NavigationFilter doGetNavigationFilter(JTextComponent component, String n) {
        if (component == null) {
            throw new IllegalStateException("Not attached to a Component");
        }
        Map m = (Map)component.getClientProperty(NAVIGATION_FILTER_PROPERTY);
        return m == null ? null : (NavigationFilter)m.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlinkRate() {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            return this.blinkDefaultDelay;
        }
    }

    void setRectangularSelectionToDotAndMark() {
        int dotOffset = this.getDot();
        int markOffset = this.getMark();
        try {
            this.rsDotRect = this.component.modelToView(dotOffset);
            this.rsMarkRect = this.component.modelToView(markOffset);
        }
        catch (BadLocationException ex) {
            this.rsMarkRect = null;
            this.rsDotRect = null;
        }
        this.updateRectangularSelectionPaintRect();
    }

    void updateRectangularUpDownSelection() {
        JTextComponent c = this.component;
        int dotOffset = this.getDot();
        try {
            Rectangle r = c.modelToView(dotOffset);
            this.rsDotRect.y = r.y;
            this.rsDotRect.height = r.height;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extendRectangularSelection(boolean toRight, boolean ctrl) {
        float charWidth;
        JTextComponent c = this.component;
        Document doc = c.getDocument();
        int dotOffset = this.getDot();
        Element lineRoot = doc.getDefaultRootElement();
        int lineIndex = lineRoot.getElementIndex(dotOffset);
        Element lineElement = lineRoot.getElement(lineIndex);
        LockedViewHierarchy lvh = ViewHierarchy.get(c).lock();
        try {
            charWidth = lvh.getDefaultCharWidth();
        }
        finally {
            lvh.unlock();
        }
        int newDotOffset = -1;
        try {
            int newlineOffset = lineElement.getEndOffset() - 1;
            Rectangle newlineRect = c.modelToView(newlineOffset);
            if (!ctrl) {
                if (toRight) {
                    if (this.rsDotRect.x < newlineRect.x) {
                        newDotOffset = dotOffset + 1;
                    } else {
                        this.rsDotRect.x = (int)((float)this.rsDotRect.x + charWidth);
                    }
                } else if (this.rsDotRect.x > newlineRect.x) {
                    this.rsDotRect.x = (int)((float)this.rsDotRect.x - charWidth);
                    if (this.rsDotRect.x < newlineRect.x) {
                        newDotOffset = newlineOffset;
                    }
                } else {
                    newDotOffset = Math.max(dotOffset - 1, lineElement.getStartOffset());
                }
            } else {
                LineDocument lineDoc = (LineDocument)LineDocumentUtils.asRequired((Document)doc, LineDocument.class);
                int numVirtualChars = 8;
                if (toRight) {
                    if (this.rsDotRect.x < newlineRect.x) {
                        newDotOffset = Math.min(LineDocumentUtils.getNextWordStart((LineDocument)lineDoc, (int)dotOffset), lineElement.getEndOffset() - 1);
                    } else {
                        this.rsDotRect.x = (int)((float)this.rsDotRect.x + (float)numVirtualChars * charWidth);
                    }
                } else if (this.rsDotRect.x > newlineRect.x) {
                    this.rsDotRect.x = (int)((float)this.rsDotRect.x - (float)numVirtualChars * charWidth);
                    if (this.rsDotRect.x < newlineRect.x) {
                        newDotOffset = newlineOffset;
                    }
                } else {
                    newDotOffset = Math.max(LineDocumentUtils.getPreviousWordStart((LineDocument)lineDoc, (int)dotOffset), lineElement.getStartOffset());
                }
            }
            if (newDotOffset != -1) {
                this.rsDotRect = c.modelToView(newDotOffset);
                this.moveDot(newDotOffset);
            } else {
                this.updateRectangularSelectionPaintRect();
                this.fireStateChanged(null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    GapList<CaretItem> getCaretItems() {
        return this.caretItems;
    }

    GapList<CaretItem> getSortedCaretItems() {
        return this.sortedCaretItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureValidInfo(CaretItem caretItem) {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            caretItem.ensureValidInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaretItem getLastCaretItem() {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            return (CaretItem)this.caretItems.get(this.caretItems.size() - 1);
        }
    }

    private int runTransaction(CaretTransaction.RemoveType removeType, int offset, CaretItem[] addCarets, CaretMoveHandler moveHandler) {
        return this.runTransaction(removeType, offset, addCarets, moveHandler, MoveCaretsOrigin.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTransaction(CaretTransaction.RemoveType removeType, int offset, CaretItem[] addCarets, CaretMoveHandler moveHandler, MoveCaretsOrigin org) {
        this.lock();
        try {
            if (this.activeTransaction == null) {
                JTextComponent c = this.component;
                AbstractDocument d = this.activeDoc;
                if (c != null && d != null) {
                    this.activeTransaction = new CaretTransaction(this, c, d, org);
                    if (LOG.isLoggable(Level.FINE)) {
                        StringBuilder msgBuilder = new StringBuilder(200);
                        msgBuilder.append("EditorCaret.runTransaction: removeType=").append((Object)removeType).append(", offset=").append(offset);
                        if (addCarets != null) {
                            msgBuilder.append(", addCarets:");
                            for (int i = 0; i < addCarets.length; ++i) {
                                msgBuilder.append("\n    [").append(i).append("]: ").append(addCarets[i]);
                            }
                        }
                        msgBuilder.append("\n    moveHandler=").append(moveHandler).append('\n');
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, msgBuilder.toString(), new Exception());
                        } else {
                            LOG.log(Level.FINE, msgBuilder.toString());
                        }
                    }
                    try {
                        CaretFoldExpander caretFoldExpander;
                        List<Position> expandFoldPositions;
                        boolean inAtomicSectionL;
                        this.activeTransaction.replaceCarets(removeType, offset, addCarets);
                        if (moveHandler != null) {
                            this.activeTransaction.runCaretMoveHandler(moveHandler);
                        }
                        this.activeTransaction.removeOverlappingRegions();
                        int diffCount = 0;
                        ListenerList<EditorCaretListener> listenerList = this.listenerList;
                        synchronized (listenerList) {
                            inAtomicSectionL = this.inAtomicSection;
                            GapList<CaretItem> replaceItems = this.activeTransaction.getReplaceItems();
                            if (replaceItems != null) {
                                this.caretItems = replaceItems;
                                diffCount = replaceItems.size() - this.caretItems.size();
                                this.sortedCaretItems = this.activeTransaction.getSortedCaretItems();
                                assert (this.sortedCaretItems != null) : "Null sortedCaretItems! removeType=" + (Object)((Object)removeType);
                            }
                            boolean chg = false;
                            if (this.activeTransaction.isDotOrStructuralChange()) {
                                this.caretInfos = null;
                                this.sortedCaretInfos = null;
                                if (inAtomicSectionL) {
                                    this.atomicSectionAnyCaretChange = true;
                                }
                                chg = true;
                            } else if (this.activeTransaction.isMagicPosChange()) {
                                this.caretInfos = null;
                                this.sortedCaretInfos = null;
                                chg = true;
                            }
                            if (chg) {
                                for (CaretItem caretItem : this.caretItems) {
                                    if (!caretItem.getAndClearInfoObsolete()) continue;
                                    caretItem.clearInfo();
                                }
                            }
                            this.scrollToLastCaret |= this.activeTransaction.isScrollToLastCaret();
                            expandFoldPositions = this.activeTransaction.expandFoldPositions();
                        }
                        GapList<CaretItem> removedItems = this.activeTransaction.allRemovedItems();
                        if (removedItems != null) {
                            for (CaretItem removedItem : removedItems) {
                                removedItem.repaintIfShowing(c, "runTransaction-repaintRemovedItems", -1);
                            }
                        }
                        if (this.rectangularSelection) {
                            if (this.activeTransaction.isAnyMarkChanged()) {
                                this.setRectangularSelectionToDotAndMark();
                            } else {
                                try {
                                    Rectangle r = c.modelToView(this.getLastCaretItem().getDot());
                                    if (this.rsDotRect != null) {
                                        this.rsDotRect.y = r.y;
                                        this.rsDotRect.height = r.height;
                                    } else {
                                        this.rsDotRect = r;
                                    }
                                    this.updateRectangularSelectionPaintRect();
                                }
                                catch (BadLocationException r) {
                                    // empty catch block
                                }
                            }
                        }
                        if (expandFoldPositions != null && (caretFoldExpander = CaretFoldExpander.get()) != null) {
                            caretFoldExpander.checkExpandFolds(c, expandFoldPositions);
                        }
                        boolean updateDispatched = false;
                        if (this.activeTransaction.isDotOrStructuralChange() && !inAtomicSectionL) {
                            this.fireStateChanged(this.activeTransaction.getOrigin());
                            this.dispatchUpdate(false);
                            updateDispatched = true;
                            this.resetBlink();
                        }
                        if (this.activeTransaction.isScrollToLastCaret() && !updateDispatched) {
                            this.dispatchUpdate(false);
                        }
                        int n = diffCount;
                        return n;
                    }
                    finally {
                        this.activeTransaction = null;
                    }
                }
                int n = Integer.MIN_VALUE;
                return n;
            }
            switch (removeType) {
                case DOCUMENT_REMOVE: {
                    this.activeTransaction.documentRemove(offset);
                    break;
                }
                case DOCUMENT_INSERT_ZERO_OFFSET: {
                    this.activeTransaction.documentInsertAtZeroOffset(offset);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported removeType=" + (Object)((Object)removeType) + " in nested transaction"));
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    private void updateRectangularSelectionDotRect() {
        if (this.rectangularSelection) {
            Rectangle caretBounds = this.getLastCaretItem().getCaretBounds();
            if (caretBounds != null) {
                if (this.rsDotRect != null) {
                    this.rsDotRect.y = caretBounds.y;
                    this.rsDotRect.height = caretBounds.height;
                } else {
                    this.rsDotRect = caretBounds;
                }
            }
            this.updateRectangularSelectionPaintRect();
        }
    }

    private void fireEditorCaretChange(EditorCaretEvent evt) {
        for (EditorCaretListener listener : this.listenerList.getListeners()) {
            listener.caretChanged(evt);
        }
    }

    private void fireStateChanged(final MoveCaretsOrigin origin) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JTextComponent c = EditorCaret.this.component;
                if (c == null || c.getCaret() != EditorCaret.this) {
                    return;
                }
                EditorCaret.this.fireEditorCaretChange(new EditorCaretEvent(EditorCaret.this, 0, Integer.MAX_VALUE, origin));
                ChangeEvent evt = new ChangeEvent(EditorCaret.this);
                List listeners = EditorCaret.this.changeListenerList.getListeners();
                for (ChangeListener l : listeners) {
                    l.stateChanged(evt);
                }
            }
        };
        if (this.inAtomicUnlock) {
            SwingUtilities.invokeLater(runnable);
        } else {
            ViewUtils.runInEDT(runnable);
        }
        this.updateSystemSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        Thread curThread = Thread.currentThread();
        try {
            ListenerList<EditorCaretListener> listenerList = this.listenerList;
            synchronized (listenerList) {
                while (this.lockThread != null) {
                    if (curThread == this.lockThread) {
                        ++this.lockDepth;
                        return;
                    }
                    this.listenerList.wait();
                }
                this.lockThread = curThread;
                this.lockDepth = 1;
            }
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to acquire lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Thread curThread = Thread.currentThread();
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            if (this.lockThread == curThread) {
                --this.lockDepth;
                if (this.lockDepth == 0) {
                    this.lockThread = null;
                    this.listenerList.notifyAll();
                }
            } else {
                throw new IllegalStateException("Invalid thread called EditorCaret.unlock():  thread=" + curThread + ", lockThread=" + this.lockThread);
            }
        }
    }

    private void updateType() {
        JTextComponent c = this.component;
        if (c != null) {
            AttributeSet attribs;
            CaretType newType;
            boolean cIsTextField = Boolean.TRUE.equals(c.getClientProperty("AsTextField"));
            if (cIsTextField) {
                newType = CaretType.THIN_LINE_CARET;
            } else if (this.prefs != null) {
                String newTypeStr;
                if (this.overwriteMode) {
                    newTypeStr = this.prefs.get("caret-type-overwrite-mode", "block-caret");
                } else {
                    newTypeStr = this.prefs.get("caret-type-insert-mode", "thick-line-caret");
                    this.thickCaretWidth = this.prefs.getInt("thick-caret-width", 2);
                }
                newType = CaretType.decode(newTypeStr);
            } else {
                newType = CaretType.THICK_LINE_CARET;
            }
            this.type = newType;
            String mimeType = DocumentUtilities.getMimeType((JTextComponent)c);
            FontColorSettings fcs = mimeType != null ? (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class) : null;
            Color caretColor = Color.BLACK;
            if (fcs != null && (attribs = fcs.getFontColors(this.overwriteMode ? "caret-color-overwrite-mode" : "caret-color-insert-mode")) != null) {
                caretColor = (Color)attribs.getAttribute(StyleConstants.Foreground);
            }
            c.setCaretColor(caretColor);
            Preferences prefs = this.prefs;
            if (prefs != null) {
                int rate = prefs.getInt("caret-blink-rate", -1);
                if (rate == -1) {
                    rate = 300;
                }
                if (overrideCaretBlinkRate != null) {
                    rate = overrideCaretBlinkRate;
                }
                this.setBlinkRate(rate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestUpdateAllCaretsBounds() {
        AbstractDocument doc;
        JTextComponent c = this.component;
        if (c != null && (doc = this.activeDoc) != null) {
            doc.readLock();
            try {
                List<CaretInfo> sortedCarets = this.getSortedCarets();
                for (CaretInfo caret : sortedCarets) {
                    caret.getCaretItem().markUpdateCaretBounds();
                }
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private void modelChanged(Document oldDoc, Document newDoc) {
        if (oldDoc != null) {
            assert (oldDoc == this.activeDoc);
            DocumentUtilities.removeDocumentListener((Document)oldDoc, (DocumentListener)this.listenerImpl, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            AtomicLockDocument oldAtomicDoc = (AtomicLockDocument)LineDocumentUtils.as((Document)oldDoc, AtomicLockDocument.class);
            if (oldAtomicDoc != null) {
                oldAtomicDoc.removeAtomicLockListener((AtomicLockListener)this.listenerImpl);
            }
            this.activeDoc = null;
            if (this.prefs != null && this.weakPrefsListener != null) {
                this.prefs.removePreferenceChangeListener(this.weakPrefsListener);
            }
        }
        if (newDoc instanceof AbstractDocument) {
            CaretInfo lastCaret;
            Position dotPos;
            String mimeType = DocumentUtilities.getMimeType((Document)newDoc);
            this.activeDoc = (AbstractDocument)newDoc;
            DocumentUtilities.addDocumentListener((Document)newDoc, (DocumentListener)this.listenerImpl, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            AtomicLockDocument newAtomicDoc = (AtomicLockDocument)LineDocumentUtils.as((Document)newDoc, AtomicLockDocument.class);
            if (newAtomicDoc != null) {
                newAtomicDoc.addAtomicLockListener((AtomicLockListener)this.listenerImpl);
            }
            if ((dotPos = (lastCaret = this.getLastCaret()).getDotPosition()) == null) {
                dotPos = newDoc.getStartPosition();
            }
            this.runTransaction(CaretTransaction.RemoveType.REMOVE_ALL_CARETS, 0, new CaretItem[]{new CaretItem(this, dotPos, Position.Bias.Forward, null, Position.Bias.Forward)}, null);
            Preferences preferences = this.prefs = mimeType != null ? (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class) : null;
            if (this.prefs != null) {
                this.weakPrefsListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.listenerImpl, (Object)this.prefs);
                this.prefs.addPreferenceChangeListener(this.weakPrefsListener);
            }
            this.updateType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchUpdate(boolean forceInvokeLater) {
        boolean alreadyPending;
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            alreadyPending = this.caretUpdatePending;
            this.caretUpdatePending = true;
        }
        if (!alreadyPending) {
            Runnable updateRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractDocument doc = EditorCaret.this.activeDoc;
                    if (doc != null) {
                        doc.readLock();
                        try {
                            EditorCaret.this.update(false);
                        }
                        finally {
                            doc.readUnlock();
                        }
                    }
                    ListenerList listenerList = EditorCaret.this.listenerList;
                    synchronized (listenerList) {
                        EditorCaret.this.caretUpdatePending = false;
                    }
                }
            };
            if (!forceInvokeLater && SwingUtilities.isEventDispatchThread()) {
                updateRunnable.run();
            } else {
                SwingUtilities.invokeLater(updateRunnable);
            }
        }
    }

    private boolean isWrapping() {
        Object lwt = null;
        if (this.component != null && (lwt = this.component.getClientProperty("text-line-wrap")) == null) {
            lwt = this.component.getDocument().getProperty("text-line-wrap");
        }
        return lwt instanceof String && !"none".equals(lwt);
    }

    private JViewport getViewport() {
        Container parent = this.component.getParent();
        if (parent instanceof JLayeredPane) {
            parent = parent.getParent();
        }
        return parent instanceof JViewport ? (JViewport)parent : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean calledFromPaint) {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            this.caretUpdatePending = false;
        }
        final JTextComponent c = this.component;
        if (c != null) {
            Rectangle cbounds;
            Rectangle editorRect;
            boolean forceUpdate = c.getClientProperty("editorcaret.updateRetainsVisibleOnce") != null;
            boolean log = LOG.isLoggable(Level.FINE);
            JViewport viewport = this.getViewport();
            if (viewport != null) {
                editorRect = viewport.getViewRect();
            } else {
                Dimension size = c.getSize();
                editorRect = new Rectangle(0, 0, size.width, size.height);
            }
            if (forceUpdate && (cbounds = this.getLastCaretItem().getCaretBounds()) != null) {
                this.maybeSaveCaretOffset(cbounds);
                if (log) {
                    LOG.fine("EditorCaret.update: forced:true, savedBounds=" + cbounds + ", relativeOffset=" + this.lastCaretVisualOffset + "\n");
                }
            }
            if (!calledFromPaint && !c.isValid()) {
                this.updateLaterDuringPaint = true;
                return;
            }
            Document doc = c.getDocument();
            if (doc != null) {
                if (log) {
                    LOG.fine("EditorCaret.update: editorRect=" + editorRect + "\n");
                }
                LockedViewHierarchy lvh = ViewHierarchy.get(c).lock();
                try {
                    boolean scroll;
                    List<CaretInfo> sortedCarets;
                    CaretItem lastCaretItem;
                    ListenerList<EditorCaretListener> listenerList2 = this.listenerList;
                    synchronized (listenerList2) {
                        lastCaretItem = this.getLastCaretItem();
                        sortedCarets = this.getSortedCarets();
                        scroll = this.scrollToLastCaret;
                        this.scrollToLastCaret = false;
                    }
                    if (this.lastCaretVisualOffset == -1) {
                        forceUpdate = false;
                        c.putClientProperty("editorcaret.updateRetainsVisibleOnce", null);
                    }
                    if (scroll || forceUpdate) {
                        Rectangle oldCaretBounds;
                        Rectangle caretBounds;
                        if (lastCaretItem.getAndClearUpdateCaretBounds()) {
                            caretBounds = lvh.modelToViewBounds(lastCaretItem.getDot(), Position.Bias.Forward);
                            oldCaretBounds = lastCaretItem.setCaretBoundsWithRepaint(caretBounds, c, "update()-last-for-scroll", -2);
                        } else {
                            oldCaretBounds = caretBounds = lastCaretItem.getCaretBounds();
                        }
                        if (log) {
                            LOG.fine("EditorCaret.update: caretBounds=" + caretBounds + "\n");
                            LOG.fine("EditorCaret.update: oldCaretBounds=" + oldCaretBounds + "\n");
                        }
                        if (caretBounds != null) {
                            JScrollBar hScrollBar;
                            Container scrollPane;
                            Rectangle scrollBounds = new Rectangle(caretBounds);
                            if (viewport != null && this.isWrapping() && scrollBounds.x <= viewport.getExtentSize().width) {
                                scrollBounds.x = 0;
                                scrollBounds.width = 1;
                                if (viewport.getViewPosition().x > 0 && this.getDot() == this.getMark()) {
                                    this.mouseState = MouseState.DEFAULT;
                                }
                            }
                            if (oldCaretBounds == null && viewport != null && (scrollPane = viewport.getParent()) instanceof JScrollPane && (hScrollBar = ((JScrollPane)scrollPane).getHorizontalScrollBar()) != null) {
                                int hScrollBarHeight = hScrollBar.getPreferredSize().height;
                                Dimension extentSize = viewport.getExtentSize();
                                if (extentSize.height >= caretBounds.height + hScrollBarHeight) {
                                    scrollBounds = new Rectangle(scrollBounds);
                                    scrollBounds.height += hScrollBarHeight;
                                }
                            }
                            if (forceUpdate && oldCaretBounds != null) {
                                c.putClientProperty("editorcaret.updateRetainsVisibleOnce", null);
                                if (this.lastCaretVisualOffset >= 0) {
                                    scrollBounds = new Rectangle(caretBounds.x, caretBounds.y - this.lastCaretVisualOffset, scrollBounds.width, editorRect.height);
                                }
                                this.lastCaretVisualOffset = -1;
                            }
                            if (editorRect == null || !editorRect.contains(scrollBounds)) {
                                Rectangle visibleBounds = c.getVisibleRect();
                                if (!(forceUpdate || caretBounds.y <= visibleBounds.y + visibleBounds.height + caretBounds.height && caretBounds.y + caretBounds.height >= visibleBounds.y - caretBounds.height)) {
                                    scrollBounds.y -= (visibleBounds.height - caretBounds.height) / 2;
                                    scrollBounds.height = visibleBounds.height;
                                }
                                Dimension size = c.getSize();
                                if (scrollBounds.x + scrollBounds.width <= size.width && scrollBounds.y + scrollBounds.height <= size.height) {
                                    c.scrollRectToVisible(scrollBounds);
                                } else {
                                    final Rectangle finalScrollBounds = scrollBounds;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            c.scrollRectToVisible(finalScrollBounds);
                                        }
                                    });
                                }
                                this.dispatchUpdate(true);
                                return;
                            }
                            if (log && LOG.isLoggable(Level.FINER)) {
                                LOG.finer("EditorCaret.update: Scrolling to: " + scrollBounds + "\n");
                            }
                        }
                    }
                    int editorRectStartOffset = lvh.yToParagraphStartOffset(editorRect != null ? (double)editorRect.y : 0.0);
                    int editorRectEndY = editorRect != null ? editorRect.y + editorRect.height : Integer.MAX_VALUE;
                    int low = 0;
                    int caretsSize = sortedCarets.size();
                    if (caretsSize > 1) {
                        int high = caretsSize - 1;
                        while (low <= high) {
                            int mid = low + high >>> 1;
                            CaretInfo midCaretInfo = sortedCarets.get(mid);
                            int midDot = midCaretInfo.getDot();
                            if (midDot < editorRectStartOffset) {
                                low = mid + 1;
                                continue;
                            }
                            if (midDot > editorRectStartOffset) {
                                high = mid - 1;
                                continue;
                            }
                            low = mid;
                            break;
                        }
                    }
                    for (int i = low; i < caretsSize; ++i) {
                        CaretInfo caretInfo = sortedCarets.get(i);
                        CaretItem caretItem = caretInfo.getCaretItem();
                        Rectangle caretBounds = null;
                        if (caretItem.getAndClearUpdateCaretBounds()) {
                            caretBounds = lvh.modelToViewBounds(caretItem.getDot(), Position.Bias.Forward);
                            caretItem.setCaretBoundsWithRepaint(caretBounds, c, "EditorCaret.update()", i);
                        }
                        if (i <= 0) continue;
                        if (caretBounds == null) {
                            caretBounds = caretItem.getCaretBounds();
                        }
                        if (caretBounds == null || caretBounds.y <= editorRectEndY) continue;
                        break;
                    }
                }
                finally {
                    lvh.unlock();
                }
            }
        }
    }

    void invalidateCaretBounds(int startOffset, int endOffset) {
        List<CaretInfo> sortedCarets = this.getSortedCarets();
        int low = 0;
        int caretsSize = sortedCarets.size();
        if (startOffset > 0 && caretsSize > 1) {
            int high = caretsSize - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                CaretInfo midCaretInfo = sortedCarets.get(mid);
                int midMinOffset = midCaretInfo.getSelectionStart();
                if (midMinOffset < startOffset) {
                    low = mid + 1;
                    continue;
                }
                if (midMinOffset > startOffset) {
                    high = mid - 1;
                    continue;
                }
                low = mid;
                break;
            }
        }
        for (int i = low; i < caretsSize; ++i) {
            CaretInfo caretInfo = sortedCarets.get(i);
            CaretItem caretItem = caretInfo.getCaretItem();
            if (caretInfo.getSelectionStart() > endOffset) break;
            caretItem.markUpdateCaretBounds();
        }
    }

    private void updateSystemSelection() {
        if (this.component == null) {
            return;
        }
        Clipboard clip = null;
        try {
            clip = this.component.getToolkit().getSystemSelection();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (clip != null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            List<CaretInfo> sortedCarets = this.getSortedCarets();
            for (CaretInfo caret : sortedCarets) {
                CaretItem caretItem = caret.getCaretItem();
                if (!caretItem.isSelection()) continue;
                if (!first) {
                    builder.append("\n");
                } else {
                    first = false;
                }
                builder.append(this.getSelectedText(caretItem));
            }
            if (builder.length() > 0) {
                clip.setContents(new StringSelection(builder.toString()), null);
            }
        }
    }

    private String getSelectedText(CaretItem caret) {
        int p1;
        String txt = null;
        int p0 = Math.min(caret.getDot(), caret.getMark());
        if (p0 != (p1 = Math.max(caret.getDot(), caret.getMark()))) {
            try {
                Document doc = this.component.getDocument();
                txt = doc.getText(p0, p1 - p0);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return txt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRectangularSelectionPositionBlocks() {
        AbstractDocument doc;
        JTextComponent c = this.component;
        if (this.rectangularSelection && (doc = this.activeDoc) != null) {
            doc.readLock();
            try {
                if (this.rsRegions == null) {
                    this.rsRegions = new ArrayList<Position>();
                    this.component.putClientProperty(RECTANGULAR_SELECTION_REGIONS_PROPERTY, this.rsRegions);
                }
                List<Position> list = this.rsRegions;
                synchronized (list) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("EditorCaret.updateRectangularSelectionPositionBlocks: position regions:\n");
                    }
                    this.rsRegions.clear();
                    if (this.rsPaintRect != null) {
                        LockedViewHierarchy lvh = ViewHierarchy.get(c).lock();
                        try {
                            float rowHeight = lvh.getDefaultRowHeight();
                            double y = this.rsPaintRect.y;
                            double maxY = y + (double)this.rsPaintRect.height;
                            double minX = this.rsPaintRect.getMinX();
                            double maxX = this.rsPaintRect.getMaxX();
                            do {
                                int endOffset;
                                int startOffset;
                                if ((startOffset = lvh.viewToModel(minX, y, null)) > (endOffset = lvh.viewToModel(maxX, y, null))) {
                                    int tmp = startOffset;
                                    startOffset = endOffset;
                                    endOffset = tmp;
                                }
                                Position startPos = this.activeDoc.createPosition(startOffset);
                                Position endPos = this.activeDoc.createPosition(endOffset);
                                this.rsRegions.add(startPos);
                                this.rsRegions.add(endPos);
                                if (!LOG.isLoggable(Level.FINE)) continue;
                                LOG.fine("    <" + startOffset + "," + endOffset + ">\n");
                            } while ((y += (double)rowHeight) < maxY);
                            c.putClientProperty(RECTANGULAR_SELECTION_REGIONS_PROPERTY, this.rsRegions);
                        }
                        finally {
                            lvh.unlock();
                        }
                    }
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private String dumpVisibility() {
        return "visible=" + this.isVisible() + ", showing=" + this.showing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBlink() {
        boolean visible = this.isVisible();
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            if (this.blinkTimer != null) {
                this.blinkTimer.stop();
                this.lastBlinkTime = System.currentTimeMillis();
                if (visible) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("EditorCaret.resetBlink: Reset blinking (caret already visible) - starting the caret blinking timer: " + this.dumpVisibility() + '\n');
                    }
                    this.setShowing(true);
                    this.blinkTimer.start();
                } else {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("EditorCaret.resetBlink: Reset blinking (caret not visible) - caret blinking timer not started: " + this.dumpVisibility() + '\n');
                    }
                    this.setShowing(false);
                }
            }
        }
    }

    boolean isShowing() {
        return this.showing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShowing(boolean showing) {
        ListenerList<EditorCaretListener> listenerList = this.listenerList;
        synchronized (listenerList) {
            this.showing = showing;
        }
        this.updateOverwriteModeLayer(false);
    }

    private void updateOverwriteModeLayer(boolean forceUpdate) {
        CaretOverwriteModeHighlighting overwriteModeHighlighting;
        JTextComponent c;
        if ((forceUpdate || this.overwriteMode) && (c = this.component) != null && (overwriteModeHighlighting = (CaretOverwriteModeHighlighting)c.getClientProperty(CaretOverwriteModeHighlighting.class)) != null) {
            overwriteModeHighlighting.setVisible(this.overwriteMode && this.visible && this.showing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRectangularSelectionMouseX(int x, int y) {
        if (!this.rectangularSelection) {
            return;
        }
        JTextComponent c = this.component;
        int offset = c.viewToModel(new Point(x, y));
        Rectangle r = null;
        if (offset >= 0) {
            try {
                r = c.modelToView(offset);
            }
            catch (BadLocationException ex) {
                r = null;
            }
        }
        if (r != null) {
            float xDiff = x - r.x;
            if (xDiff > 0.0f) {
                float charWidth;
                LockedViewHierarchy lvh = ViewHierarchy.get(c).lock();
                try {
                    charWidth = lvh.getDefaultCharWidth();
                }
                finally {
                    lvh.unlock();
                }
                int n = (int)(xDiff / charWidth);
                r.x = (int)((float)r.x + (float)n * charWidth);
                r.width = (int)charWidth;
            }
            this.rsDotRect.x = r.x;
            this.rsDotRect.width = r.width;
            this.updateRectangularSelectionPaintRect();
            this.fireStateChanged(null);
        }
    }

    private void updateRectangularSelectionPaintRect() {
        JTextComponent c = this.component;
        Rectangle repaintRect = this.rsPaintRect;
        if (this.rsDotRect == null || this.rsMarkRect == null) {
            return;
        }
        Rectangle newRect = new Rectangle();
        if (this.rsDotRect.x < this.rsMarkRect.x) {
            newRect.x = this.rsDotRect.x;
            newRect.width = this.rsMarkRect.x - newRect.x;
        } else {
            newRect.x = this.rsMarkRect.x;
            newRect.width = this.rsDotRect.x - newRect.x;
        }
        if (this.rsDotRect.y < this.rsMarkRect.y) {
            newRect.y = this.rsDotRect.y;
            newRect.height = this.rsMarkRect.y + this.rsMarkRect.height - newRect.y;
        } else {
            newRect.y = this.rsMarkRect.y;
            newRect.height = this.rsDotRect.y + this.rsDotRect.height - newRect.y;
        }
        if (newRect.width < 2) {
            newRect.width = 2;
        }
        this.rsPaintRect = newRect;
        repaintRect = repaintRect == null ? this.rsPaintRect : repaintRect.union(this.rsPaintRect);
        c.repaint(repaintRect);
        this.updateRectangularSelectionPositionBlocks();
    }

    private void selectEnsureMinSelection(int mark, int dot, int newDot) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("EditorCaret.selectEnsureMinSelection: mark=" + mark + ", dot=" + dot + ", newDot=" + newDot + "\n");
        }
        if (dot >= mark) {
            if (newDot >= mark) {
                this.moveDot(Math.max(newDot, this.minSelectionEndOffset));
            } else {
                this.setDot(this.minSelectionEndOffset);
                this.moveDot(Math.min(newDot, this.minSelectionStartOffset));
            }
        } else if (newDot <= mark) {
            this.moveDot(Math.min(newDot, this.minSelectionStartOffset));
        } else {
            this.setDot(this.minSelectionStartOffset);
            this.moveDot(Math.max(newDot, this.minSelectionEndOffset));
        }
    }

    private boolean isLeftMouseButtonExt(MouseEvent evt) {
        return SwingUtilities.isLeftMouseButton(evt) && !evt.isPopupTrigger() && (Utilities.isMac() || (evt.getModifiers() & 0xC) == 0);
    }

    private boolean isMiddleMouseButtonExt(MouseEvent evt) {
        return evt.getButton() == 2 && (evt.getModifiersEx() & 0x2180) == 0;
    }

    private int mapDragOperationFromModifiers(MouseEvent e) {
        int mods = e.getModifiersEx();
        if ((mods & 0x400) == 0) {
            return 0;
        }
        return 3;
    }

    private boolean isDragPossible(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof JComponent) {
            int mark;
            Caret caret;
            int dot;
            JTextComponent c;
            boolean possible;
            JComponent comp = (JComponent)src;
            boolean bl = comp == null ? false : (possible = comp.getTransferHandler() != null);
            if (possible && comp instanceof JTextComponent && (c = (JTextComponent)comp).getDragEnabled() && (dot = (caret = c.getCaret()).getDot()) != (mark = caret.getMark())) {
                Point p = new Point(e.getX(), e.getY());
                int pos = c.viewToModel(p);
                int p0 = Math.min(dot, mark);
                int p1 = Math.max(dot, mark);
                if (pos >= p0 && pos < p1) {
                    return true;
                }
            }
        }
        return false;
    }

    private void extendAtomicSectionChangeArea(int changeStartOffset, int changeEndOffset) {
        if (this.atomicSectionStartChangeOffset == Integer.MAX_VALUE) {
            this.atomicSectionStartChangeOffset = changeStartOffset;
            this.atomicSectionEndChangeOffset = changeEndOffset;
        } else {
            this.atomicSectionStartChangeOffset = Math.min(this.atomicSectionStartChangeOffset, changeStartOffset);
            this.atomicSectionEndChangeOffset = Math.max(this.atomicSectionEndChangeOffset, changeEndOffset);
        }
    }

    private static String logMouseEvent(MouseEvent evt) {
        return "x=" + evt.getX() + ", y=" + evt.getY() + ", clicks=" + evt.getClickCount() + ", component=" + EditorCaret.s2s(evt.getComponent()) + ", source=" + EditorCaret.s2s(evt.getSource()) + ", button=" + evt.getButton() + ", mods=" + evt.getModifiers() + ", modsEx=" + evt.getModifiersEx();
    }

    private static String s2s(Object o) {
        return o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    static {
        RectangularSelectionCaretAccessor.register(new RectangularSelectionCaretAccessor(){

            @Override
            public void setRectangularSelectionToDotAndMark(EditorCaret editorCaret) {
                editorCaret.setRectangularSelectionToDotAndMark();
            }

            @Override
            public void updateRectangularUpDownSelection(EditorCaret editorCaret) {
                editorCaret.updateRectangularUpDownSelection();
            }

            @Override
            public void extendRectangularSelection(EditorCaret editorCaret, boolean toRight, boolean ctrl) {
                editorCaret.extendRectangularSelection(toRight, ctrl);
            }
        });
    }

    private static enum MouseState {
        DEFAULT,
        CHAR_SELECTION,
        WORD_SELECTION,
        LINE_SELECTION,
        DRAG_SELECTION_POSSIBLE,
        DRAG_SELECTION;

    }

    private static enum CaretType {
        THICK_LINE_CARET,
        THIN_LINE_CARET,
        BLOCK_CARET;


        static CaretType decode(String typeStr) {
            switch (typeStr) {
                case "thin-line-caret": {
                    return THIN_LINE_CARET;
                }
                case "block-caret": {
                    return BLOCK_CARET;
                }
            }
            return THICK_LINE_CARET;
        }
    }

    private final class ListenerImpl
    extends ComponentAdapter
    implements ActionListener,
    DocumentListener,
    AtomicLockListener,
    MouseListener,
    MouseMotionListener,
    FocusListener,
    ViewHierarchyListener,
    PropertyChangeListener,
    PreferenceChangeListener,
    KeyListener {
        ListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = EditorCaret.this.component;
            if (c != null) {
                EditorCaret.this.setShowing(!EditorCaret.this.showing);
                List<CaretInfo> sortedCarets = EditorCaret.this.getSortedCarets();
                int sortedCaretsSize = sortedCarets.size();
                for (int i = 0; i < sortedCaretsSize; ++i) {
                    CaretInfo caret = sortedCarets.get(i);
                    CaretItem caretItem = caret.getCaretItem();
                    caretItem.repaint(c, "EditorCaret: repaint-to-" + (EditorCaret.this.isShowing() ? "show" : "hide"), i);
                }
                long tm = System.currentTimeMillis();
                if (tm - (long)(EditorCaret.this.blinkCurrentDelay + (EditorCaret.this.blinkCurrentDelay >> 2)) > 0L) {
                    // empty if block
                }
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            EditorCaret.this.updateType();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            JTextComponent c = EditorCaret.this.component;
            if ("document".equals(propName)) {
                if (c != null) {
                    EditorCaret.this.modelChanged(EditorCaret.this.activeDoc, c.getDocument());
                }
            } else if ("caret-overwrite-mode".equals(propName)) {
                Boolean b = (Boolean)evt.getNewValue();
                EditorCaret.this.overwriteMode = b != null ? b : false;
                EditorCaret.this.updateOverwriteModeLayer(true);
                EditorCaret.this.updateType();
            } else if ("ancestor".equals(propName) && evt.getSource() == EditorCaret.this.component) {
                JScrollPane scrollPane;
                JScrollBar hScrollBar;
                Container parent;
                JViewport viewport = EditorCaret.this.getViewport();
                if (viewport != null && (parent = viewport.getParent()) instanceof JScrollPane && (hScrollBar = (scrollPane = (JScrollPane)parent).getHorizontalScrollBar()) != null) {
                    hScrollBar.addComponentListener((ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)EditorCaret.this.listenerImpl, (Object)hScrollBar));
                }
            } else if ("enabled".equals(propName)) {
                Boolean enabled = (Boolean)evt.getNewValue();
                if (EditorCaret.this.component.isFocusOwner()) {
                    if (enabled == Boolean.TRUE) {
                        if (EditorCaret.this.component.isEditable()) {
                            EditorCaret.this.setVisible(true);
                        }
                        EditorCaret.this.setSelectionVisible(true);
                    } else {
                        EditorCaret.this.setVisible(false);
                        EditorCaret.this.setSelectionVisible(false);
                    }
                }
            } else if (EditorCaret.RECTANGULAR_SELECTION_PROPERTY.equals(propName)) {
                boolean origRectangularSelection = EditorCaret.this.rectangularSelection;
                EditorCaret.this.rectangularSelection = Boolean.TRUE.equals(EditorCaret.this.component.getClientProperty(EditorCaret.RECTANGULAR_SELECTION_PROPERTY));
                if (EditorCaret.this.rectangularSelection != origRectangularSelection) {
                    if (EditorCaret.this.rectangularSelection) {
                        EditorCaret.this.setRectangularSelectionToDotAndMark();
                    }
                    EditorCaret.this.fireStateChanged(null);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            JTextComponent c = EditorCaret.this.component;
            if (c != null) {
                int offset = evt.getOffset();
                int length = evt.getLength();
                if (offset == 0) {
                    EditorCaret.this.runTransaction(CaretTransaction.RemoveType.DOCUMENT_INSERT_ZERO_OFFSET, evt.getLength(), null, null, MoveCaretsOrigin.DISABLE_FILTERS);
                }
                this.modifiedUpdate(evt, offset, offset + length, offset + length);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            JTextComponent c = EditorCaret.this.component;
            if (c != null) {
                int offset = evt.getOffset();
                EditorCaret.this.runTransaction(CaretTransaction.RemoveType.DOCUMENT_REMOVE, offset, null, null);
                this.modifiedUpdate(evt, offset, offset, offset);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void atomicLock(AtomicLockEvent evt) {
            ListenerList listenerList = EditorCaret.this.listenerList;
            synchronized (listenerList) {
                EditorCaret.this.inAtomicSection = true;
                EditorCaret.this.atomicSectionStartChangeOffset = Integer.MAX_VALUE;
                EditorCaret.this.atomicSectionImplicitSetDotOffset = Integer.MAX_VALUE;
                EditorCaret.this.atomicSectionAnyCaretChange = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void atomicUnlock(AtomicLockEvent evt) {
            EditorCaret.this.inAtomicUnlock = true;
            ListenerList listenerList = EditorCaret.this.listenerList;
            synchronized (listenerList) {
                EditorCaret.this.inAtomicSection = false;
            }
            try {
                boolean change = EditorCaret.this.atomicSectionAnyCaretChange;
                if (!change && EditorCaret.this.atomicSectionImplicitSetDotOffset != Integer.MAX_VALUE) {
                    this.implicitSetDot(null, EditorCaret.this.atomicSectionImplicitSetDotOffset);
                    change = true;
                }
                if (EditorCaret.this.atomicSectionStartChangeOffset != Integer.MAX_VALUE) {
                    EditorCaret.this.invalidateCaretBounds(EditorCaret.this.atomicSectionStartChangeOffset, EditorCaret.this.atomicSectionEndChangeOffset);
                    change = true;
                }
                if (change) {
                    this.updateAndFireChange();
                }
            }
            finally {
                EditorCaret.this.inAtomicUnlock = false;
            }
        }

        private void modifiedUpdate(DocumentEvent evt, int offset, int endOffset, int setDotOffset) {
            boolean typingModification = DocumentUtilities.isTypingModification((Document)evt.getDocument());
            JTextComponent c = EditorCaret.this.component;
            EditorCaret.this.scrollToLastCaret = (byte)(EditorCaret.this.scrollToLastCaret | (typingModification && c != null && c.hasFocus() ? 1 : 0));
            if (!this.implicitSetDot(evt, setDotOffset) && EditorCaret.this.atomicSectionImplicitSetDotOffset != Integer.MAX_VALUE) {
                EditorCaret.this.atomicSectionImplicitSetDotOffset = DocumentUtilities.fixOffset((int)EditorCaret.this.atomicSectionImplicitSetDotOffset, (DocumentEvent)evt);
            }
            if (EditorCaret.this.inAtomicSection) {
                EditorCaret.this.extendAtomicSectionChangeArea(offset, endOffset);
            } else {
                EditorCaret.this.invalidateCaretBounds(offset, endOffset);
                this.updateAndFireChange();
            }
        }

        private void updateAndFireChange() {
            EditorCaret.this.dispatchUpdate(false);
            EditorCaret.this.resetBlink();
            EditorCaret.this.fireStateChanged(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean implicitSetDot(DocumentEvent evt, int offset) {
            if ((evt == null || UndoRedoDocumentEventResolver.isUndoRedoEvent(evt)) && EditorCaret.this.getCarets().size() == 1) {
                boolean inActiveTransaction;
                ListenerList listenerList = EditorCaret.this.listenerList;
                synchronized (listenerList) {
                    inActiveTransaction = EditorCaret.this.activeTransaction != null;
                }
                if (!(inActiveTransaction || evt != null && DocumentPostModificationUtils.isPostModification(evt))) {
                    if (EditorCaret.this.inAtomicSection) {
                        EditorCaret.this.atomicSectionImplicitSetDotOffset = offset;
                    } else {
                        EditorCaret.this.setDot(offset);
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void mousePressed(MouseEvent evt) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EditorCaret.mousePressed: " + EditorCaret.logMouseEvent(evt) + ", state=" + (Object)((Object)EditorCaret.this.mouseState) + '\n');
            }
            final JTextComponent c = EditorCaret.this.component;
            final AbstractDocument doc = EditorCaret.this.activeDoc;
            if (c == null) return;
            if (doc == null) return;
            if (!EditorCaret.this.isLeftMouseButtonExt(evt)) return;
            doc.readLock();
            try {
                final int offset = this.mouse2Offset(evt);
                switch (evt.getClickCount()) {
                    case 1: {
                        if (c.isEnabled() && !c.hasFocus()) {
                            c.requestFocus();
                        }
                        c.setDragEnabled(!dndDisabled);
                        if ((Utilities.isMac() ? evt.isMetaDown() : evt.isControlDown()) && evt.isShiftDown()) {
                            EditorCaret.this.mouseState = MouseState.DEFAULT;
                            try {
                                Position pos = doc.createPosition(offset);
                                EditorCaret.this.runTransaction(CaretTransaction.RemoveType.TOGGLE_CARET, 0, new CaretItem[]{new CaretItem(EditorCaret.this, pos, Position.Bias.Forward, pos, Position.Bias.Forward)}, null);
                                evt.consume();
                                return;
                            }
                            catch (BadLocationException pos) {
                                return;
                            }
                        }
                        if (evt.isShiftDown()) {
                            EditorCaret.this.moveDot(offset);
                            EditorCaret.this.setMagicCaretPosition(null);
                            EditorCaret.this.adjustRectangularSelectionMouseX(evt.getX(), evt.getY());
                            EditorCaret.this.mouseState = MouseState.CHAR_SELECTION;
                            return;
                        }
                        if (!dndDisabled && EditorCaret.this.isDragPossible(evt) && EditorCaret.this.mapDragOperationFromModifiers(evt) != 0) {
                            EditorCaret.this.mouseState = MouseState.DRAG_SELECTION_POSSIBLE;
                            return;
                        }
                        EditorCaret.this.mouseState = MouseState.CHAR_SELECTION;
                        EditorCaret.this.setDot(offset);
                        EditorCaret.this.setMagicCaretPosition(null);
                        return;
                    }
                    case 2: {
                        EditorCaret.this.mouseState = MouseState.WORD_SELECTION;
                        c.setDragEnabled(false);
                        try {
                            boolean foldExpanded = false;
                            CaretFoldExpander caretFoldExpander = CaretFoldExpander.get();
                            if (caretFoldExpander != null) {
                                foldExpanded = caretFoldExpander.checkExpandFold(c, evt.getPoint());
                            }
                            if (foldExpanded) return;
                            if ((Utilities.isMac() ? evt.isMetaDown() : evt.isControlDown()) && evt.isShiftDown()) {
                                EditorCaret.this.mouseState = MouseState.DEFAULT;
                                final CaretItem[][] updatedCaretsRef = new CaretItem[1][];
                                EditorCaret.this.moveCarets(new CaretMoveHandler(){

                                    @Override
                                    public void moveCarets(CaretMoveContext context) {
                                        List<CaretInfo> sortedCarets = context.getOriginalSortedCarets();
                                        int sortedCaretsSize = sortedCarets.size();
                                        LineDocument lineDoc = (LineDocument)LineDocumentUtils.asRequired((Document)c.getDocument(), LineDocument.class);
                                        for (int i = 0; i < sortedCaretsSize; ++i) {
                                            int j;
                                            CaretInfo caretInfo = sortedCarets.get(i);
                                            int dot = caretInfo.getDot();
                                            int mark = caretInfo.getMark();
                                            if (dot == offset && mark == offset) {
                                                try {
                                                    int wordStartOffset = LineDocumentUtils.getWordStart((LineDocument)lineDoc, (int)offset);
                                                    int wordEndOffset = LineDocumentUtils.getWordEnd((LineDocument)lineDoc, (int)offset);
                                                    Position wordStartPos = doc.createPosition(wordStartOffset);
                                                    Position wordEndPos = doc.createPosition(wordEndOffset);
                                                    context.setDotAndMark(caretInfo, wordEndPos, Position.Bias.Forward, wordStartPos, Position.Bias.Forward);
                                                    EditorCaret.this.minSelectionStartOffset = wordStartOffset;
                                                    EditorCaret.this.minSelectionEndOffset = wordEndOffset;
                                                }
                                                catch (BadLocationException wordStartOffset) {}
                                                break;
                                            }
                                            if ((dot > offset || offset > mark) && (mark > offset || offset > dot) || sortedCaretsSize <= 1) continue;
                                            CaretItem[] updatedCarets = new CaretItem[sortedCaretsSize - 1];
                                            for (j = 0; j < i; ++j) {
                                                updatedCarets[j] = sortedCarets.get(j).getCaretItem();
                                            }
                                            int k = i;
                                            for (j = i + 1; j < sortedCaretsSize; ++j) {
                                                updatedCarets[k++] = sortedCarets.get(j).getCaretItem();
                                            }
                                            updatedCaretsRef[0] = updatedCarets;
                                            break;
                                        }
                                    }
                                });
                                if (updatedCaretsRef[0] == null) return;
                                EditorCaret.this.runTransaction(CaretTransaction.RemoveType.REMOVE_ALL_CARETS, 0, updatedCaretsRef[0], null);
                                return;
                            }
                            if (EditorCaret.this.selectWordAction == null) {
                                EditorCaret.this.selectWordAction = EditorActionUtilities.getAction(c.getUI().getEditorKit(c), "select-word");
                            }
                            if (EditorCaret.this.selectWordAction != null) {
                                EditorCaret.this.selectWordAction.actionPerformed(null);
                            }
                            EditorCaret.this.minSelectionStartOffset = EditorCaret.this.getMark();
                            EditorCaret.this.minSelectionEndOffset = EditorCaret.this.getDot();
                            return;
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return;
                        }
                    }
                    case 3: {
                        EditorCaret.this.mouseState = MouseState.LINE_SELECTION;
                        c.setDragEnabled(false);
                        if (evt.isControlDown() && evt.isShiftDown()) {
                            EditorCaret.this.mouseState = MouseState.DEFAULT;
                            return;
                        }
                        if (EditorCaret.this.selectLineAction == null) {
                            EditorCaret.this.selectLineAction = EditorActionUtilities.getAction(c.getUI().getEditorKit(c), "select-line");
                        }
                        if (EditorCaret.this.selectLineAction == null) return;
                        EditorCaret.this.selectLineAction.actionPerformed(null);
                        EditorCaret.this.minSelectionStartOffset = EditorCaret.this.getMark();
                        EditorCaret.this.minSelectionEndOffset = EditorCaret.this.getDot();
                        return;
                    }
                }
                return;
            }
            finally {
                doc.readUnlock();
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EditorCaret.mouseReleased: " + EditorCaret.logMouseEvent(evt) + ", state=" + (Object)((Object)EditorCaret.this.mouseState) + '\n');
            }
            int offset = this.mouse2Offset(evt);
            switch (EditorCaret.this.mouseState) {
                case DRAG_SELECTION_POSSIBLE: {
                    EditorCaret.this.setDot(offset);
                    EditorCaret.this.adjustRectangularSelectionMouseX(evt.getX(), evt.getY());
                    break;
                }
                case CHAR_SELECTION: {
                    if (evt.isAltDown() && evt.isShiftDown()) {
                        EditorCaret.this.moveDot(offset);
                        break;
                    }
                    EditorCaret.this.moveDot(offset);
                    EditorCaret.this.adjustRectangularSelectionMouseX(evt.getX(), evt.getY());
                }
            }
            EditorCaret.this.mouseState = MouseState.DEFAULT;
            EditorCaret.this.component.setDragEnabled(true);
        }

        int mouse2Offset(MouseEvent evt) {
            JTextComponent c = EditorCaret.this.component;
            int offset = 0;
            if (c != null) {
                int y = evt.getY();
                offset = y < 0 ? 0 : ((double)y > c.getSize().getHeight() ? c.getDocument().getLength() : c.viewToModel(new Point(evt.getX(), evt.getY())));
            }
            return offset;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JTextComponent c;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EditorCaret.mouseClicked: " + EditorCaret.logMouseEvent(evt) + ", state=" + (Object)((Object)EditorCaret.this.mouseState) + '\n');
            }
            if ((c = EditorCaret.this.component) != null) {
                if (evt.getClickCount() == 1 && evt.isControlDown() && evt.isShiftDown()) {
                    evt.consume();
                }
                if (EditorCaret.this.isMiddleMouseButtonExt(evt) && evt.getClickCount() == 1) {
                    if (c == null) {
                        return;
                    }
                    Clipboard buffer = EditorCaret.this.component.getToolkit().getSystemSelection();
                    if (buffer == null) {
                        return;
                    }
                    Transferable trans = buffer.getContents(null);
                    if (trans == null) {
                        return;
                    }
                    final Document doc = c.getDocument();
                    if (doc == null) {
                        return;
                    }
                    final int offset = c.getUI().viewToModel(c, new Point(evt.getX(), evt.getY()));
                    try {
                        final String pastingString = (String)trans.getTransferData(DataFlavor.stringFlavor);
                        if (pastingString == null) {
                            return;
                        }
                        Runnable pasteRunnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    doc.insertString(offset, pastingString, null);
                                    EditorCaret.this.setDot(offset + pastingString.length());
                                    EditorCaret.this.setMagicCaretPosition(null);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        };
                        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.as((Document)doc, AtomicLockDocument.class);
                        if (ald != null) {
                            ald.runAtomic(pasteRunnable);
                        } else {
                            pasteRunnable.run();
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            if (EditorCaret.this.mouseState == MouseState.DEFAULT) {
                boolean textCursor = true;
                int position = EditorCaret.this.component.viewToModel(evt.getPoint());
                if (RectangularSelectionUtils.isRectangularSelection(EditorCaret.this.component)) {
                    List<Position> positions = RectangularSelectionUtils.regionsCopy(EditorCaret.this.component);
                    for (int i = 0; textCursor && i < positions.size(); i += 2) {
                        int b;
                        int a = positions.get(i).getOffset();
                        if (a == (b = positions.get(i + 1).getOffset())) continue;
                        textCursor &= !(position >= a && position <= b || position >= b && position <= a);
                    }
                } else if (EditorCaret.this.getDot() == EditorCaret.this.getMark()) {
                    textCursor = true;
                } else {
                    int dot = EditorCaret.this.getDot();
                    int mark = EditorCaret.this.getMark();
                    textCursor = !(position >= dot && position <= mark || position >= mark && position <= dot);
                }
                if (textCursor != EditorCaret.this.showingTextCursor) {
                    int cursorType = textCursor ? 2 : 0;
                    EditorCaret.this.component.setCursor(Cursor.getPredefinedCursor(cursorType));
                    EditorCaret.this.showingTextCursor = textCursor;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EditorCaret.mouseDragged: " + EditorCaret.logMouseEvent(evt) + ", state=" + (Object)((Object)EditorCaret.this.mouseState) + '\n');
            }
            if (EditorCaret.this.isLeftMouseButtonExt(evt)) {
                JTextComponent c = EditorCaret.this.component;
                int offset = this.mouse2Offset(evt);
                int dot = EditorCaret.this.getDot();
                int mark = EditorCaret.this.getMark();
                LineDocument lineDoc = (LineDocument)LineDocumentUtils.asRequired((Document)c.getDocument(), LineDocument.class);
                try {
                    switch (EditorCaret.this.mouseState) {
                        case DEFAULT: 
                        case DRAG_SELECTION: {
                            break;
                        }
                        case DRAG_SELECTION_POSSIBLE: {
                            EditorCaret.this.mouseState = MouseState.DRAG_SELECTION;
                            break;
                        }
                        case CHAR_SELECTION: {
                            if (evt.isAltDown() && evt.isShiftDown()) {
                                EditorCaret.this.moveDot(offset);
                                break;
                            }
                            EditorCaret.this.moveDot(offset);
                            EditorCaret.this.adjustRectangularSelectionMouseX(evt.getX(), evt.getY());
                            break;
                        }
                        case WORD_SELECTION: {
                            offset = offset >= mark ? LineDocumentUtils.getWordEnd((LineDocument)lineDoc, (int)offset) : LineDocumentUtils.getWordStart((LineDocument)lineDoc, (int)offset);
                            EditorCaret.this.selectEnsureMinSelection(mark, dot, offset);
                            break;
                        }
                        case LINE_SELECTION: {
                            offset = offset >= mark ? Math.min(LineDocumentUtils.getLineEnd((LineDocument)lineDoc, (int)offset) + 1, c.getDocument().getLength()) : LineDocumentUtils.getLineStart((LineDocument)lineDoc, (int)offset);
                            EditorCaret.this.selectEnsureMinSelection(mark, dot, offset);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Invalid state " + (Object)((Object)EditorCaret.this.mouseState)));
                        }
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
            JTextComponent c;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EditorCaret.focusGained: doc=" + EditorCaret.this.component.getDocument().getProperty("title") + '\n');
            }
            if ((c = EditorCaret.this.component) != null) {
                if (EditorCaret.this.component.isEnabled()) {
                    if (EditorCaret.this.component.isEditable()) {
                        EditorCaret.this.setVisible(true);
                    }
                    EditorCaret.this.setSelectionVisible(true);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("    Caret visibility: " + EditorCaret.this.isVisible() + '\n');
                }
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("    Text component is null, caret will not be visible\n");
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("EditorCaret.focusLost: doc=" + EditorCaret.this.component.getDocument().getProperty("title") + "\nFOCUS GAINER: " + evt.getOppositeComponent() + '\n');
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("    FOCUS EVENT: " + evt + '\n');
                }
            }
            EditorCaret.this.setVisible(false);
            EditorCaret.this.setSelectionVisible(evt.isTemporary());
        }

        @Override
        public void componentShown(ComponentEvent e) {
            Component hScrollBar = e.getComponent();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            CaretItem caret;
            Component c = e.getComponent();
            if (c == EditorCaret.this.component && (caret = EditorCaret.this.getLastCaretItem()).getCaretBounds() == null) {
                EditorCaret.this.dispatchUpdate(false);
                EditorCaret.this.resetBlink();
                if (caret.getCaretBounds() != null) {
                    c.removeComponentListener(this);
                }
            }
        }

        @Override
        public void viewHierarchyChanged(ViewHierarchyEvent evt) {
            int changeEndOffset;
            int changeStartOffset = evt.changeStartOffset();
            int n = changeEndOffset = evt.isChangeY() ? Integer.MAX_VALUE : evt.changeEndOffset();
            if (EditorCaret.this.inAtomicSection) {
                EditorCaret.this.extendAtomicSectionChangeArea(changeStartOffset, changeEndOffset);
            } else {
                EditorCaret.this.invalidateCaretBounds(changeStartOffset, changeEndOffset);
            }
            EditorCaret.this.dispatchUpdate(true);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                EditorCaret.this.retainLastCaretOnly();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static class ChainNavigationFilter
    extends NavigationFilter {
        private final JTextComponent component;

        public ChainNavigationFilter(JTextComponent component) {
            this.component = component;
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
            NavigationFilter chain = this.component.getNavigationFilter();
            return chain != null ? chain.getNextVisualPositionFrom(text, pos, bias, direction, biasRet) : super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            NavigationFilter chain = this.component.getNavigationFilter();
            if (chain != null) {
                chain.moveDot(fb, dot, bias);
            } else {
                super.moveDot(fb, dot, bias);
            }
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            NavigationFilter chain = this.component.getNavigationFilter();
            if (chain != null) {
                chain.setDot(fb, dot, bias);
            } else {
                super.setDot(fb, dot, bias);
            }
        }
    }
}

