/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptEditorTopComponent;

public class ScriptTypeComboBoxModel
extends DefaultComboBoxModel {
    private static final String CONST_KEY = "scrypt.type.";
    private List<String> translations = new ArrayList<String>();
    private List<ScriptType> scriptTypes = new ArrayList<ScriptType>(Arrays.asList(ScriptType.values()));
    private String selectedItem = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)("scrypt.type." + this.scriptTypes.get(this.selectedIndex).value()));
    private int selectedIndex = 1;

    public ScriptTypeComboBoxModel() {
        for (ScriptType t : this.scriptTypes) {
            String key = CONST_KEY + t.value();
            String translation = NbBundle.getMessage(ScriptEditorTopComponent.class, (String)key);
            this.translations.add(translation);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = (String)anItem;
        this.selectedIndex = this.translations.indexOf(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public ScriptType getSelectedItem(int index) {
        return this.scriptTypes.get(index);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getSize() {
        return this.scriptTypes.size();
    }

    @Override
    public String getElementAt(int index) {
        return this.translations.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

