/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptTypeComboBoxModel;

public class AddNewScriptPanel
extends JPanel {
    private ScriptTypeComboBoxModel scriptTypeModel = new ScriptTypeComboBoxModel();
    private Pattern pat = Pattern.compile("[a-zA-Z0-9_]+");
    private final CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
    private final CronParser parser = new CronParser(this.cronDefinition);
    private final Pattern cronPat = Pattern.compile("[a-zA-Z0-9-,\\/ ?#*]");
    private boolean isNameValid = false;
    private boolean isCRONValid = false;
    private JButton bToggleCollapsible = new JButton();
    private boolean toogleCollapsibleBool = false;
    private JComboBox cbType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JXCollapsiblePane jXCollapsiblePane;
    private JLabel lName;
    private JLabel lType;
    private JTextArea taDesc;
    private JTextField tfCronExpression;
    private JTextField tfName;

    public AddNewScriptPanel(String selectedScriptType) {
        this.initComponents();
        this.scriptTypeModel.setSelectedItem(selectedScriptType);
        this.cbType.setModel(this.scriptTypeModel);
        this.jXCollapsiblePane.setLayout((LayoutManager)new BorderLayout());
        this.jXCollapsiblePane.add((Component)this.jPanel2, (Object)"Center");
        this.bToggleCollapsible.addActionListener(this.jXCollapsiblePane.getActionMap().get("toggle"));
        if (selectedScriptType.contains("Historical")) {
            this.showCronPanel(true);
        } else {
            this.showCronPanel(false);
        }
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_RULESET && AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_CONFIGURATION) {
                    Matcher mat = AddNewScriptPanel.this.pat.matcher(AddNewScriptPanel.this.tfName.getText());
                    AddNewScriptPanel.this.isNameValid = mat.matches();
                    if (AddNewScriptPanel.this.isNameValid) {
                        AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                    } else {
                        AddNewScriptPanel.this.tfName.setBorder(new LineBorder(Color.RED));
                    }
                } else {
                    AddNewScriptPanel.this.isNameValid = true;
                    AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                }
                if (AddNewScriptPanel.this.getScriptType() == ScriptType.SCHEDULED) {
                    AddNewScriptPanel.this.showCronPanel(true);
                    AddNewScriptPanel.this.checkCron();
                } else {
                    AddNewScriptPanel.this.showCronPanel(false);
                    AddNewScriptPanel.this.tfCronExpression.setText("");
                }
                AddNewScriptPanel.this.tfName.repaint();
            }
        });
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkName();
            }

            private void checkName() {
                if (AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_RULESET && AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_CONFIGURATION) {
                    Matcher mat = AddNewScriptPanel.this.pat.matcher(AddNewScriptPanel.this.tfName.getText());
                    AddNewScriptPanel.this.isNameValid = mat.matches();
                    if (AddNewScriptPanel.this.isNameValid) {
                        AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                    } else {
                        AddNewScriptPanel.this.tfName.setBorder(new LineBorder(Color.RED));
                    }
                } else {
                    AddNewScriptPanel.this.isNameValid = true;
                    AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                }
                AddNewScriptPanel.this.tfName.repaint();
            }
        });
        this.tfCronExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddNewScriptPanel.this.checkCron();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddNewScriptPanel.this.checkCron();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddNewScriptPanel.this.checkCron();
            }
        });
        this.tfCronExpression.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.check(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            private void check(KeyEvent e) {
                char c = e.getKeyChar();
                Matcher m = AddNewScriptPanel.this.cronPat.matcher(String.valueOf(c));
                if (!m.matches()) {
                    e.consume();
                }
            }
        });
    }

    private void checkCron() {
        if (this.getScriptType() == ScriptType.SCHEDULED) {
            try {
                Cron cron = this.parser.parse(this.tfCronExpression.getText());
                cron.validate();
                this.tfCronExpression.setBorder(UIManager.getBorder("TextField.border"));
                this.tfCronExpression.repaint();
                this.isCRONValid = true;
            }
            catch (IllegalArgumentException ex) {
                this.tfCronExpression.setBorder(new LineBorder(Color.RED));
                this.tfCronExpression.repaint();
                this.isCRONValid = false;
            }
        }
    }

    public void showCronPanel(boolean show) {
        if (show) {
            if (!this.toogleCollapsibleBool) {
                this.bToggleCollapsible.doClick();
                this.toogleCollapsibleBool = true;
                this.jPanel5.invalidate();
                this.jPanel5.validate();
                this.jPanel5.updateUI();
            }
        } else if (this.toogleCollapsibleBool) {
            this.bToggleCollapsible.doClick();
            this.toogleCollapsibleBool = false;
            this.jPanel5.invalidate();
            this.jPanel5.validate();
            this.jPanel5.updateUI();
        }
    }

    public String getScriptName() {
        return this.tfName.getText();
    }

    public ScriptType getScriptType() {
        return this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
    }

    public void setSelectedScriptType(String t) {
        this.scriptTypeModel.setSelectedItem(t);
    }

    public String getScriptDesc() {
        return this.taDesc.getText();
    }

    public String getCronExpression() {
        return this.tfCronExpression.getText();
    }

    public boolean IsNameValid() {
        return this.isNameValid;
    }

    public boolean isCRONValid() {
        return this.isCRONValid;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfCronExpression = new JTextField();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.lName = new JLabel();
        this.lType = new JLabel();
        this.tfName = new JTextField();
        this.cbType = new JComboBox();
        this.jXCollapsiblePane = new JXCollapsiblePane();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.taDesc = new JTextArea();
        this.jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.jLabel1.text"));
        this.tfCronExpression.setText(NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.tfCronExpression.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.tfCronExpression, -1, 180, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfCronExpression, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.lName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lType, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.lType.text"));
        this.tfName.setText(NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.tfName.text"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(94, 94, 94).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lName).addComponent(this.lType)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfName).addComponent(this.cbType, 0, 242, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 22, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lType).addComponent(this.cbType, -2, -1, -2))));
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jXCollapsiblePane.setCollapsed(true);
        this.jXCollapsiblePane.setDirection(JXCollapsiblePane.Direction.DOWN);
        this.jPanel1.add((Component)this.jXCollapsiblePane, "Last");
        this.add((Component)this.jPanel1, "First");
        this.jPanel5.setPreferredSize(new Dimension(350, 100));
        this.taDesc.setColumns(20);
        this.taDesc.setRows(5);
        this.taDesc.setMinimumSize(new Dimension(0, 0));
        this.taDesc.setPreferredSize(new Dimension(220, 50));
        this.jScrollPane1.setViewportView(this.taDesc);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.lDesc.text"));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(58, 58, 58).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 240, -2).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 73, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addContainerGap()));
        this.add((Component)this.jPanel5, "Center");
    }
}

