/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ItemsPerTimePeriod;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.gui.rawlogs.DisplayOptions;
import rs.co.ast.aspen.gui.rawlogs.RawLogSearchQueryUpdate;
import rs.co.ast.aspen.gui.rawlogs.query.QueryManager;
import rs.co.ast.aspen.gui.rawlogs.widget.LoadingPanel;
import rs.co.ast.aspen.gui.rawlogs.widget.ReloadPanel;
import rs.co.ast.aspen.gui.rawlogs.widget.Widget;
import rs.co.ast.chart.ASTChart;
import rs.co.ast.chart.OverviewChart;
import rs.co.ast.chart.event.ASTMouseEvent;
import rs.co.ast.chart.event.ASTMouseListener;
import rs.co.ast.chart.event.ASTPlotChangeEvent;
import rs.co.ast.chart.event.ASTPlotChangeListener;

public class ByFieldPanel
extends JPanel
implements Widget {
    private static final Logger logger = Logger.getLogger(ByFieldPanel.class.getName());
    private static final int NO_SOURCES = 20;
    private static final int GRAPH_HEIGHT = 150;
    private static final int MAX_SOURCE_TITLE_LEN = 70;
    private Map<String, Color> itemColors = new HashMap<String, Color>();
    private Lookup.Result<RawLogSimWrapper> lr = Utilities.actionsGlobalContext().lookupResult(RawLogSimWrapper.class);
    private RawLogSimWrapper rawLogSimWrapper;
    private transient MouseListener listener;
    private FileSystem fs = FileUtil.createMemoryFileSystem();
    private FileObject root = this.fs.getRoot();
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup searchQueryUpdate = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private RawLogSearchQueryUpdate prevSearchQueryUpdate = null;
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime();
    private UpdateParams params;
    private OverviewChart chart;
    private ASTPlotChangeListener plotChangeListener;
    private ASTMouseListener mouseListener;
    private LoadingPanel loadingPanel;
    private ReloadPanel reloadPanel;
    private List<String> rawLogValues = new ArrayList<String>();
    private long startTimeOfWidgetCreation = 0L;
    private LinkedHashMap<String, Long> countedRawLogsListByField = new LinkedHashMap();
    private JPopupMenu popUpMenu;
    private JPanel graphPanel;
    private JLabel lTitle;
    private JPanel pButtonsLeft;
    private JPanel pButtonsRight;
    private JPanel pContainer;
    private JPanel pContent;
    private JPanel pData;

    public ByFieldPanel() {
        this.initComponents();
        this.graphPanel.setLayout(new BorderLayout());
        this.popUpMenu = new JPopupMenu();
        JMenuItem miCopy = new JMenuItem("Copy");
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringBuilder sb = new StringBuilder();
                Set<Map.Entry<String, Long>> entrySet = ByFieldPanel.this.countedRawLogsListByField.entrySet();
                for (Map.Entry<String, Long> next : entrySet) {
                    sb.append((Object)next.getKey());
                    sb.append("\t");
                    sb.append(next.getValue());
                    sb.append(System.lineSeparator());
                }
                StringSelection selection = new StringSelection(sb.toString());
                cb.setContents(selection, selection);
            }
        });
        this.popUpMenu.add(miCopy);
        this.pContent.setOpaque(false);
        this.pButtonsLeft.setOpaque(false);
        this.pButtonsRight.setOpaque(false);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result res = (Lookup.Result)ev.getSource();
                Collection instances = res.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof RawLogSimWrapper)) continue;
                    ByFieldPanel.this.rawLogSimWrapper = (RawLogSimWrapper)o;
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ByFieldPanel.this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ByFieldPanel.this.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.listener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JButton btn = (JButton)e.getSource();
                if (ByFieldPanel.this.rawLogSimWrapper != null) {
                    String prevQuery = ByFieldPanel.this.rawLogSimWrapper.getQuery();
                    Object query = null;
                    String field = ByFieldPanel.this.params.getField();
                    if (ByFieldPanel.this.isCTRL_SHIFT_CLICK(e) && e.getButton() != 3) {
                        Object object = query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        if (!((String)query).isEmpty()) {
                            query = (String)query + "OR ";
                        }
                        query = (String)query + field + ":" + btn.getToolTipText();
                    } else if (e.isShiftDown() && e.getButton() != 3) {
                        query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        query = (String)query + "NOT " + field + ":" + btn.getToolTipText();
                    } else if (e.isControlDown() && e.getButton() != 3) {
                        query = !prevQuery.isEmpty() ? prevQuery + " AND " : prevQuery;
                        query = (String)query + field + ":" + btn.getToolTipText();
                    } else if (e.getButton() != 3) {
                        query = field + ":" + btn.getToolTipText();
                    }
                    if (query != null && !((String)query).isEmpty()) {
                        try {
                            FileObject fileData;
                            if (ByFieldPanel.this.root.getFileObject("RawLogFolder") == null) {
                                testFolder = ByFieldPanel.this.root.createFolder("RawLogFolder");
                                fileData = testFolder.createData("RawLogID", "rawlog");
                            } else {
                                testFolder = ByFieldPanel.this.root.getFileObject("RawLogFolder");
                                fileData = testFolder.getFileObject("RawLogID", "rawlog");
                            }
                            fileData.setAttribute("query", query);
                            fileData.setAttribute("start", (Object)ByFieldPanel.this.rawLogSimWrapper.getTimeStart());
                            fileData.setAttribute("finish", (Object)ByFieldPanel.this.rawLogSimWrapper.getTimeFinish());
                            fileData.setAttribute("lastNHours", (Object)ByFieldPanel.this.rawLogSimWrapper.isLastNHours());
                            fileData.setAttribute("lastNHoursSelectedIndex", (Object)ByFieldPanel.this.rawLogSimWrapper.getLastNHoursSelectedIndex());
                            fileData.setAttribute("now", (Object)ByFieldPanel.this.rawLogSimWrapper.isNow());
                            fileData.setAttribute("ASC", (Object)false);
                            DataObject sedo = DataObject.find((FileObject)fileData);
                            ((OpenCookie)sedo.getLookup().lookup(OpenCookie.class)).open();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.plotChangeListener = new ASTPlotChangeListener(){

            public void plotChanged(ASTPlotChangeEvent event) {
                String start = ByFieldPanel.this.isoTimeFormat.print(event.getStartTime());
                String end = ByFieldPanel.this.isoTimeFormat.print(event.getFinishTime());
                double t = (event.getFinishTime() - event.getStartTime()) / 30000L / 10L;
                logger.info(String.format("start: %s, end: %s, interval: %s | coefficient: %s", start, end, ByFieldPanel.this.params.getInterval(), t));
                String query = QueryManager.makeGraphZoomQuery(ByFieldPanel.this.rawLogSimWrapper, ByFieldPanel.this.isoTimeFormat, (PlotChangeEvent)event);
                if (query.length() > 0) {
                    RawLogSearchQueryUpdate squ = new RawLogSearchQueryUpdate(query, true, ByFieldPanel.this.rawLogSimWrapper.getTag());
                    ByFieldPanel.this.instanceContent.add((Object)squ);
                    ByFieldPanel.this.prevSearchQueryUpdate = squ;
                }
                if (ByFieldPanel.this.prevSearchQueryUpdate != null) {
                    ByFieldPanel.this.instanceContent.remove((Object)ByFieldPanel.this.prevSearchQueryUpdate);
                }
            }
        };
        this.mouseListener = new ASTMouseListener(){

            public void mousePressed(ASTMouseEvent e) {
            }

            public void mouseReleased(ASTMouseEvent e) {
                DisplayOptions displayOptions = ByFieldPanel.this.params.getDisplayOptions();
                long value = displayOptions.getIntervalObj().getLongValue();
                if (e.getCoefficient() < 9.0) {
                    int intervalIndex = displayOptions.getIntervalIndex(displayOptions.getIntervalObj()) - 1;
                    if (intervalIndex < 0) {
                        intervalIndex = 0;
                    }
                    ByFieldPanel.this.params.getDisplayOptions().setIntervalObj(ByFieldPanel.this.params.getDisplayOptions().getIntervals()[intervalIndex]);
                }
            }
        };
    }

    public void setByFieldPanelTitle(String field, String sort, int noSources) {
        this.lTitle.setText(String.format("%s %d events by %s", sort, noSources, field));
    }

    public Lookup getRawLogQueryUpdateLookup() {
        return this.searchQueryUpdate;
    }

    private boolean isCTRL_SHIFT_CLICK(MouseEvent e) {
        int onmask = 1216;
        return (e.getModifiersEx() & onmask) == onmask;
    }

    @Override
    public void update(Object data, Class<?> clazz) {
        this.params = (UpdateParams)data;
        new SourcesUpdater(this.params, clazz).execute();
    }

    private void initComponents() {
        this.lTitle = new JLabel();
        this.pContainer = new JPanel();
        this.pData = new JPanel();
        this.graphPanel = new JPanel();
        this.pContent = new JPanel();
        this.pButtonsLeft = new JPanel();
        this.pButtonsRight = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lTitle, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.lTitle.text"));
        this.pContainer.setBackground(new Color(255, 255, 255));
        this.pContainer.setLayout(new BorderLayout());
        this.pData.setBackground(new Color(255, 255, 255));
        this.pData.setPreferredSize(new Dimension(750, 416));
        this.graphPanel.setBackground(new Color(255, 255, 255));
        this.graphPanel.setPreferredSize(new Dimension(0, 209));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 283, Short.MAX_VALUE));
        this.pButtonsLeft.setLayout(new BoxLayout(this.pButtonsLeft, 1));
        this.pButtonsRight.setPreferredSize(new Dimension(357, 0));
        this.pButtonsRight.setLayout(new BoxLayout(this.pButtonsRight, 1));
        GroupLayout pContentLayout = new GroupLayout(this.pContent);
        this.pContent.setLayout(pContentLayout);
        pContentLayout.setHorizontalGroup(pContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pContentLayout.createSequentialGroup().addContainerGap().addComponent(this.pButtonsLeft, -1, 357, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pButtonsRight, -1, -1, Short.MAX_VALUE).addContainerGap()));
        pContentLayout.setVerticalGroup(pContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pContentLayout.createSequentialGroup().addContainerGap().addGroup(pContentLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pButtonsRight, -1, 26, Short.MAX_VALUE).addComponent(this.pButtonsLeft, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout pDataLayout = new GroupLayout(this.pData);
        this.pData.setLayout(pDataLayout);
        pDataLayout.setHorizontalGroup(pDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.graphPanel, -1, 750, Short.MAX_VALUE).addGroup(pDataLayout.createSequentialGroup().addContainerGap().addComponent(this.pContent, -1, -1, Short.MAX_VALUE).addContainerGap()));
        pDataLayout.setVerticalGroup(pDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataLayout.createSequentialGroup().addComponent(this.graphPanel, -2, 283, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pContent, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pContainer.add((Component)this.pData, "Center");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pContainer, -1, -1, Short.MAX_VALUE).addComponent(this.lTitle, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pContainer, -1, 333, Short.MAX_VALUE)));
    }

    private TimeSeries[] createDataSet(List<TermTimeHistogram> items, SortedMap<String, Long> sortedData, Class clazz) {
        ArrayList<TimeSeries> list = new ArrayList<TimeSeries>();
        HashMap<String, TermTimeHistogram> map = new HashMap<String, TermTimeHistogram>();
        HashSet<Long> times = new HashSet<Long>();
        for (TermTimeHistogram termTimeHistogram : items) {
            map.put(termTimeHistogram.getTerm(), termTimeHistogram);
        }
        int i = 0;
        for (String item : sortedData.keySet()) {
            if (i >= 20) break;
            TermTimeHistogram tth = (TermTimeHistogram)map.get(item);
            TimeSeries ts = new TimeSeries((Comparable)((Object)tth.getTerm()));
            times.clear();
            for (ItemsPerTimePeriod iptp : tth.getHistogram()) {
                if (iptp.getTime() < this.params.getTimeStart() || iptp.getTime() > this.params.getTimeFinish() || times.contains(iptp.getTime())) continue;
                times.add(iptp.getTime());
                ts.addOrUpdate(RegularTimePeriod.createInstance((Class)clazz, (Date)new Date(iptp.getTime()), (TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()), (double)iptp.getCount());
            }
            if (ts.getItemCount() > 0) {
                list.add(ts);
            }
            ++i;
        }
        TimeSeries[] timeSeriesArray = new TimeSeries[list.size()];
        return list.toArray(timeSeriesArray);
    }

    private Map<String, Long> getTotalEventsByField(List<TermTimeHistogram> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (TermTimeHistogram tth : data) {
            String t = tth.getTerm();
            for (ItemsPerTimePeriod iptp : tth.getHistogram()) {
                Long i = (Long)map.get(t);
                if (i == null) {
                    i = 0L;
                }
                i = i + iptp.getCount();
                map.put(t, i);
            }
        }
        return map;
    }

    @Override
    public void setReloadPanel() {
        if (this.reloadPanel == null) {
            this.reloadPanel = new ReloadPanel();
            this.reloadPanel.getbReload().addActionListener(ActionListener2 -> new SourcesUpdater(this.params, this.params.getDisplayOptions().getIntervalObj().getClazz()).execute());
        }
        this.pContainer.removeAll();
        this.pContainer.add(this.reloadPanel);
        this.pContainer.invalidate();
        this.pContainer.repaint();
    }

    @Override
    public void setLoadingPanel() {
        if (this.loadingPanel == null) {
            this.loadingPanel = new LoadingPanel();
        }
        this.pContainer.removeAll();
        this.pContainer.add(this.loadingPanel);
        this.pContainer.invalidate();
        this.pContainer.repaint();
    }

    private void populateButtons(Map<String, Long> m, Map<String, Long> sm, long total) {
        this.pButtonsLeft.removeAll();
        this.pButtonsRight.removeAll();
        this.rawLogValues.clear();
        this.countedRawLogsListByField.clear();
        Iterator<String> it = sm.keySet().iterator();
        for (int i = 0; i < 20; ++i) {
            String key = null;
            Long value = null;
            if (!it.hasNext()) continue;
            key = it.next();
            this.rawLogValues.add(key);
            value = m.get(key);
            this.countedRawLogsListByField.put(key, value);
            JButton btn = new JButton(String.format("%d. %s - %d [%.1f%%]", i + 1, StringUtils.abbreviate((String)key, (int)70), value, Float.valueOf((float)value.longValue() / (float)total * 100.0f)));
            btn.setBorder(new EmptyBorder(3, 3, 3, 3));
            btn.setContentAreaFilled(false);
            btn.setFocusPainted(false);
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setCursor(new Cursor(12));
            btn.setForeground(ASTChart.COLORS[i]);
            btn.setToolTipText(key);
            btn.addMouseListener(this.listener);
            if (i < 10) {
                this.pButtonsLeft.add(btn);
                continue;
            }
            this.pButtonsRight.add(btn);
        }
        this.pButtonsLeft.invalidate();
        this.pButtonsLeft.validate();
        this.pButtonsLeft.repaint();
        this.pButtonsRight.invalidate();
        this.pButtonsRight.validate();
        this.pButtonsRight.repaint();
        this.pContent.invalidate();
        this.pContent.validate();
        this.pContent.repaint();
    }

    public List<String> getRawLogValues() {
        return this.rawLogValues;
    }

    public LinkedHashMap<String, Long> getCountedRawLogsListByField() {
        return this.countedRawLogsListByField;
    }

    public static class UpdateParams {
        private String query;
        private long timeStart;
        private long timeFinish;
        private String interval;
        private DisplayOptions displayOptions;
        private String field;
        private boolean sort;
        private int noSources;

        public UpdateParams(String query, long timeStart, long timeFinish, String interval) {
            this.query = query;
            this.timeStart = timeStart;
            this.timeFinish = timeFinish;
            this.interval = interval;
        }

        public UpdateParams(String query, DisplayOptions displayOptions, String field, boolean sort, int noSources) {
            this.query = query;
            this.displayOptions = displayOptions;
            this.field = field;
            this.sort = sort;
            this.noSources = noSources;
            this.timeStart = displayOptions.getTimeStart();
            this.timeFinish = displayOptions.getTimeFinish();
            this.interval = displayOptions.getIntervalObj().getValue();
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public long getTimeStart() {
            return this.timeStart;
        }

        public void setTimeStart(long timeStart) {
            this.timeStart = timeStart;
        }

        public long getTimeFinish() {
            return this.timeFinish;
        }

        public void setTimeFinish(long timeFinish) {
            this.timeFinish = timeFinish;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public DisplayOptions getDisplayOptions() {
            return this.displayOptions;
        }

        public void setDisplayOptions(DisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public boolean isSort() {
            return this.sort;
        }

        public void setSort(boolean sort) {
            this.sort = sort;
        }

        public int getNoSources() {
            return this.noSources;
        }

        public void setNoSources(int noSources) {
            this.noSources = noSources;
        }
    }

    private class SourcesUpdater
    extends SwingWorker<List<TermTimeHistogram>, Void> {
        private ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ByFieldPanel.class, (String)"TopNEventSourcesPanel.progress.title"));
        private UpdateParams params;
        private Class clazz;

        public SourcesUpdater(UpdateParams params, Class clazz) {
            this.params = params;
            this.clazz = clazz;
        }

        @Override
        protected List<TermTimeHistogram> doInBackground() throws Exception {
            this.ph.start();
            ByFieldPanel.this.startTimeOfWidgetCreation = System.currentTimeMillis();
            ByFieldPanel.this.setLoadingPanel();
            ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
            return apiService.getRLTermTimeHistogram(this.params.getQuery(), this.params.getField(), this.params.getTimeStart(), this.params.getTimeFinish(), this.params.getNoSources(), this.params.getInterval(), this.params.isSort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                logger.info(String.format("FETCHING OF TimeHistogram IS FINISHED IN %d ms", System.currentTimeMillis() - ByFieldPanel.this.startTimeOfWidgetCreation));
                List data = (List)this.get();
                Map<String, Long> m = ByFieldPanel.this.getTotalEventsByField(data);
                TreeMap<String, Long> sm = new TreeMap<String, Long>(new MyComparator(m, this.params.isSort()));
                sm.putAll(m);
                long total = 0L;
                Iterator it = sm.keySet().iterator();
                for (int i = 0; i < 20; ++i) {
                    String key = null;
                    Long value = null;
                    if (!it.hasNext()) continue;
                    key = (String)it.next();
                    value = m.get(key);
                    total += value.longValue();
                    ByFieldPanel.this.itemColors.put(key, ASTChart.COLORS[i]);
                }
                ByFieldPanel.this.populateButtons(m, sm, total);
                ChartPanel cpComponent = null;
                if (ByFieldPanel.this.chart == null) {
                    ByFieldPanel.this.chart = new OverviewChart(ByFieldPanel.this.createDataSet(data, sm, this.clazz));
                    cpComponent = ByFieldPanel.this.chart.getChartPanel();
                } else {
                    ByFieldPanel.this.chart.removeAllListeners();
                    ByFieldPanel.this.chart.updateChart(ByFieldPanel.this.createDataSet(data, sm, this.clazz));
                    cpComponent = ByFieldPanel.this.chart.getChartPanel();
                }
                ByFieldPanel.this.graphPanel.removeAll();
                ByFieldPanel.this.chart.addPlotChangeListener(ByFieldPanel.this.plotChangeListener);
                if (cpComponent != null) {
                    Dimension d = ByFieldPanel.this.getParent().getParent().getParent().getSize();
                    d.setSize(d.getWidth() - 35.0, 150.0);
                    cpComponent.setPreferredSize(new Dimension(0, 150));
                    cpComponent.setMaximumSize(d);
                    ByFieldPanel.this.graphPanel.add((Component)cpComponent);
                }
                ByFieldPanel.this.graphPanel.invalidate();
                ByFieldPanel.this.graphPanel.validate();
                ByFieldPanel.this.graphPanel.repaint();
                ByFieldPanel.this.pContainer.removeAll();
                ByFieldPanel.this.pContainer.add(ByFieldPanel.this.pData);
                ByFieldPanel.this.pContainer.invalidate();
                ByFieldPanel.this.pContainer.validate();
                ByFieldPanel.this.pContainer.repaint();
            }
            catch (InterruptedException | ExecutionException ex) {
                try {
                    ByFieldPanel.this.setReloadPanel();
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (Throwable throwable) {
                    this.ph.finish();
                    logger.info(String.format("CREATION OF WIDGET IS FINISHED IN %d ms", System.currentTimeMillis() - ByFieldPanel.this.startTimeOfWidgetCreation));
                    throw throwable;
                }
                this.ph.finish();
                logger.info(String.format("CREATION OF WIDGET IS FINISHED IN %d ms", System.currentTimeMillis() - ByFieldPanel.this.startTimeOfWidgetCreation));
            }
            this.ph.finish();
            logger.info(String.format("CREATION OF WIDGET IS FINISHED IN %d ms", System.currentTimeMillis() - ByFieldPanel.this.startTimeOfWidgetCreation));
        }
    }

    private static class MyComparator
    implements Comparator<String> {
        private Map<String, Long> map;
        private boolean sort;

        public MyComparator(Map<String, Long> map, boolean sort) {
            this.map = map;
            this.sort = sort;
        }

        @Override
        public int compare(String o1, String o2) {
            Long l1 = this.map.get(o1);
            Long l2 = this.map.get(o2);
            return this.sort ? (l1 <= l2 ? -1 : 1) : (l1 >= l2 ? -1 : 1);
        }
    }
}

