/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import rs.co.ast.aspen.gui.rawlogs.RawLogDetailsTableModel;

public class RawLogDetailsTableRenderer
extends DefaultTableCellRenderer {
    private static DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime();

    public RawLogDetailsTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int prefHeight;
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            if (row % 2 == 0) {
                Color c = new Color(255, 255, 204);
                this.setBackground(c);
            } else {
                this.setBackground(table.getBackground());
            }
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
            if (column == 0) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                cell.setBackground(table.getSelectionBackground());
                cell.setForeground(table.getSelectionForeground());
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        RawLogDetailsTableModel.Item item = (RawLogDetailsTableModel.Item)value;
        Object text = "";
        if (item != null) {
            switch (column) {
                case 0: {
                    if (item.key == null) {
                        text = "<html><b>" + item.category + "</b></html>";
                        break;
                    }
                    text = item.key;
                    break;
                }
                case 1: {
                    if (item.key == null || item.value == null) break;
                    if (item.key.equals("timestamp")) {
                        try {
                            text = isoTimeFormat.print(Long.valueOf(item.value).longValue());
                        }
                        catch (NumberFormatException ex) {
                            text = item.value;
                        }
                        break;
                    }
                    text = item.value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column index");
                }
            }
        }
        this.setText((String)text);
        if (!((String)text).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((String)text).length(); ++i) {
                if (i > 0 && i % 50 == 0) {
                    sb.append("<br>");
                }
                sb.append(((String)text).charAt(i));
            }
            sb.insert(0, "<HTML>").insert(sb.length(), "</HTML>");
            text = sb.toString();
            this.setToolTipText((String)text);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }
        if ((prefHeight = this.getPreferredSize().height) > table.getRowHeight(row)) {
            table.setRowHeight(row, prefHeight);
        }
        this.setVerticalAlignment(1);
        return this;
    }
}

