/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.joda.time.DateTime;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventDetailsTopComponent;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventWrapper;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTableModel;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTableRenderer;
import rs.co.ast.aspen.gui.module.alertevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.alertevents.FullscreenDisplayOptionsDisplayer;
import rs.co.ast.aspen.gui.module.alertevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.alertevents.search.SearchExecutor;
import rs.co.ast.aspen.gui.module.alertevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.alertevents.search.TaskMonitor;

public class AlertEventsFullScreenPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AlertEventsFullScreenPanel.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private SearchExecutor searchExecutor;
    private InstanceContent instanceContent = new InstanceContent();
    private Lookup selectedEvent = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private final DisplayOptions displayOptions = new DisplayOptions();
    private final Timer autoRefreshTimer;
    private AlertEventsTableModel tableModel = new AlertEventsTableModel();
    private String query;
    private static AlertEventWrapper prevEvent = null;
    private static RawLogSimWrapper prevLog = null;
    private String tag = UUID.randomUUID().toString();
    private static final int REFRESH_INTERVALS = 3600000;
    private JScrollPane jScrollPane;
    private JMenuItem miDisplayOptions;
    private JPopupMenu pmDisplayOptions;
    private JTable tAlertEvents;

    public AlertEventsFullScreenPanel() {
        this.initComponents();
        this.query = "*";
        this.displayOptions.setAutoRefresh(1);
        this.displayOptions.setPageSize(100);
        this.displayOptions.setQuery(this.query);
        this.displayOptions.setLastNHoursSelectedIndex(0);
        long now = System.currentTimeMillis();
        this.displayOptions.setTimeStart(now - 3600000L);
        this.displayOptions.setTimeFinish(now);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityEvent event = (SecurityEvent)AlertEventsFullScreenPanel.this.tableModel.getValueAt(AlertEventsFullScreenPanel.this.tAlertEvents.getSelectedRow(), AlertEventsFullScreenPanel.this.tAlertEvents.getSelectedColumn());
                String category = AlertEventsFullScreenPanel.this.tableModel.getColumnName(AlertEventsFullScreenPanel.this.tAlertEvents.getSelectedColumn()).replace("<html><b>", "").replace("</b></html>", "");
                String query = QueryManager.copyAlertEventColumn(event, category);
                StringSelection selection = new StringSelection(query);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(67, 2, false);
        this.tAlertEvents.registerKeyboardAction(listener, "Copy", stroke, 0);
        this.tAlertEvents.getTableHeader().setReorderingAllowed(false);
        this.tAlertEvents.setDefaultRenderer(SecurityEvent.class, new AlertEventsTableRenderer());
        this.tAlertEvents.setFillsViewportHeight(true);
        this.tAlertEvents.setSelectionMode(0);
        this.tAlertEvents.setRowSelectionAllowed(true);
        this.tAlertEvents.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private RequestProcessor rp = new RequestProcessor("TransmitFromSERawLogSimWrapper");
            private TopComponent alertEventDetails = WindowManager.getDefault().findTopComponent("AlertEventDetailsTopComponent");

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    final SecurityEvent event = (SecurityEvent)AlertEventsFullScreenPanel.this.tableModel.getValueAt(AlertEventsFullScreenPanel.this.tAlertEvents.getSelectedRow(), 0);
                    if (this.alertEventDetails.isOpened()) {
                        this.rp.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (event != null) {
                                    AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsFullScreenPanel.this.displayOptions, AlertEventsFullScreenPanel.this.tag);
                                    sew.setQuery(AlertEventsFullScreenPanel.this.query);
                                    if (prevEvent != null) {
                                        AlertEventsFullScreenPanel.this.instanceContent.remove((Object)prevEvent);
                                    }
                                    AlertEventsFullScreenPanel.this.instanceContent.add((Object)sew);
                                    prevEvent = sew;
                                }
                            }
                        });
                    }
                }
            }
        });
        this.tAlertEvents.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SecurityEvent event;
                if (e.getClickCount() == 2 && (event = (SecurityEvent)AlertEventsFullScreenPanel.this.tableModel.getValueAt(AlertEventsFullScreenPanel.this.tAlertEvents.getSelectedRow(), 0)) != null) {
                    TopComponent[] openedTopComponents;
                    Mode mode = WindowManager.getDefault().findMode("properties");
                    for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(mode)) {
                        if (!(tc instanceof AlertEventDetailsTopComponent)) continue;
                        return;
                    }
                    AlertEventDetailsTopComponent details = (AlertEventDetailsTopComponent)WindowManager.getDefault().findTopComponent("AlertEventDetailsTopComponent");
                    mode.dockInto((TopComponent)details);
                    AlertEventWrapper sew = new AlertEventWrapper(event, AlertEventsFullScreenPanel.this.displayOptions, AlertEventsFullScreenPanel.this.tag);
                    details.setSecurityEvent(sew);
                    details.open();
                    details.requestActive();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    AlertEventsFullScreenPanel.this.pmDisplayOptions.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tAlertEvents.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                AlertEventsFullScreenPanel.this.tAlertEvents.getSelectionModel().clearSelection();
                if (prevEvent != null) {
                    AlertEventsFullScreenPanel.this.instanceContent.remove((Object)prevEvent);
                }
                if (prevLog != null) {
                    AlertEventsFullScreenPanel.this.instanceContent.remove((Object)prevLog);
                }
            }
        });
        this.displayOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AlertEventsFullScreenPanel.this.displayOptions.save();
                if (AlertEventsFullScreenPanel.this.displayOptions.getAutoRefresh() == 0) {
                    AlertEventsFullScreenPanel.this.stopAutoRefreshTimer();
                } else {
                    AlertEventsFullScreenPanel.this.startAutoRefreshTimer();
                }
                AlertEventsFullScreenPanel.this.startSearch();
            }
        });
        this.autoRefreshTimer = new Timer(this.displayOptions.getAutoRefresh(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertEventsFullScreenPanel.this.startSearch();
            }
        });
    }

    public AlertEventsFullScreenPanel(String query) {
        this();
        this.query = query;
        this.displayOptions.setQuery(query);
    }

    public AlertEventsFullScreenPanel(PriorityQuery priorityQuery) {
        this(priorityQuery.toString());
    }

    public void setQuery(String query) {
        this.query = query;
        this.displayOptions.setQuery(query);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "PROP_EVENTS": {
                List events = (List)evt.getNewValue();
                this.tableModel.setData(events);
                break;
            }
            case "PROP_COUNT_TASK_FINISHED": {
                this.fetch((DateRange)evt.getNewValue());
                break;
            }
            case "PROP_FETCH_TASK_FINISHED": {
                try {
                    this.searchExecutor.count();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "PROP_COUNT_TASK_SKIPPED": {
                SkippedTaskInfo sti = (SkippedTaskInfo)evt.getNewValue();
                logger.info(String.format("Date Range skipped: s: %s, f: %s", new DateTime(sti.getStartTimeStamp()), new DateTime(sti.getFinishTimeStamp())));
                if (this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted()) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), sti);
                    break;
                }
                this.searchExecutor.addTaskToSkippedTask(sti);
                break;
            }
            case "PROP_ALL_COUNT_TASKS_FINISHED": {
                logger.info("PROP_ALL_COUNT_TASKS_FINISHED");
                List<SkippedTaskInfo> tasks = this.searchExecutor.getSearchContext().getSkippedTasks();
                for (SkippedTaskInfo ski : tasks) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), ski);
                }
                this.searchExecutor.getSearchContext().getSkippedTasks().clear();
                break;
            }
            case "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED": {
                logger.info("PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED");
            }
            case "PROP_ALL_FETCH_TASKS_FINISHED": {
                logger.info("PROP_ALL_FETCH_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_TASKS_FINISHED": {
                logger.info("ALL TASKS ARE COMPLETED");
                break;
            }
            case "PROP_FETCH_TASK_FAILED": 
            case "PROP_COUNT_TASK_FAILED": {
                List errors = (List)evt.getNewValue();
                logger.info(String.format("TASK FAILED: %s", errors));
                this.searchExecutor.shutdown();
            }
        }
    }

    public String getQuery() {
        return this.query;
    }

    public Lookup getSelectedEventLookup() {
        return this.selectedEvent;
    }

    public void startAutoRefreshTimer() {
        if (this.displayOptions.getAutoRefresh() > 0) {
            this.autoRefreshTimer.setInitialDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.start();
        }
    }

    public void stopAutoRefreshTimer() {
        this.autoRefreshTimer.stop();
    }

    public void startSearch() {
        this.tableModel.clearData();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
        this.displayOptions.adjustTime();
        try {
            logger.info(String.format("START SEARCH: s: %s f: %s", new DateTime(this.displayOptions.getTimeStart()), new DateTime(this.displayOptions.getTimeFinish())));
            this.searchExecutor = new SearchExecutor(this.displayOptions.getQuery(), this.displayOptions.getTimeStart(), this.displayOptions.getTimeFinish(), this.displayOptions.getIndexSplit(), this.displayOptions.getPageSize(), false, this);
            this.searchExecutor.startSearch();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fetch(DateRange dr) {
        try {
            this.searchExecutor.fetch(dr);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.pmDisplayOptions = new JPopupMenu();
        this.miDisplayOptions = new JMenuItem();
        this.jScrollPane = new JScrollPane();
        this.tAlertEvents = new JTable();
        Mnemonics.setLocalizedText((AbstractButton)this.miDisplayOptions, (String)NbBundle.getMessage(AlertEventsFullScreenPanel.class, (String)"AlertEventsFullScreenPanel.miDisplayOptions.text"));
        this.miDisplayOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertEventsFullScreenPanel.this.miDisplayOptionsActionPerformed(evt);
            }
        });
        this.pmDisplayOptions.add(this.miDisplayOptions);
        this.tAlertEvents.setModel(this.tableModel);
        this.jScrollPane.setViewportView(this.tAlertEvents);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 376, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 276, Short.MAX_VALUE).addContainerGap())));
    }

    private void miDisplayOptionsActionPerformed(ActionEvent evt) {
        FullscreenDisplayOptionsDisplayer.display(this.displayOptions);
    }

    public static enum PriorityQuery {
        PRIORITY_3("what.priority:3 NOT extra.tags:\"internal\""),
        PRIORITY_4("what.priority:4 NOT extra.tags:\"internal\""),
        PRIORITY_5("what.priority:5 NOT extra.tags:\"internal\"");

        private final String query;

        private PriorityQuery(String query) {
            this.query = query;
        }

        public String toString() {
            return this.query;
        }
    }
}

