/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.util.Args;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;

public class FiveMinute
extends RegularTimePeriod {
    public static final int FIRST_MINUTE_IN_HOUR = 0;
    public static final int LAST_MINUTE_IN_HOUR = 55;
    private Day day;
    private byte hour;
    private byte minute;
    private long firstMillisecond;
    private long lastMillisecond;

    public FiveMinute() {
        this(new Date());
    }

    public FiveMinute(int minute, Hour hour) {
        Args.nullNotPermitted((Object)hour, (String)"hour");
        this.minute = (byte)minute;
        this.hour = (byte)hour.getHour();
        this.day = hour.getDay();
        this.peg(Calendar.getInstance());
    }

    public FiveMinute(Date time) {
        this(time, TimeZone.getDefault(), Locale.getDefault());
    }

    public FiveMinute(Date time, TimeZone zone) {
        this(time, zone, Locale.getDefault());
    }

    public FiveMinute(Date time, TimeZone zone, Locale locale) {
        Args.nullNotPermitted((Object)time, (String)"time");
        Args.nullNotPermitted((Object)zone, (String)"zone");
        Args.nullNotPermitted((Object)locale, (String)"locale");
        Calendar calendar = Calendar.getInstance(zone, locale);
        calendar.setTime(time);
        int min = calendar.get(12);
        this.minute = (byte)min;
        this.hour = (byte)calendar.get(11);
        this.day = new Day(time, zone, locale);
        this.peg(calendar);
    }

    public FiveMinute(int minute, int hour, int day, int month, int year) {
        this(minute, new Hour(hour, new Day(day, month, year)));
    }

    public Day getDay() {
        return this.day;
    }

    public Hour getHour() {
        return new Hour((int)this.hour, this.day);
    }

    public int getHourValue() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Hour h;
        FiveMinute result = this.minute != 0 ? new FiveMinute(this.minute - 5, this.getHour()) : ((h = (Hour)this.getHour().previous()) != null ? new FiveMinute(55, h) : null);
        return result;
    }

    public RegularTimePeriod next() {
        Hour nextHour;
        FiveMinute result = this.minute != 55 ? new FiveMinute(this.minute + 5, this.getHour()) : ((nextHour = (Hour)this.getHour().next()) != null ? new FiveMinute(0, nextHour) : null);
        return result;
    }

    public long getSerialIndex() {
        long hourIndex = this.day.getSerialIndex() * 24L + (long)this.hour;
        return hourIndex * 60L + (long)this.minute;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int year = this.day.getYear();
        int month = this.day.getMonth() - 1;
        int d = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(year, month, d, this.hour, this.minute, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public long getLastMillisecond(Calendar calendar) {
        int year = this.day.getYear();
        int month = this.day.getMonth() - 1;
        int d = this.day.getDayOfMonth();
        calendar.clear();
        calendar.set(year, month, d, this.hour, this.minute, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Minute)) {
            return false;
        }
        FiveMinute that = (FiveMinute)((Object)obj);
        if (this.minute != that.minute) {
            return false;
        }
        return this.hour == that.hour;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.minute;
        result = 37 * result + this.hour;
        result = 37 * result + this.day.hashCode();
        return result;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof FiveMinute) {
            FiveMinute m = (FiveMinute)((Object)o1);
            result = this.getHour().compareTo((Object)m.getHour());
            if (result == 0) {
                result = this.minute - m.getMinute();
            }
        } else {
            result = o1 instanceof RegularTimePeriod ? 0 : 1;
        }
        return result;
    }

    public static FiveMinute parseMinute(String s) {
        FiveMinute result = null;
        String daystr = (s = s.trim()).substring(0, Math.min(10, s.length()));
        Day day = Day.parseDay((String)daystr);
        if (day != null) {
            String minstr;
            int minute;
            String hmstr = s.substring(Math.min(daystr.length() + 1, s.length()), s.length());
            String hourstr = (hmstr = hmstr.trim()).substring(0, Math.min(2, hmstr.length()));
            int hour = Integer.parseInt(hourstr);
            if (hour >= 0 && hour <= 23 && (minute = Integer.parseInt(minstr = hmstr.substring(Math.min(hourstr.length() + 1, hmstr.length()), hmstr.length()))) >= 0 && minute <= 59) {
                result = new FiveMinute(minute, new Hour(hour, day));
            }
        }
        return result;
    }
}

