/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.threats;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ThreatIndicator;
import rs.co.ast.aspen.gui.module.threats.DatabaseEvent;
import rs.co.ast.aspen.gui.module.threats.DatabaseEventListener;
import rs.co.ast.aspen.gui.module.threats.InMemoryDatabase;

public class ThreatTableModel
extends DefaultTableModel {
    List<ThreatIndicator> threatIndicators;
    private final List<String> columns = Stream.of(NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.IOC"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.Type"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.confidence"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.description"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.created"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.lastUpdate"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.sources"), NbBundle.getMessage(ThreatTableModel.class, (String)"ThreatTableModel.columnName.tags")).collect(Collectors.toList());
    private InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);
    private int rowCount = 0;
    private int currentRowIndex = 0;
    private Map<String, String> currentRow;
    private String newlyAddedColumn = "";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ThreatTableModel() {
        this.memDB.addDatabaseEventListener(new DatabaseEventListener(){

            @Override
            public void tableCreated(DatabaseEvent event) {
            }

            @Override
            public void dataInserted(DatabaseEvent event) {
                SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        ThreatTableModel.this.rowCount = 0;
                        ThreatTableModel.this.currentRowIndex = 0;
                        ThreatTableModel.this.currentRow = null;
                        ThreatTableModel.this.memDB.setColumns(ThreatTableModel.this.columns);
                        ThreatTableModel.this.rowCount = ThreatTableModel.this.memDB.getRowCount();
                        return true;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            SwingUtilities.invokeLater(() -> {
                                ThreatTableModel.this.fireTableStructureChanged();
                                ThreatTableModel.this.fireTableDataChanged();
                                ThreatTableModel.this.pcs.firePropertyChange("DATA_ADDED", false, true);
                            });
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                };
                worker.execute();
            }

            @Override
            public void functionQueryExecuted(DatabaseEvent event) {
            }
        });
    }

    public void setData(List<ThreatIndicator> threatIndicators) {
        this.threatIndicators = threatIndicators;
    }

    public ThreatIndicator getThreatIndicator(int index) {
        return this.threatIndicators != null ? this.threatIndicators.get(index) : null;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.currentRowIndex != rowIndex || this.currentRow == null) {
            this.currentRow = this.memDB.selectSpecificRow(rowIndex);
            if (this.currentRow != null) {
                ++this.currentRowIndex;
            }
        }
        String col = this.columns.get(columnIndex);
        return this.currentRow.get(col);
    }

    public List<String> getColumnNames() {
        return this.columns;
    }

    public void resetData() {
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void setNewlyAddedColumn(String columnName) {
        this.newlyAddedColumn = columnName;
    }

    public String getNewlyAddedColumn() {
        return this.newlyAddedColumn;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

