/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.gui.module.prseditor.JSONFileFilter;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;

public final class ExportRuleSets
implements ActionListener {
    private final ObjectMapper mapper = new ObjectMapper();
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final RootNode node;

    public ExportRuleSets(RootNode node) {
        this.node = node;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        block9: {
            try {
                RuleSetBackupContainerDTO rsbc = this.model.exportRuleSets();
                this.mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
                this.mapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new MyNullKeySerializer());
                JFileChooser saveFileDialog = new JFileChooser();
                saveFileDialog.setFileFilter(new JSONFileFilter());
                saveFileDialog.setAcceptAllFileFilterUsed(false);
                int result = saveFileDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                if (result != 0) break block9;
                String file = saveFileDialog.getSelectedFile() + ".json";
                try (FileOutputStream os = new FileOutputStream(file);){
                    this.mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, (Object)rsbc);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                NotificationDisplayer.getDefault().notify(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"ExportRuleSetsConfirmation.title"), (Icon)new ImageIcon(), String.format(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"ExportRuleSetsConfirmation.message"), file), null);
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class MyNullKeySerializer
    extends JsonSerializer<Object> {
        private MyNullKeySerializer() {
        }

        public void serialize(Object t, JsonGenerator jg, SerializerProvider sp) throws IOException, JsonProcessingException {
            jg.writeFieldName("");
        }
    }
}

