/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RuleSetNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public final class DeleteGroupAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DeleteGroupAction.class.getName());
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final ParsingRulesGroupDTOWrapper group;

    public DeleteGroupAction(ParsingRulesGroupDTOWrapper group) {
        this.group = group;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        RulesGroupNode groupNode;
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"DeleteGroupConfirmation.message"), NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"DeleteGroupConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION && (groupNode = (RulesGroupNode)Utilities.actionsGlobalContext().lookup(RulesGroupNode.class)) != null) {
            Node parentNode;
            Set ruleNamesWithResetMatchedGroupId = this.model.removeGroup(this.group.getId());
            LOGGER.info(String.format("ruleNamesWithResetMatchedGroupId: %s", ruleNamesWithResetMatchedGroupId));
            if (!ruleNamesWithResetMatchedGroupId.isEmpty()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)String.format(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RulesWithChangedJumpTo.message"), String.join((CharSequence)",", ruleNamesWithResetMatchedGroupId)), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            if ((parentNode = groupNode.getParentNode()) != null) {
                if (parentNode instanceof RulesGroupNode) {
                    RulesGroupNode node = (RulesGroupNode)parentNode;
                    node.updateChildren(this.group.getParentId());
                } else {
                    RuleSetNode node = (RuleSetNode)parentNode;
                    node.updateChildren(this.group.getParentId());
                }
            }
        }
    }
}

