/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ParsingRuleAssignment;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;

public class AssignmentPanel
extends JPanel
implements PropertyChangeListener {
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private ParsingRuleAssignment assignment;
    private JButton bDeleteAssignment;
    private JComboBox cbCategory;
    private JComboBox cbKey;
    private JTextField tfValue;

    public AssignmentPanel(ParsingRuleAssignment ass) {
        this.initComponents();
        this.addAncestorListener(new MyAncestorListener(this).getAncestorListener());
        this.updateEditMode();
        this.assignment = ass;
        this.updateDisplay(this.assignment);
        this.cbCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prevKeySelectedItem = (String)AssignmentPanel.this.cbKey.getSelectedItem();
                AssignmentPanel.this.updateKeyList((String)AssignmentPanel.this.cbCategory.getSelectedItem());
                AssignmentPanel.this.cbKey.setSelectedItem(prevKeySelectedItem);
                ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
                AssignmentPanel.this.model.setAssignmentCategory(rule, AssignmentPanel.this.assignment, (String)AssignmentPanel.this.cbCategory.getSelectedItem());
            }
        });
        this.cbKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
                AssignmentPanel.this.model.setAssignmentKey(rule, AssignmentPanel.this.assignment, (String)AssignmentPanel.this.cbKey.getSelectedItem());
            }
        });
        this.tfValue.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AssignmentPanel.this.updateValue();
            }
        });
    }

    private void updateValue() {
        String tmp;
        String text = this.tfValue.getText();
        String value = this.assignment.getValue();
        if (value == null) {
            value = "";
        }
        if (!value.equals(text) && !(tmp = this.tfValue.getText()).equals("")) {
            ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
            this.model.setAssignmentValue(rule, this.assignment, tmp);
        }
    }

    public final void updateDisplay(ParsingRuleAssignment assignment) {
        this.cbCategory.setSelectedItem(assignment.getCategory());
        this.updateKeyList(assignment.getCategory());
        this.cbKey.setSelectedItem(assignment.getKey());
        this.tfValue.setText(assignment.getValue());
    }

    public ParsingRuleAssignment getAssignment() {
        return this.assignment;
    }

    private void updateKeyList(String category) {
        List mappingsForCategory = this.model.getMappingsForCategory(category);
        this.cbKey.removeAllItems();
        if (mappingsForCategory != null) {
            mappingsForCategory.forEach(this.cbKey::addItem);
        }
    }

    private void updateEditMode() {
        this.cbCategory.setEnabled(this.model.isEditMode());
        this.cbKey.setEnabled(this.model.isEditMode());
        this.tfValue.setEditable(this.model.isEditMode());
        this.bDeleteAssignment.setEnabled(this.model.isEditMode());
    }

    private void initComponents() {
        this.cbCategory = new JComboBox();
        this.cbKey = new JComboBox();
        this.tfValue = new JTextField();
        this.bDeleteAssignment = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cbCategory.setFont(new Font("Dialog", 0, 12));
        this.cbCategory.setModel(new DefaultComboBoxModel<String>(new String[]{"what", "where", "when", "who", "extra", "meta"}));
        this.cbKey.setEditable(true);
        this.cbKey.setFont(new Font("Dialog", 0, 12));
        this.bDeleteAssignment.setFont(new Font("Dialog", 0, 12));
        this.bDeleteAssignment.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDeleteAssignment, (String)NbBundle.getMessage(AssignmentPanel.class, (String)"AssignmentPanel.bDeleteAssignment.text"));
        this.bDeleteAssignment.setMargin(new Insets(0, 0, 0, 0));
        this.bDeleteAssignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssignmentPanel.this.bDeleteAssignmentActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKey, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfValue, -1, 152, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDeleteAssignment).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbCategory, -2, -1, -2).addComponent(this.cbKey, -2, -1, -2).addComponent(this.tfValue, -2, -1, -2).addComponent(this.bDeleteAssignment)));
    }

    private void bDeleteAssignmentActionPerformed(ActionEvent evt) {
        ParsingRuleDTOWrapper rule = (ParsingRuleDTOWrapper)Utilities.actionsGlobalContext().lookup(ParsingRuleDTOWrapper.class);
        this.model.removeAssignment(rule, this.assignment);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("editModeChanged")) {
            this.updateEditMode();
        }
    }

    public class MyAncestorListener
    implements AncestorListener {
        private final AssignmentPanel panel;

        public MyAncestorListener(AssignmentPanel panel) {
            this.panel = panel;
        }

        public AncestorListener getAncestorListener() {
            return this;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            AssignmentPanel.this.model.addPropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            AssignmentPanel.this.model.removePropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

