/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxRenderer
extends JLabel
implements ListCellRenderer<String> {
    private final List<Color> hostColors = Stream.of(new Color(31, 119, 180), new Color(174, 199, 232), new Color(255, 127, 14), new Color(255, 187, 120), new Color(44, 160, 44), new Color(152, 223, 138), new Color(214, 39, 40), new Color(255, 152, 150), new Color(148, 103, 189), new Color(197, 176, 213), new Color(140, 86, 75), new Color(196, 156, 148), new Color(227, 119, 194), new Color(247, 182, 210), new Color(188, 189, 34), new Color(219, 219, 141), new Color(23, 190, 207), new Color(158, 218, 229)).collect(Collectors.toList());

    public ComboBoxRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(String.valueOf(value));
        if (index > -1 && value != null) {
            this.setForeground(this.getColor(index));
        }
        if (isSelected || cellHasFocus) {
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setBackground(Color.BLACK);
        }
        return this;
    }

    public Color getColor(String value) {
        if (value.contains("#?")) {
            String[] split = value.split("\\?");
            String[] rgbNumbers = split[1].split(",");
            int[] numbers = new int[rgbNumbers.length];
            for (int i = 0; i < rgbNumbers.length; ++i) {
                numbers[i] = Integer.parseInt(rgbNumbers[i]);
            }
            return new Color(numbers[0], numbers[1], numbers[2]);
        }
        return Color.WHITE;
    }

    public Color getColor(int index) {
        if (index != -1) {
            if (index >= this.hostColors.size()) {
                return this.hostColors.get(index % 18);
            }
            return this.hostColors.get(index);
        }
        return Color.WHITE;
    }
}

