/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.model;

import java.util.List;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.gui.module.datamaps.DatamapEvent;
import rs.co.ast.aspen.gui.module.datamaps.DatamapEventListener;
import rs.co.ast.aspen.gui.module.datamaps.DatamapListenerSupport;

public class DataMapModel {
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private final DatamapListenerSupport datamapSupport = new DatamapListenerSupport();
    private boolean selectionMode = false;

    public void deleteDataMap(String dataMapName) {
        try {
            this.apiService.deleteDataMap(dataMapName);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void deleteDataMapKey(String dataMapName, String dataMapKey) {
        try {
            this.apiService.deleteDataMapKey(dataMapName, dataMapKey);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void renameDataMapKey(String dataMapName, String oldDataMapKey, String newDataMapKey) {
        try {
            this.apiService.renameDataMapKey(dataMapName, oldDataMapKey, newDataMapKey);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void updateDataMapValue(String dataMapName, String dataMapKey, String keyValue) {
        try {
            this.apiService.setValueForDataMapKey(dataMapName, dataMapKey, keyValue);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public List<String> getDatamapsNames() {
        try {
            return this.apiService.getDataMapNames();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public boolean isSelectionMode() {
        return this.selectionMode;
    }

    public void toggleSelectionMode() {
        this.selectionMode = !this.selectionMode;
        this.datamapSupport.fireToggleSelectionModeEventListener(new DatamapEvent(this));
    }

    public void addScriptUpdatedEventListener(DatamapEventListener listener) {
        this.datamapSupport.addDatamapEventListener(listener);
    }

    public void removeScriptUpdatedEventListener(DatamapEventListener listener) {
        this.datamapSupport.removeDatamapEventListener(listener);
    }

    public void fireToggleSelectionModeEventListener(DatamapEvent event) {
        this.datamapSupport.fireToggleSelectionModeEventListener(event);
    }
}

