/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lsp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lsp.Command;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.modules.lsp.CompletionAccessor;
import org.netbeans.spi.editor.mimelookup.MimeLocation;
import org.openide.util.RequestProcessor;

@MimeLocation(subfolderName="CompletionCollectors")
public interface CompletionCollector {
    public boolean collectCompletions(@NonNull Document var1, int var2, @NullAllowed Completion.Context var3, @NonNull Consumer<Completion> var4);

    public static Builder newBuilder(@NonNull String label) {
        return new Builder(label);
    }

    public static final class Builder {
        private String label;
        private Completion.Kind kind;
        private List<Completion.Tag> tags;
        private CompletableFuture<String> detail;
        private CompletableFuture<String> documentation;
        private boolean preselect;
        private String sortText;
        private String filterText;
        private String insertText;
        private Completion.TextFormat insertTextFormat;
        private TextEdit textEdit;
        private Command command;
        private CompletableFuture<List<TextEdit>> additionalTextEdits;
        private List<Character> commitCharacters;

        private Builder(@NonNull String label) {
            this.label = label;
        }

        @NonNull
        public Builder label(@NonNull String label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder kind(@NonNull Completion.Kind kind) {
            this.kind = kind;
            return this;
        }

        @NonNull
        public Builder addTag(@NonNull Completion.Tag tag) {
            if (this.tags == null) {
                this.tags = new ArrayList<Completion.Tag>();
            }
            this.tags.add(tag);
            return this;
        }

        @NonNull
        public Builder detail(@NonNull String detail) {
            this.detail = CompletableFuture.completedFuture(detail);
            return this;
        }

        @NonNull
        public Builder detail(@NonNull Supplier<String> detail) {
            this.detail = new LazyCompletableFuture<String>(detail);
            return this;
        }

        @NonNull
        public Builder documentation(@NonNull String documentation) {
            this.documentation = CompletableFuture.completedFuture(documentation);
            return this;
        }

        @NonNull
        public Builder documentation(@NonNull Supplier<String> documentation) {
            this.documentation = new LazyCompletableFuture<String>(documentation);
            return this;
        }

        @NonNull
        public Builder preselect(boolean preselect) {
            this.preselect = preselect;
            return this;
        }

        @NonNull
        public Builder sortText(@NonNull String sortText) {
            this.sortText = sortText;
            return this;
        }

        @NonNull
        public Builder filterText(@NonNull String filterText) {
            this.filterText = filterText;
            return this;
        }

        @NonNull
        public Builder insertText(@NonNull String insertText) {
            this.insertText = insertText;
            this.textEdit = null;
            return this;
        }

        @NonNull
        public Builder insertTextFormat(@NonNull Completion.TextFormat insertTextFormat) {
            this.insertTextFormat = insertTextFormat;
            return this;
        }

        @NonNull
        public Builder textEdit(@NonNull TextEdit textEdit) {
            this.textEdit = textEdit;
            this.insertText = null;
            return this;
        }

        @NonNull
        public Builder command(@NonNull Command command) {
            this.command = command;
            return this;
        }

        @NonNull
        public Builder additionalTextEdits(@NonNull List<TextEdit> additionalTextEdits) {
            this.additionalTextEdits = CompletableFuture.completedFuture(additionalTextEdits);
            return this;
        }

        @NonNull
        public Builder additionalTextEdits(@NonNull Supplier<List<TextEdit>> additionalTextEdits) {
            this.additionalTextEdits = new LazyCompletableFuture<List<TextEdit>>(additionalTextEdits);
            return this;
        }

        @NonNull
        public Builder addCommitCharacter(char commitCharacter) {
            if (this.commitCharacters == null) {
                this.commitCharacters = new ArrayList<Character>();
            }
            this.commitCharacters.add(Character.valueOf(commitCharacter));
            return this;
        }

        @NonNull
        public Completion build() {
            return CompletionAccessor.getDefault().createCompletion(this.label, this.kind, this.tags, this.detail, this.documentation, this.preselect, this.sortText, this.filterText, this.insertText, this.insertTextFormat, this.textEdit, this.command, this.additionalTextEdits, this.commitCharacters);
        }

        private static class LazyCompletableFuture<T>
        extends CompletableFuture<T> {
            private static final RequestProcessor ASYNC_WORKER = new RequestProcessor(LazyCompletableFuture.class.getName(), 1);
            private final Supplier<T> supplier;

            private LazyCompletableFuture(Supplier<T> supplier) {
                this.supplier = supplier;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    this.complete(this.supplier.get());
                }
                catch (Exception ex) {
                    this.completeExceptionally(ex);
                }
                return super.get();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                ((CompletableFuture)CompletableFuture.supplyAsync(this.supplier, (Executor)ASYNC_WORKER).thenAccept(t -> this.complete(t))).exceptionally((T ex) -> {
                    this.completeExceptionally((Throwable)ex);
                    return null;
                });
                return super.get(timeout, unit);
            }
        }
    }
}

