/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.filetype;

import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import rs.co.ast.aspen.gui.module.alertevents.AlertEventsTopComponent;

public class AlertEventDataObject
extends MultiDataObject
implements OpenCookie {
    private static final Logger logger = Logger.getLogger(AlertEventDataObject.class.getName());

    public static MultiViewEditorElement createEditor(Lookup lkp) {
        return new MultiViewEditorElement(lkp);
    }

    public AlertEventDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.registerEditor("text/x-alertevent", true);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public void open() {
        AlertEventsTopComponent setc = new AlertEventsTopComponent();
        setc.open();
        setc.requestActive();
        try {
            long start = (Long)this.getPrimaryFile().getAttribute("start");
            logger.info(String.format("start %d", start));
            long finish = (Long)this.getPrimaryFile().getAttribute("finish");
            logger.info(String.format("finish %d", finish));
            boolean lastNHours = (Boolean)this.getPrimaryFile().getAttribute("lastNHours");
            logger.info(String.format("lastNHours %s", lastNHours));
            boolean now = (Boolean)this.getPrimaryFile().getAttribute("now");
            logger.info(String.format("now %s", now));
            int lastNHoursSelectedIndex = (Integer)this.getPrimaryFile().getAttribute("lastNHoursSelectedIndex");
            logger.info(String.format("lastNHoursSelectedIndex %d", lastNHoursSelectedIndex));
            boolean asc = (Boolean)this.getPrimaryFile().getAttribute("ASC");
            logger.info(String.format("ASC %s", asc));
            setc.getDisplayOptions().toggleFireEvents();
            setc.getDisplayOptions().setNow(now);
            setc.getDisplayOptions().setLastNHours(lastNHours);
            setc.getDisplayOptions().setLastNHoursSelectedIndex(lastNHoursSelectedIndex);
            setc.getDisplayOptions().setTimeStart(start);
            setc.getDisplayOptions().setTimeFinish(finish);
            setc.getDisplayOptions().toggleFireEvents();
            if (asc) {
                setc.setAsc();
            }
            setc.doSearch((String)this.getPrimaryFile().getAttribute("query"), start, finish);
        }
        catch (NullPointerException ex) {
            setc.doSearch((String)this.getPrimaryFile().getAttribute("query"));
        }
    }

    protected int associateLookup() {
        return 1;
    }
}

