/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.simplecorrelator;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import rs.co.ast.aspen.gui.module.alertevents.simplecorrelator.ActionTextFieldComboBoxNodeData;

public class EditorTextFieldComboBox
extends JPanel
implements CellEditor {
    private JLabel label;
    private JComboBox comboBoxE;
    private JTextField textField;
    private ActionTextFieldComboBoxNodeData node;
    private List listeners = new ArrayList();

    public EditorTextFieldComboBox() {
        String[] m = new String[]{"1", "2"};
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(100, 24));
        this.comboBoxE = new JComboBox<String>(m);
        this.label = new JLabel();
        this.label.setIcon(new ImageIcon(this.getClass().getResource("/application_form_edit.png")));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        this.setBackground(UIManager.getColor("Tree.background"));
        this.setLayout(flowLayout);
        this.add(this.label);
        this.add(this.textField);
        this.add(this.comboBoxE);
        this.textField.addActionListener(e -> {
            if (this.stopCellEditing()) {
                this.fireEditingStopped();
            }
        });
        this.comboBoxE.addActionListener(e -> {
            if (this.comboBoxE.isPopupVisible() && this.stopCellEditing()) {
                this.fireEditingStopped();
            }
        });
    }

    void setNode(ActionTextFieldComboBoxNodeData textComboBoxNodeData) {
        String[] values;
        this.node = textComboBoxNodeData;
        this.comboBoxE.removeAllItems();
        for (String value : values = textComboBoxNodeData.getValues()) {
            this.comboBoxE.addItem(value);
        }
        this.comboBoxE.setSelectedIndex(textComboBoxNodeData.getSelectedIndex());
        this.textField.setText(textComboBoxNodeData.getText());
        this.label.setText(textComboBoxNodeData.getProperty());
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent == null || anEvent instanceof MouseEvent && ((MouseEvent)anEvent).isMetaDown();
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.comboBoxE.isPopupVisible()) {
            this.node.setSelectedIndex(this.comboBoxE.getSelectedIndex());
        }
        if (!this.textField.getText().isEmpty()) {
            this.node.setText(this.textField.getText().replace(" ", ""));
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getCellEditorValue() {
        return this.node;
    }

    protected void fireEditingStopped() {
        if (this.listeners.size() > 0) {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.listeners.get(i)).editingStopped(ce);
            }
        }
    }
}

