/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents.search;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEventsCountContainer;
import rs.co.ast.aspen.gui.module.alertevents.search.SearchContext;
import rs.co.ast.aspen.gui.module.alertevents.search.SearchTask;
import rs.co.ast.aspen.gui.module.alertevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.alertevents.search.TaskMonitor;

public final class CountTask
implements SearchTask<SwingWorker<SecurityEventsCountContainer, Void>, SecurityEventsCountContainer> {
    private static final Logger logger = Logger.getLogger(CountTask.class.getName());
    private SearchState searchState = new SearchState();
    private SearchContext searchContext;
    private String query;
    private DateRange dateRange;
    private long timeout;
    private SecurityEventsCountContainer results;

    public CountTask(SearchContext searchContext, String query, DateRange dateRange) {
        this.searchContext = searchContext;
        this.query = query;
        this.dateRange = dateRange;
        this.timeout = 60000L;
        this.searchContext.getSearchStateForDateRange().put(dateRange, this.searchState);
    }

    public CountTask(SearchContext searchContext, String query, DateRange dateRange, long timeout) {
        this(searchContext, query, dateRange);
        this.timeout = timeout;
    }

    @Override
    public SwingWorker<SecurityEventsCountContainer, Void> getTask() {
        return new SwingWorker<SecurityEventsCountContainer, Void>(){

            @Override
            protected SecurityEventsCountContainer doInBackground() throws Exception {
                return SearchTask.apiService.alertEventsCountSearch(CountTask.this.query, CountTask.this.searchState, CountTask.this.dateRange.getStartTimeStamp(), CountTask.this.dateRange.getFinishTimeStamp());
            }

            @Override
            protected void done() {
                try {
                    CountTask.this.results = (SecurityEventsCountContainer)this.get(CountTask.this.timeout, TimeUnit.MILLISECONDS);
                    if (!CountTask.this.results.getErrors().isEmpty()) {
                        CountTask.this.searchContext.getSearchResults().addErrors(CountTask.this.results.getErrors());
                        logger.log(Level.SEVERE, CountTask.this.results.getErrors().toString());
                        if (CountTask.this.isQueryNotValidError(CountTask.this.results.getErrors())) {
                            logger.info(String.format("SKIPPED TASK s: %s, f: %s", new DateTime(CountTask.this.dateRange.getStartTimeStamp()), new DateTime(CountTask.this.dateRange.getFinishTimeStamp())));
                            this.firePropertyChange("PROP_COUNT_TASK_FAILED", null, CountTask.this.results.getErrors());
                        }
                    }
                    if (CountTask.this.results.getSearchState().getTotalHits() < 0L) {
                        CountTask.this.searchContext.getSearchStateForDateRange().put(CountTask.this.dateRange, CountTask.this.results.getSearchState());
                        this.firePropertyChange("PROP_COUNT_TASK_SKIPPED", null, new SkippedTaskInfo(CountTask.this.query, CountTask.this.dateRange));
                    } else {
                        logger.info(String.format("TOTAL HITS: %d, s: %s f: %s", CountTask.this.results.getSearchState().getTotalHits(), new DateTime(CountTask.this.dateRange.getStartTimeStamp()), new DateTime(CountTask.this.dateRange.getFinishTimeStamp())));
                        CountTask.this.searchContext.getSearchResults().addToTotalHits(CountTask.this.results.getSearchState().getTotalHits());
                        CountTask.this.searchContext.getSearchResults().addToTotalDuration(CountTask.this.results.getSearchState().getLastSearchDuration());
                        CountTask.this.searchContext.getSearchResults().getCountsByDateRange().put(CountTask.this.dateRange, CountTask.this.results.getSearchState().getTotalHits());
                        CountTask.this.searchContext.getSearchStateForDateRange().put(CountTask.this.dateRange, CountTask.this.results.getSearchState());
                        CountTask.this.searchContext.getTaskMonitor().completeTask(TaskMonitor.BaseTaskName.COUNT, CountTask.this.dateRange.getStartTimeStamp(), CountTask.this.dateRange.getFinishTimeStamp());
                        this.firePropertyChange("PROP_COUNT_TASK_FINISHED_SUCCESS", null, CountTask.this.dateRange);
                    }
                    this.firePropertyChange("PROP_GOT_COUNT_RESULTS", null, CountTask.this.results);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    this.firePropertyChange("PROP_COUNT_TASK_FINISHED", null, CountTask.this.dateRange);
                }
            }
        };
    }

    public boolean isQueryNotValidError(List<String> errors) {
        for (String error : errors) {
            if (!error.contains("is NOT valid!")) continue;
            return true;
        }
        return false;
    }

    @Override
    public SecurityEventsCountContainer getResult() {
        return this.results;
    }
}

