/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.alertevents;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.joda.time.DateTime;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import rs.co.ast.aspen.gui.module.alertevents.IntervalObject;
import rs.co.ast.chart.FiveMinute;
import rs.co.ast.chart.ThirtyMinute;
import rs.co.ast.chart.ThreeHour;
import rs.co.ast.chart.TwelveHour;

public class DisplayOptions {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private long currentTime = System.currentTimeMillis();
    private long timeStart = this.currentTime - 28800000L;
    private long timeFinish = this.currentTime;
    private int autoRefresh = 0;
    private int pageSize = 100;
    private String query = "*";
    private boolean descOrder = true;
    private boolean isDescToggleButtonVisible = true;
    private IntervalObject[] intervals = new IntervalObject[]{new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.one.minute"), "1m", Minute.class), new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.five.minute"), "5m", FiveMinute.class), new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.thirty.minute"), "30m", ThirtyMinute.class), new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.one.hour"), "1h", Hour.class), new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.three.hour"), "3h", ThreeHour.class), new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.twelve.hour"), "12h", TwelveHour.class), new IntervalObject(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptions.one.day"), "1d", Day.class)};
    private IntervalObject intervalObj = this.intervals[1];
    private List<Integer> items = Arrays.asList(1, 2, 4, 8, 12, 24, 48);
    private List<String> itemsForNextNHours = Arrays.asList(NbBundle.getMessage(DisplayOptions.class, (String)"DisplayOptionsPanel.Now"), "8", "12", "24", "48");
    private boolean lastNHours = true;
    private boolean now = true;
    private int lastNHoursSelectedIndex = 3;
    private boolean fireEvents = true;
    private boolean manualIntervalObj = false;
    private boolean showOverview = true;
    private List<Integer> threadsNumbers = Arrays.asList(1, 2, 3);
    private int widgetThreads = 1;
    private long indexSplit = 28800000L;
    private boolean chartManuallyOpened = false;
    private int timeShift = 8;

    public void load() {
        Preferences p = NbPreferences.forModule(DisplayOptions.class);
        this.autoRefresh = p.getInt("autoRefresh", 0);
        this.pageSize = p.getInt("pageSize", 100);
    }

    public void save() {
        Preferences p = NbPreferences.forModule(DisplayOptions.class);
        p.putInt("autoRefresh", this.autoRefresh);
        p.putInt("pageSize", this.pageSize);
    }

    public int getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(int autoRefresh) {
        int oldAutoRefresh = this.autoRefresh;
        this.autoRefresh = autoRefresh;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("autoRefresh", oldAutoRefresh, autoRefresh);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        int oldPageSize = this.pageSize;
        this.pageSize = pageSize;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("pageSize", oldPageSize, pageSize);
        }
    }

    public void setPageSizeWithoutSearch(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public void setTimeStart(long timeStart) {
        long oldTimeStart = this.timeStart;
        this.timeStart = timeStart;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("timeStart", oldTimeStart, timeStart);
        }
    }

    public long getTimeFinish() {
        return this.timeFinish;
    }

    public void setTimeFinish(long timeFinish) {
        long oldTimeFinish = this.timeFinish;
        this.timeFinish = timeFinish;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("timeFinish", oldTimeFinish, timeFinish);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public IntervalObject getIntervalObj() {
        return this.intervalObj;
    }

    public void setIntervalObj(IntervalObject intervalObj) {
        IntervalObject oldIO = this.intervalObj;
        this.intervalObj = intervalObj;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("intervalObj", oldIO, intervalObj);
        }
    }

    public IntervalObject[] getIntervals() {
        return this.intervals;
    }

    public void setIntervals(IntervalObject[] intervals) {
        IntervalObject[] oldIntervals = this.intervals;
        this.intervals = intervals;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("intervals", oldIntervals, intervals);
        }
    }

    public boolean isLastNHours() {
        return this.lastNHours;
    }

    public void setLastNHours(boolean lastNHours) {
        this.lastNHours = lastNHours;
    }

    public boolean isNow() {
        return this.now;
    }

    public void setNow(boolean now) {
        this.now = now;
    }

    public int getLastNHoursSelectedIndex() {
        return this.lastNHoursSelectedIndex;
    }

    public void setLastNHoursSelectedIndex(int lastNHoursSelectedIndex) {
        int oldLastNHoursSelectedIndex = this.lastNHoursSelectedIndex;
        this.lastNHoursSelectedIndex = lastNHoursSelectedIndex;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("lastNHoursSelectedIndex", oldLastNHoursSelectedIndex, lastNHoursSelectedIndex);
        }
    }

    public List<Integer> getLastNHourItems() {
        return this.items;
    }

    public List<String> getNextNHoursItems() {
        return this.itemsForNextNHours;
    }

    public boolean isFireEvents() {
        return this.fireEvents;
    }

    public void toggleFireEvents() {
        this.fireEvents = !this.fireEvents;
    }

    public void firePropertyChangedEvent() {
        this.pcs.firePropertyChange("display_options", null, "");
    }

    public void adjustTime() {
        if (this.lastNHours) {
            DateTime dtFinish = new DateTime(this.timeFinish);
            if (this.now) {
                dtFinish = new DateTime(System.currentTimeMillis());
            }
            DateTime dtStart = dtFinish.minusHours(this.items.get(this.lastNHoursSelectedIndex).intValue());
            this.timeStart = dtStart.getMillis();
            this.timeFinish = dtFinish.getMillis();
        }
        if (this.now && !this.lastNHours) {
            this.timeFinish = System.currentTimeMillis();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean isManualIntervalObj() {
        return this.manualIntervalObj;
    }

    public void setManualIntervalObj(boolean manualIntervalObj) {
        this.manualIntervalObj = manualIntervalObj;
    }

    public void resetManualIntervalObj() {
        this.manualIntervalObj = false;
    }

    public boolean isShowOverview() {
        return this.showOverview;
    }

    public void setShowOverview(boolean showOverview) {
        this.showOverview = showOverview;
    }

    public boolean isChartManuallyOpened() {
        return this.chartManuallyOpened;
    }

    public void setChartManuallyOpened(boolean chartManualOpened) {
        this.chartManuallyOpened = chartManualOpened;
    }

    public int getWidgetThreads() {
        return this.widgetThreads;
    }

    public void setWidgetThreads(int widgetThreads) {
        this.widgetThreads = widgetThreads;
    }

    public List<Integer> getThreadsNumber() {
        return this.threadsNumbers;
    }

    public long getIndexSplit() {
        return this.indexSplit;
    }

    public void setIndexSplit(long indexSplit) {
        this.indexSplit = indexSplit;
    }

    public boolean isDescOrder() {
        return this.descOrder;
    }

    public void setDescOrder(boolean descOrder) {
        this.descOrder = descOrder;
    }

    public boolean isDescToggleButtonVisible() {
        return this.isDescToggleButtonVisible;
    }

    public void setIsDescToggleButtonVisible(boolean isDescToggleButtonVisible) {
        this.isDescToggleButtonVisible = isDescToggleButtonVisible;
    }

    public int getTimeShift() {
        return this.timeShift;
    }

    public void setTimeShift(int timeShift) {
        int oldTimeShift = this.timeShift;
        this.timeShift = timeShift;
        if (this.fireEvents) {
            this.pcs.firePropertyChange("timeShiftNumberChange", oldTimeShift, this.timeShift);
        }
    }
}

