/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;

public class TopComponentTitleShortener {
    private static final int MAX_DISPLAY_NAME_WIDTH = 13;
    private static final ApiService API_SERVICE = (ApiService)Lookup.getDefault().lookup(ApiService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String shortenTitle(String query) throws ApiServiceException_Exception {
        String ret = query;
        try {
            String title = query = query.replaceAll("_", "").replaceAll("-", "").replaceAll("'", "").replaceAll(" AND ", "&").replaceAll(" OR ", "|").replaceAll(" NOT ", "^").replaceAll("NOT ", "^");
            if (title.length() <= 13) {
                String string = query;
                return string;
            }
            title = API_SERVICE.getSavedQueryName(query);
            if (title != null) {
                String string = title;
                return string;
            }
            title = Pattern.quote(query);
            Pattern p = Pattern.compile("([^\\s\"\\|&\\^]+)");
            Matcher m = p.matcher(title);
            if (!m.lookingAt()) {
                while (m.find()) {
                    String val = m.group();
                    if (val.length() < 3) continue;
                    StringBuilder sb = new StringBuilder();
                    String[] words = val.split(" ");
                    if (words.length > 1) {
                        for (String word : words) {
                            first = word.charAt(0);
                            last = word.charAt(word.length() - 1);
                            sb.append(String.valueOf(first));
                            sb.append(String.valueOf(last));
                        }
                    } else {
                        first = val.charAt(0);
                        last = val.charAt(val.length() - 1);
                        sb.append(String.valueOf(first));
                        sb.append(String.valueOf(last));
                    }
                    title = title.replaceAll(val.replaceAll("\\\\", "\\\\\\\\"), sb.toString());
                }
                title = title.length() > 11 ? title.replaceAll("\"", "").substring(0, 11) : title;
            } else {
                HashMap<String, ArrayList<String>> fields = new HashMap<String, ArrayList<String>>();
                p = Pattern.compile("([a-zA-Z_\\.]+):\"([a-zA-Z0-9\\s\"\\-\\.]+)\"");
                m = p.matcher(title);
                while (m.find()) {
                    for (int i = 1; i < m.groupCount(); ++i) {
                        ArrayList<String> list = (ArrayList<String>)fields.get(m.group(i));
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        list.add(m.group(i + 1));
                        fields.put(m.group(i), list);
                    }
                }
                for (String key : fields.keySet()) {
                    title = title.replaceAll(key + ":", "");
                }
                title = query;
                if (title.length() > 13) {
                    for (String key : fields.keySet()) {
                        title = title.replaceAll(key + ":", "");
                        List list = (List)fields.get(key);
                        for (String val : list) {
                            if (val.length() < 3) continue;
                            StringBuilder sb = new StringBuilder();
                            String[] words = val.split(" ");
                            if (words.length > 1) {
                                for (String word : words) {
                                    first = word.charAt(0);
                                    last = word.charAt(word.length() - 1);
                                    sb.append(String.valueOf(first));
                                    sb.append(String.valueOf(last));
                                }
                            } else {
                                p = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+");
                                m = p.matcher(val);
                                if (m.matches()) {
                                    sb.append(val);
                                } else {
                                    first = val.charAt(0);
                                    last = val.charAt(val.length() - 1);
                                    sb.append(String.valueOf(first));
                                    sb.append(String.valueOf(last));
                                }
                            }
                            title = title.replaceAll(val, sb.toString());
                        }
                    }
                }
            }
            ret = title.replaceAll("\"", "");
            if (ret.length() > 13) {
                ret = ret.substring(0, 13);
                return ret;
            }
        }
        catch (PatternSyntaxException ex) {
            ret = query;
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            return ret;
        }
    }
}

