/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import rs.co.ast.aspen.api.service.ParsingDebugInfoStep;
import rs.co.ast.aspen.gui.rawlogs.AssignmentsManager;
import rs.co.ast.aspen.gui.rawlogs.SimulationResultPanel;

public class SimulatorResultsPanel
extends JPanel {
    private AssignmentsManager assignmentsManager = (AssignmentsManager)Lookup.getDefault().lookup(AssignmentsManager.class);
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea taRawLogText;
    private JXTaskPaneContainer tpcResults;

    public SimulatorResultsPanel(String rawLogText, List<ParsingDebugInfoStep> steps) {
        this.initComponents();
        this.taRawLogText.setText(rawLogText);
        for (ParsingDebugInfoStep s : steps) {
            SimulationResultPanel rp = new SimulationResultPanel(s);
            JXTaskPane p = new JXTaskPane();
            p.setTitle(s.getRuleName() + " | " + s.getRuleId());
            p.add((Component)rp);
            p.setCollapsed(true);
            ImageIcon icon = s.isMatched() ? (s.isSilenced() ? ImageUtilities.loadImageIcon((String)"silent.png", (boolean)true) : ImageUtilities.loadImageIcon((String)"true.png", (boolean)true)) : ImageUtilities.loadImageIcon((String)"false.png", (boolean)true);
            p.setIcon((Icon)icon);
            this.tpcResults.add((Component)p);
        }
        this.assignmentsManager.reset();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.tpcResults = new JXTaskPaneContainer();
        this.jScrollPane1 = new JScrollPane();
        this.taRawLogText = new JTextArea();
        this.tpcResults.setBackground(new Color(238, 238, 238));
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setGap(14);
        this.tpcResults.setLayout((LayoutManager)verticalLayout1);
        this.jScrollPane2.setViewportView((Component)this.tpcResults);
        this.taRawLogText.setEditable(false);
        this.taRawLogText.setColumns(20);
        this.taRawLogText.setLineWrap(true);
        this.taRawLogText.setRows(3);
        this.taRawLogText.setTabSize(4);
        this.taRawLogText.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taRawLogText);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 905, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 389, Short.MAX_VALUE).addContainerGap()));
    }
}

