/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ScriptType;

public class RenameScriptPanel
extends JPanel {
    private Pattern pat = Pattern.compile("[a-zA-Z0-9_]+");
    private boolean isNewNameValid = false;
    private JLabel jLabel1;
    private JTextField tfNewScriptName;

    public RenameScriptPanel(ScriptType scriptType) {
        this.initComponents();
        if (scriptType != ScriptType.VISUALISATION_RULESET && scriptType != ScriptType.VISUALISATION_CONFIGURATION) {
            this.tfNewScriptName.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkNewName();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkNewName();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkNewName();
                }

                public void checkNewName() {
                    Matcher mat = RenameScriptPanel.this.pat.matcher(RenameScriptPanel.this.tfNewScriptName.getText());
                    RenameScriptPanel.this.isNewNameValid = mat.matches();
                    if (RenameScriptPanel.this.isNewNameValid) {
                        RenameScriptPanel.this.tfNewScriptName.setBorder(UIManager.getBorder("TextField.border"));
                    } else {
                        RenameScriptPanel.this.tfNewScriptName.setBorder(new LineBorder(Color.RED));
                    }
                    RenameScriptPanel.this.tfNewScriptName.repaint();
                }
            });
        } else {
            this.isNewNameValid = true;
        }
    }

    public String getScriptName() {
        return this.tfNewScriptName.getText();
    }

    public String getNewScriptName() {
        return this.tfNewScriptName.getText();
    }

    public void setOldScriptName(String oldName) {
        this.tfNewScriptName.setText(oldName);
        this.tfNewScriptName.selectAll();
    }

    public boolean isNewNameValid() {
        return this.isNewNameValid;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfNewScriptName = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RenameScriptPanel.class, (String)"RenameScriptPanel.jLabel1.text"));
        this.tfNewScriptName.setText(NbBundle.getMessage(RenameScriptPanel.class, (String)"RenameScriptPanel.tfNewScriptName.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfNewScriptName, -1, 244, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfNewScriptName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

