/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.opencl.Device;
import com.jme3.opencl.Platform;
import com.jme3.opencl.PlatformChooser;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DefaultPlatformChooser
implements PlatformChooser {
    private static final Logger LOG = Logger.getLogger(DefaultPlatformChooser.class.getName());

    @Override
    public List<? extends Device> chooseDevices(List<? extends Platform> platforms) {
        ArrayList<Device> result = new ArrayList<Device>();
        for (Platform platform : platforms) {
            if (!platform.hasOpenGLInterop()) continue;
            for (Device device : platform.getDevices()) {
                if (!device.hasOpenGLInterop() || device.getDeviceType() != Device.DeviceType.GPU) continue;
                result.add(device);
            }
            if (result.isEmpty()) continue;
            return result;
        }
        for (Platform platform : platforms) {
            if (!platform.hasOpenGLInterop()) continue;
            for (Device device : platform.getDevices()) {
                if (!device.hasOpenGLInterop()) continue;
                result.add(device);
            }
            if (result.isEmpty()) continue;
            return result;
        }
        LOG.warning("No device with OpenCL-OpenGL-interop found, try without");
        for (Platform platform : platforms) {
            for (Device device : platform.getDevices()) {
                result.add(device);
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return result;
    }
}

