/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;

public final class Vector3d
implements Savable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3090477054277293078L;
    private static final Logger LOGGER = Logger.getLogger(Vector3d.class.getName());
    public static final Vector3d ZERO = new Vector3d();
    public static final Vector3d UNIT_XYZ = new Vector3d(1.0, 1.0, 1.0);
    public static final Vector3d UNIT_X = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d UNIT_Y = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d UNIT_Z = new Vector3d(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(Vector3f vector3f) {
        this(vector3f.x, vector3f.y, vector3f.z);
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vector3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3d set(Vector3d vect) {
        return this.set(vect.x, vect.y, vect.z);
    }

    public Vector3d add(Vector3d vec) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector3d(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vector3d add(Vector3d vec, Vector3d result) {
        result.x = this.x + vec.x;
        result.y = this.y + vec.y;
        result.z = this.z + vec.z;
        return result;
    }

    public Vector3d addLocal(Vector3d vec) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vector3d add(double addX, double addY, double addZ) {
        return new Vector3d(this.x + addX, this.y + addY, this.z + addZ);
    }

    public Vector3d addLocal(double addX, double addY, double addZ) {
        this.x += addX;
        this.y += addY;
        this.z += addZ;
        return this;
    }

    public Vector3d scaleAdd(double scalar, Vector3d add) {
        this.x = this.x * scalar + add.x;
        this.y = this.y * scalar + add.y;
        this.z = this.z * scalar + add.z;
        return this;
    }

    public Vector3d scaleAdd(double scalar, Vector3d mult, Vector3d add) {
        this.x = mult.x * scalar + add.x;
        this.y = mult.y * scalar + add.y;
        this.z = mult.z * scalar + add.z;
        return this;
    }

    public double dot(Vector3d vec) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, 0 returned.");
            return 0.0;
        }
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vector3d cross(Vector3d v) {
        return this.cross(v, null);
    }

    public Vector3d cross(Vector3d v, Vector3d result) {
        return this.cross(v.x, v.y, v.z, result);
    }

    public Vector3d cross(double otherX, double otherY, double otherZ, Vector3d result) {
        if (result == null) {
            result = new Vector3d();
        }
        double resX = this.y * otherZ - this.z * otherY;
        double resY = this.z * otherX - this.x * otherZ;
        double resZ = this.x * otherY - this.y * otherX;
        result.set(resX, resY, resZ);
        return result;
    }

    public Vector3d crossLocal(Vector3d v) {
        return this.crossLocal(v.x, v.y, v.z);
    }

    public Vector3d crossLocal(double otherX, double otherY, double otherZ) {
        double tempx = this.y * otherZ - this.z * otherY;
        double tempy = this.z * otherX - this.x * otherZ;
        this.z = this.x * otherY - this.y * otherX;
        this.x = tempx;
        this.y = tempy;
        return this;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distanceSquared(Vector3d v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(Vector3d v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public Vector3d mult(double scalar) {
        return new Vector3d(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3d mult(double scalar, Vector3d product) {
        if (null == product) {
            product = new Vector3d();
        }
        product.x = this.x * scalar;
        product.y = this.y * scalar;
        product.z = this.z * scalar;
        return product;
    }

    public Vector3d multLocal(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3d multLocal(Vector3d vec) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public Vector3d multLocal(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3d mult(Vector3d vec) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, null returned.");
            return null;
        }
        return this.mult(vec, null);
    }

    public Vector3d mult(Vector3d vec, Vector3d store) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, null returned.");
            return null;
        }
        if (store == null) {
            store = new Vector3d();
        }
        return store.set(this.x * vec.x, this.y * vec.y, this.z * vec.z);
    }

    public Vector3d divide(double scalar) {
        scalar = 1.0 / scalar;
        return new Vector3d(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3d divideLocal(double scalar) {
        scalar = 1.0 / scalar;
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3d divide(Vector3d scalar) {
        return new Vector3d(this.x / scalar.x, this.y / scalar.y, this.z / scalar.z);
    }

    public Vector3d divideLocal(Vector3d scalar) {
        this.x /= scalar.x;
        this.y /= scalar.y;
        this.z /= scalar.z;
        return this;
    }

    public Vector3d negate() {
        return new Vector3d(-this.x, -this.y, -this.z);
    }

    public Vector3d negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3d subtract(Vector3d vec) {
        return new Vector3d(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public Vector3d subtractLocal(Vector3d vec) {
        if (null == vec) {
            LOGGER.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vector3d subtract(Vector3d vec, Vector3d result) {
        if (result == null) {
            result = new Vector3d();
        }
        result.x = this.x - vec.x;
        result.y = this.y - vec.y;
        result.z = this.z - vec.z;
        return result;
    }

    public Vector3d subtract(double subtractX, double subtractY, double subtractZ) {
        return new Vector3d(this.x - subtractX, this.y - subtractY, this.z - subtractZ);
    }

    public Vector3d subtractLocal(double subtractX, double subtractY, double subtractZ) {
        this.x -= subtractX;
        this.y -= subtractY;
        this.z -= subtractZ;
        return this;
    }

    public Vector3d normalize() {
        double length = this.x * this.x + this.y * this.y + this.z * this.z;
        if (length != 1.0 && length != 0.0) {
            length = 1.0 / Math.sqrt(length);
            return new Vector3d(this.x * length, this.y * length, this.z * length);
        }
        return this.clone();
    }

    public Vector3d normalizeLocal() {
        double length = this.x * this.x + this.y * this.y + this.z * this.z;
        if (length != 1.0 && length != 0.0) {
            length = 1.0 / Math.sqrt(length);
            this.x *= length;
            this.y *= length;
            this.z *= length;
        }
        return this;
    }

    public double angleBetween(Vector3d otherVector) {
        double dot = this.dot(otherVector);
        dot = FastMath.clamp((float)((float)dot), (float)-1.0f, (float)1.0f);
        return Math.acos(dot);
    }

    public Vector3d clone() {
        try {
            return (Vector3d)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector3d)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Vector3d comp = (Vector3d)o;
        if (Double.compare(this.x, comp.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, comp.y) != 0) {
            return false;
        }
        return Double.compare(this.z, comp.z) == 0;
    }

    public int hashCode() {
        long hash = 37L;
        hash += 37L * hash + Double.doubleToLongBits(this.x);
        hash += 37L * hash + Double.doubleToLongBits(this.y);
        hash += 37L * hash + Double.doubleToLongBits(this.z);
        return (int)hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.x, "x", 0.0);
        capsule.write(this.y, "y", 0.0);
        capsule.write(this.z, "z", 0.0);
    }

    public void read(JmeImporter e) throws IOException {
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.x = capsule.readDouble("x", 0.0);
        this.y = capsule.readDouble("y", 0.0);
        this.z = capsule.readDouble("z", 0.0);
    }
}

