/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.math.DQuaternion;
import com.jme3.scene.plugins.blender.math.DTransform;
import com.jme3.scene.plugins.blender.math.Matrix;
import com.jme3.scene.plugins.blender.math.Vector3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class ConstraintDefinitionIK
extends ConstraintDefinition {
    private static final float MIN_DISTANCE = 0.001f;
    private static final float MIN_ANGLE_CHANGE = 0.001f;
    private static final int FLAG_USE_TAIL = 1;
    private static final int FLAG_POSITION = 32;
    private BonesChain bones;
    private int bonesAffected;
    private boolean useTail;
    private int iterations;
    private int bonesCount = -1;
    private DQuaternion tempDQuaternion = new DQuaternion();
    private Vector3d col = new Vector3d();
    private Matrix deltaP = new Matrix(3, 1);
    private Vector3d target = new Vector3d();
    private Vector3d[] rotationVectors;
    private Matrix J;

    public ConstraintDefinitionIK(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        this.bonesAffected = ((Number)constraintData.getFieldValue("rootbone")).intValue();
        this.iterations = ((Number)constraintData.getFieldValue("iterations")).intValue();
        boolean bl = this.useTail = (this.flag & 1) != 0;
        if ((this.flag & 0x20) == 0) {
            this.trackToBeChanged = false;
        }
        if (this.trackToBeChanged) {
            this.alteredOmas = new HashSet();
        }
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        DTransform topBoneTransform;
        Vector3d e;
        int i;
        if (influence == 0.0f || !this.trackToBeChanged || targetTransform == null || this.bonesCount == 0) {
            return;
        }
        if (this.bones == null) {
            this.bones = new BonesChain((Bone)this.getOwner(), this.useTail, this.bonesAffected, this.alteredOmas, this.blenderContext);
        }
        if (this.bones.size() == 0) {
            this.bonesCount = 0;
            return;
        }
        double distanceFromTarget = Double.MAX_VALUE;
        this.target.set(targetTransform.getTranslation().x, targetTransform.getTranslation().y, targetTransform.getTranslation().z);
        if (this.bonesCount < 0) {
            this.bonesCount = this.bones.size();
            this.rotationVectors = new Vector3d[this.bonesCount];
            for (int i2 = 0; i2 < this.bonesCount; ++i2) {
                this.rotationVectors[i2] = new Vector3d();
            }
            this.J = new Matrix(3, this.bonesCount);
        }
        BoneContext topBone = (BoneContext)this.bones.get(0);
        for (i = 0; i < this.iterations && !((distanceFromTarget = (e = (topBoneTransform = this.bones.getWorldTransform(topBone)).getTranslation().add(topBoneTransform.getRotation().mult(Vector3d.UNIT_Y).multLocal(topBone.getLength()))).distance(this.target)) <= (double)0.001f); ++i) {
            this.deltaP.setColumn(0, 0, new double[]{this.target.x - e.x, this.target.y - e.y, this.target.z - e.z});
            int column = 0;
            for (BoneContext boneContext : this.bones) {
                DTransform boneWorldTransform = this.bones.getWorldTransform(boneContext);
                Vector3d j = boneWorldTransform.getTranslation();
                Vector3d vectorFromJointToEffector = e.subtract(j);
                vectorFromJointToEffector.cross(this.target.subtract(j), this.rotationVectors[column]).normalizeLocal();
                this.rotationVectors[column].cross(vectorFromJointToEffector, this.col);
                this.J.setColumn(this.col, column++);
            }
            Matrix J_1 = this.J.pseudoinverse();
            SimpleMatrix deltaThetas = (SimpleMatrix)J_1.mult((SimpleBase)this.deltaP);
            if (deltaThetas.elementMaxAbs() < (double)0.001f) break;
            for (int j = 0; j < deltaThetas.numRows(); ++j) {
                double angle = deltaThetas.get(j, 0);
                Vector3d rotationVector = this.rotationVectors[j];
                this.tempDQuaternion.fromAngleAxis(angle, rotationVector);
                BoneContext boneContext = (BoneContext)this.bones.get(j);
                Bone bone = boneContext.getBone();
                if (bone.equals(this.getOwner())) {
                    if (boneContext.isLockX()) {
                        this.tempDQuaternion.set(0.0, this.tempDQuaternion.getY(), this.tempDQuaternion.getZ(), this.tempDQuaternion.getW());
                    }
                    if (boneContext.isLockY()) {
                        this.tempDQuaternion.set(this.tempDQuaternion.getX(), 0.0, this.tempDQuaternion.getZ(), this.tempDQuaternion.getW());
                    }
                    if (boneContext.isLockZ()) {
                        this.tempDQuaternion.set(this.tempDQuaternion.getX(), this.tempDQuaternion.getY(), 0.0, this.tempDQuaternion.getW());
                    }
                }
                DTransform boneTransform = this.bones.getWorldTransform(boneContext);
                boneTransform.getRotation().set(this.tempDQuaternion.mult(boneTransform.getRotation()));
                this.bones.setWorldTransform(boneContext, boneTransform);
            }
        }
        for (i = this.bonesCount - 1; i >= 0; --i) {
            BoneContext boneContext = (BoneContext)this.bones.get(i);
            DTransform transform = this.bones.getWorldTransform(boneContext);
            this.constraintHelper.applyTransform(boneContext.getArmatureObjectOMA(), boneContext.getBone().getName(), ConstraintHelper.Space.CONSTRAINT_SPACE_WORLD, transform.toTransform());
        }
        this.bones = null;
    }

    @Override
    public String getConstraintTypeName() {
        return "Inverse kinematics";
    }

    @Override
    public boolean isTargetRequired() {
        return true;
    }

    private static class BonesChain
    extends ArrayList<BoneContext> {
        private static final long serialVersionUID = -1850524345643600718L;
        private List<Matrix> localBonesMatrices = new ArrayList<Matrix>();

        public BonesChain(Bone bone, boolean useTail, int bonesAffected, Collection<Long> alteredOmas, BlenderContext blenderContext) {
            if (bone != null) {
                ConstraintHelper constraintHelper = (ConstraintHelper)blenderContext.getHelper(ConstraintHelper.class);
                if (!useTail) {
                    bone = bone.getParent();
                }
                while (bone != null && (bonesAffected <= 0 || this.size() < bonesAffected)) {
                    BoneContext boneContext = blenderContext.getBoneContext(bone);
                    this.add(boneContext);
                    alteredOmas.add(boneContext.getBoneOma());
                    Transform transform = constraintHelper.getTransform(boneContext.getArmatureObjectOMA(), boneContext.getBone().getName(), ConstraintHelper.Space.CONSTRAINT_SPACE_WORLD);
                    this.localBonesMatrices.add(new DTransform(transform).toMatrix());
                    bone = bone.getParent();
                }
                if (this.localBonesMatrices.size() > 0) {
                    Matrix parentWorldMatrix = this.localBonesMatrices.get(this.localBonesMatrices.size() - 1);
                    for (int i = this.localBonesMatrices.size() - 2; i >= 0; --i) {
                        SimpleMatrix m = (SimpleMatrix)((SimpleMatrix)parentWorldMatrix.invert()).mult((SimpleBase)this.localBonesMatrices.get(i));
                        parentWorldMatrix = this.localBonesMatrices.get(i);
                        this.localBonesMatrices.set(i, new Matrix(m));
                    }
                }
            }
        }

        public DTransform getWorldTransform(BoneContext bone) {
            int index = this.indexOf(bone);
            return this.getWorldMatrix(index).toTransform();
        }

        public void setWorldTransform(BoneContext bone, DTransform transform) {
            int index = this.indexOf(bone);
            Matrix boneMatrix = transform.toMatrix();
            if (index < this.size() - 1) {
                Matrix parentWorldMatrix = this.getWorldMatrix(index + 1);
                SimpleMatrix m = (SimpleMatrix)((SimpleMatrix)parentWorldMatrix.invert()).mult((SimpleBase)boneMatrix);
                boneMatrix = new Matrix(m);
            }
            this.localBonesMatrices.set(index, boneMatrix);
        }

        public Matrix getWorldMatrix(int index) {
            if (index == this.size() - 1) {
                return new Matrix(this.localBonesMatrices.get(this.size() - 1));
            }
            Matrix result = this.getWorldMatrix(index + 1);
            result = (SimpleMatrix)result.mult((SimpleBase)this.localBonesMatrices.get(index));
            return new Matrix(result);
        }
    }
}

