/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.IOException;

public class FlacFormatException
extends IOException {
    private ByteArrayBitInputStream source;

    public FlacFormatException() {
    }

    public FlacFormatException(String message) {
        super(message);
    }

    public FlacFormatException(String message, ByteArrayBitInputStream source) {
        super(message);
        this.source = source;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.source != null) {
            int i = 0;
            while (i < this.source.getSource().length) {
                int lineEnd = i + 8;
                while (i < lineEnd && i < this.source.getSource().length) {
                    String val = Integer.toBinaryString(this.source.getSource()[i] & 0xFF);
                    while (val.length() < 8) {
                        val = "0" + val;
                    }
                    System.err.print(val + " ");
                    ++i;
                }
                System.err.println("");
            }
        }
    }
}

