/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleSetDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.HasId;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupsChildFactory;

public class RuleSetNode
extends AbstractNode
implements PropertyChangeListener,
NodeListener,
HasId {
    private final RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final ParsingRuleSetDTOWrapper prs;

    public RuleSetNode(ParsingRuleSetDTOWrapper prs) {
        super(Children.create((ChildFactory)new RulesGroupsChildFactory(prs.getId()), (boolean)true), Lookups.singleton((Object)prs));
        this.setDisplayName(prs.getName());
        this.setIconBaseWithExtension("book.png");
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.prs = prs;
        this.prs.addPropertyChangeListener((PropertyChangeListener)this);
        this.addNodeListener(this);
        this.addPropertyChangeListener(this);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return this.model.isEditMode();
    }

    public boolean canRename() {
        return this.model.isEditMode();
    }

    public void childrenAdded(NodeMemberEvent nme) {
    }

    public void childrenRemoved(NodeMemberEvent nme) {
    }

    public void childrenReordered(NodeReorderEvent nre) {
    }

    public void destroy() throws IOException {
        this.fireNodeDestroyed();
    }

    public Action[] getActions(boolean context) {
        if (this.model.isEditMode()) {
            return new Action[]{(Action)Utilities.actionsForPath((String)"Actions/RightClickRuleSet").get(0), (Action)Utilities.actionsForPath((String)"Actions/RightClickRuleSet").get(1), (Action)Utilities.actionsForPath((String)"Actions/RightClickRuleSet").get(2), (Action)Utilities.actionsForPath((String)"Actions/RightClickRuleSet").get(3), (Action)Utilities.actionsForPath((String)"Actions/EditMode").get(0)};
        }
        return new Action[]{(Action)Utilities.actionsForPath((String)"Actions/EditMode").get(0)};
    }

    public String getHtmlDisplayName() {
        String name = this.prs.getName();
        if (this.prs.isDirty()) {
            return "<html><strong>" + name + "</strong> " + this.prs.getId() + "</html>";
        }
        if (this.prs.isForDelete()) {
            return "<html><strong><strike>" + name + "</strike></strong></html>";
        }
        return name + " - " + this.prs.getId();
    }

    @Override
    public String getId() {
        return this.prs.getId();
    }

    public ParsingRuleSetDTOWrapper getRuleSet() {
        return this.prs;
    }

    public void nodeDestroyed(NodeEvent ne) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String newValue;
        if (evt.getPropertyName().equals("name") && (newValue = (String)evt.getNewValue()) != null) {
            this.setDisplayName(newValue);
            this.model.setRuleSetName(this.prs, newValue);
        }
    }

    public void updateChildren(ParsingRuleSetDTOWrapper ruleset) {
        this.setChildren(Children.create((ChildFactory)new RulesGroupsChildFactory(ruleset.getId()), (boolean)true));
    }

    public void updateChildren(String groupParentId) {
        this.setChildren(Children.create((ChildFactory)new RulesGroupsChildFactory(groupParentId), (boolean)true));
    }
}

