/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.export;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptionsPanel;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.CountTasksCompletedSupport;
import rs.co.ast.aspen.gui.module.securityevents.export.listeners.WorkFinishedSupport;

public class TaskMonitor {
    private WorkFinishedSupport workFinishedSupport;
    private CountTasksCompletedSupport countTasksCompletedSupport;
    private Map<String, Boolean> fetchTasksMonitor = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> skippedFetchTasksMonitor = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> countTasksMonitor = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Boolean> skippedCountTasksMonitor = new ConcurrentHashMap<String, Boolean>();

    public TaskMonitor(WorkFinishedSupport workFinishedSupport, CountTasksCompletedSupport countTasksCompletedSupport) {
        this.workFinishedSupport = workFinishedSupport;
        this.countTasksCompletedSupport = countTasksCompletedSupport;
    }

    public void addFetch(String fileName) {
        this.fetchTasksMonitor.put(fileName, false);
    }

    public void addSkippedFetch(String fileName) {
        this.skippedFetchTasksMonitor.put(fileName, false);
    }

    public void completeFetch(String fileName) {
        this.fetchTasksMonitor.put(fileName, true);
        if (this.skippedFetchTasksMonitor.containsKey(fileName)) {
            this.skippedFetchTasksMonitor.put(fileName, true);
        }
        this.checkAllFilesCreated();
    }

    public void checkAllFilesCreated() {
        for (boolean completed : this.fetchTasksMonitor.values()) {
            if (completed) continue;
            return;
        }
        for (boolean completed : this.skippedFetchTasksMonitor.values()) {
            if (completed) continue;
            return;
        }
        this.workFinishedSupport.fireWorkFinishedEvent(true, NbBundle.getMessage(DisplayOptionsPanel.class, (String)"DisplayOptionsPanel.export.success.message"));
    }

    public int countFilesDone() {
        int count = 0;
        for (boolean completed : this.fetchTasksMonitor.values()) {
            if (!completed) continue;
            ++count;
        }
        return count;
    }

    public void addCount(DateRange dateRange) {
        this.countTasksMonitor.put(this.dateRangeToString(dateRange), false);
    }

    public void addSkippedCount(DateRange dateRange) {
        this.skippedCountTasksMonitor.put(this.dateRangeToString(dateRange), false);
    }

    public void completeCount(DateRange dateRange) {
        String dateRangeToString = this.dateRangeToString(dateRange);
        this.countTasksMonitor.put(dateRangeToString, true);
        if (this.skippedCountTasksMonitor.containsKey(dateRangeToString)) {
            this.skippedCountTasksMonitor.put(dateRangeToString, true);
        }
        this.checkAllCountsCompleted();
    }

    public void checkAllCountsCompleted() {
        for (boolean completed : this.countTasksMonitor.values()) {
            if (completed) continue;
            return;
        }
        for (boolean completed : this.skippedCountTasksMonitor.values()) {
            if (completed) continue;
            return;
        }
        this.countTasksCompletedSupport.fireCountTasksCompletedEvent(true);
    }

    public String dateRangeToString(DateRange dateRange) {
        return String.format("%s-%s", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()));
    }
}

