/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.linsol.chol;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockTriangularSolver;
import org.ejml.alg.block.decomposition.chol.CholeskyOuterForm_B64;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.SpecializedOps;

public class BlockCholeskyOuterSolver
implements LinearSolver<BlockMatrix64F> {
    private CholeskyOuterForm_B64 decomposer = new CholeskyOuterForm_B64(true);
    private int blockLength;
    private double[] temp;

    public boolean setA(BlockMatrix64F A) {
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.blockLength = A.blockLength;
        return true;
    }

    public double quality() {
        return SpecializedOps.qualityTriangular((D1Matrix64F)this.decomposer.getT((BlockMatrix64F)null));
    }

    public void solve(BlockMatrix64F B, BlockMatrix64F X) {
        if (B.blockLength != this.blockLength) {
            throw new IllegalArgumentException("Unexpected blocklength in B.");
        }
        D1Submatrix64F L = new D1Submatrix64F((D1Matrix64F)this.decomposer.getT((BlockMatrix64F)null));
        if (X != null) {
            if (X.blockLength != this.blockLength) {
                throw new IllegalArgumentException("Unexpected blocklength in X.");
            }
            if (X.numRows != L.col1) {
                throw new IllegalArgumentException("Not enough rows in X");
            }
        }
        if (B.numRows != L.col1) {
            throw new IllegalArgumentException("Not enough rows in B");
        }
        BlockTriangularSolver.solve(this.blockLength, false, L, new D1Submatrix64F((D1Matrix64F)B), false);
        BlockTriangularSolver.solve(this.blockLength, false, L, new D1Submatrix64F((D1Matrix64F)B), true);
        if (X != null) {
            BlockMatrixOps.extractAligned(B, X);
        }
    }

    public void invert(BlockMatrix64F A_inv) {
        BlockMatrix64F T = this.decomposer.getT((BlockMatrix64F)null);
        if (A_inv.numRows != T.numRows || A_inv.numCols != T.numCols) {
            throw new IllegalArgumentException("Unexpected number or rows and/or columns");
        }
        if (this.temp == null || this.temp.length < this.blockLength * this.blockLength) {
            this.temp = new double[this.blockLength * this.blockLength];
        }
        BlockMatrixOps.zeroTriangle(true, A_inv);
        D1Submatrix64F L = new D1Submatrix64F((D1Matrix64F)T);
        D1Submatrix64F B = new D1Submatrix64F((D1Matrix64F)A_inv);
        BlockTriangularSolver.invert(this.blockLength, false, L, B, this.temp);
        BlockTriangularSolver.solveL(this.blockLength, L, B, true);
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return true;
    }

    public CholeskyDecomposition<BlockMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

