/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.sourcestatistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.Pair;

public class OverviewTableModel
extends DefaultTableModel {
    private final List<String> columns = Stream.of(NbBundle.getMessage(OverviewTableModel.class, (String)"OverviewTableModel.columnName.key"), NbBundle.getMessage(OverviewTableModel.class, (String)"OverviewTableModel.columnName.value")).collect(Collectors.toList());
    private List<Pair> data = new ArrayList<Pair>();
    private final NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());

    @Override
    public Object getValueAt(int row, int column) {
        Pair element = this.data.get(row);
        switch (column) {
            case 0: {
                return element.getKey();
            }
            case 1: {
                try {
                    return this.nf.format(Integer.parseInt(element.getValue()));
                }
                catch (NumberFormatException e) {
                    return element.getValue();
                }
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage(OverviewTableModel.class, (String)"TableModel.columnName.unknown"));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public void update(List<Pair> data) {
        this.data = data;
        this.fireTableDataChanged();
    }
}

