/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.swing.etable.ETableColumn;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.gui.module.datamaps.DataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.DatamapEvent;
import rs.co.ast.aspen.gui.module.datamaps.DatamapEventListener;
import rs.co.ast.aspen.gui.module.datamaps.DatamapsDrawingHelper;
import rs.co.ast.aspen.gui.module.datamaps.SortValueByKeyPanel;
import rs.co.ast.aspen.gui.module.datamaps.TableColumnResizer;
import rs.co.ast.aspen.gui.module.datamaps.TableTransferHandler;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapModel;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapResultsTableModel;
import rs.co.ast.aspen.gui.module.datamaps.model.DataMapTableModel;
import rs.co.ast.aspen.gui.module.datamaps.model.DeletedDataMapsModel;
import rs.co.ast.aspen.gui.module.datamaps.model.InMemoryDatabase;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapChildFactory;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapKeyNode;
import rs.co.ast.aspen.gui.module.datamaps.nodes.DataMapNode;
import rs.co.ast.aspen.gui.module.datamaps.nodes.RootNode;

@TopComponent.Description(preferredID="DataMapsTopComponent", iconBase="datamap.png", persistenceType=0)
public final class DataMapsTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static final Logger LOGGER = Logger.getLogger(DataMapsTopComponent.class.getName());
    private static final DateTimeFormatter DTF = ISODateTimeFormat.basicDateTime();
    private static final String DEFAULT_FORMAT_OPTIONS = "";
    private final DataMapModel model = (DataMapModel)Lookup.getDefault().lookup(DataMapModel.class);
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private final Lookup.Result<DataMapKey> dmklr = Utilities.actionsGlobalContext().lookupResult(DataMapKey.class);
    private final Lookup.Result<DataMapName> dmnlr = Utilities.actionsGlobalContext().lookupResult(DataMapName.class);
    private final ScriptEngineManager sem = new ScriptEngineManager();
    private DeletedDataMapsModel deletedDataMapsModel = (DeletedDataMapsModel)Lookup.getDefault().lookup(DeletedDataMapsModel.class);
    private ScriptEngine se;
    private boolean seInit = false;
    private String selectedMapName;
    private String selectedMapKey;
    private static OutlineView outlineView = new OutlineView(NbBundle.getMessage(DataMapsTopComponent.class, (String)"rootnode.title"));
    private RSyntaxTextArea eValue;
    private Map<String, HashMap<String, Object>> valueMap = new HashMap<String, HashMap<String, Object>>();
    private ObjectMapper mapper = new ObjectMapper();
    private List innerValueMapKeys = new ArrayList();
    private Map<String, Integer> datamapLoadingKeys = new HashMap<String, Integer>();
    private DataMapKey dmk = null;
    DatamapsDrawingHelper dmdh;
    private DataMapTableModel tableModel = (DataMapTableModel)Lookup.getDefault().lookup(DataMapTableModel.class);
    private DataMapResultsTableModel tableResultModel = (DataMapResultsTableModel)Lookup.getDefault().lookup(DataMapResultsTableModel.class);
    private InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);
    private final Collection<? extends Action> sqlFunctions = Lookups.forPath((String)"SQLFunctionsDataMapPopupMenu/SQLFunctionsDataMap").lookupAll(Action.class);
    private String regexKey = "";
    private JButton bFilter;
    private JButton bLagend;
    private JButton bRefresh;
    private JButton bReset;
    private JButton bSave;
    private JButton bSortValue;
    private JCheckBox cbNOT;
    private JCheckBox cbShowContent;
    private JPanel cp;
    private JPanel cpText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JXCollapsiblePane jXCollapsiblePane;
    private JPanel pFiltered;
    private JPanel pTable;
    private JPopupMenu pmFunctions;
    private JScrollPane spDataMapTable;
    private JScrollPane spFilteredDataMapTable;
    private JTable tDataMapTable;
    private JTable tResultsDataMapTable;
    private JTextField tfLastUpdated;
    private JTextField tfRegex;
    private JTextField tfSearch;
    private JTextField tfTableFilter;
    private final NodeAdapter dataMapNodeListener = new NodeAdapter(){

        public void childrenAdded(NodeMemberEvent ev) {
            if (DataMapsTopComponent.this.selectedMapName != null) {
                for (Node n : ev.getNode().getChildren().getNodes()) {
                    if (!(n instanceof DataMapNode) || !n.getDisplayName().equals(DataMapsTopComponent.this.selectedMapName)) continue;
                    LOGGER.log(Level.FINE, "Found DataMapNode {0}, expanding and adding node listener", n.getDisplayName());
                    n.removeNodeListener((NodeListener)DataMapsTopComponent.this.dataMapKeyNodeListener);
                    n.addNodeListener((NodeListener)DataMapsTopComponent.this.dataMapKeyNodeListener);
                    SwingUtilities.invokeLater(() -> outlineView.expandNode(n));
                    break;
                }
            }
        }
    };
    private NodeAdapter dataMapKeyNodeListener = new NodeAdapter(){

        public void childrenAdded(NodeMemberEvent ev) {
            if (DataMapsTopComponent.this.selectedMapKey != null) {
                for (Node n : ev.getNode().getChildren().getNodes()) {
                    if (!(n instanceof DataMapKeyNode) || !n.getDisplayName().equals(DataMapsTopComponent.this.selectedMapKey)) continue;
                    LOGGER.log(Level.FINE, "Found DataMapKeyNode {0}, selecting", n.getDisplayName());
                    SwingUtilities.invokeLater(() -> {
                        try {
                            DataMapsTopComponent.this.explorerManager.setSelectedNodes(new Node[]{n});
                        }
                        catch (PropertyVetoException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    });
                }
            }
        }
    };

    public DataMapsTopComponent() {
        this.dmdh = DatamapsDrawingHelper.getInstance();
        LOGGER.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.DATAMAPS), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.DATAMAPS)));
        this.initComponents();
        this.setName(NbBundle.getMessage(DataMapsTopComponent.class, (String)"CTL_DataMapsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DataMapsTopComponent.class, (String)"HINT_DataMapsTopComponent"));
        outlineView.setPropertyColumns(new String[0]);
        this.jXCollapsiblePane.setLayout((LayoutManager)new BorderLayout());
        this.jXCollapsiblePane.add((Component)this.jPanel1, (Object)"Center");
        this.bLagend.addActionListener(this.jXCollapsiblePane.getActionMap().get("toggle"));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()));
        this.eValue = new RSyntaxTextArea(20, 60);
        this.eValue.setSyntaxEditingStyle("text/json");
        this.eValue.setTabSize(4);
        this.eValue.setCodeFoldingEnabled(true);
        this.eValue.setEnabled(false);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.eValue);
        this.cpText.add((Component)sp);
        for (Action action : this.sqlFunctions) {
            this.pmFunctions.add(action);
        }
        this.tDataMapTable.setAutoResizeMode(0);
        this.tDataMapTable.setModel(this.tableModel);
        this.tDataMapTable.setAutoCreateRowSorter(true);
        this.tDataMapTable.setCellSelectionEnabled(true);
        this.tDataMapTable.setSelectionMode(1);
        this.tDataMapTable.setCellSelectionEnabled(true);
        this.tDataMapTable.setTransferHandler(new TableTransferHandler());
        this.tDataMapTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = DataMapsTopComponent.this.tDataMapTable.rowAtPoint(e.getPoint());
                    int column = DataMapsTopComponent.this.tDataMapTable.columnAtPoint(e.getPoint());
                    if (row > -1 && column > -1) {
                        DataMapsTopComponent.this.tDataMapTable.setRowSelectionInterval(row, row);
                        DataMapsTopComponent.this.tDataMapTable.setColumnSelectionInterval(column, column);
                    }
                    DataMapsTopComponent.this.tDataMapTable.changeSelection(row, column, false, false);
                    DataMapsTopComponent.this.pmFunctions.show(e.getComponent(), e.getX(), e.getY());
                    DataMapsTopComponent.this.tableModel.setNewlyAddedColumn(DataMapsTopComponent.this.tableModel.getColumn(column));
                } else {
                    int selectedRow = DataMapsTopComponent.this.tDataMapTable.getSelectedRow();
                    int selectedColumn = DataMapsTopComponent.this.tDataMapTable.getSelectedColumn();
                    if (selectedRow > -1 && selectedColumn > -1) {
                        DataMapsTopComponent.this.tableModel.setNewlyAddedColumn(DataMapsTopComponent.this.tableModel.getColumn(selectedColumn));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tResultsDataMapTable.setAutoResizeMode(0);
        this.tResultsDataMapTable.setModel(this.tableResultModel);
        this.tResultsDataMapTable.setCellSelectionEnabled(true);
        this.tResultsDataMapTable.setAutoCreateRowSorter(true);
        this.tResultsDataMapTable.setSelectionMode(1);
        this.tResultsDataMapTable.setTransferHandler(new TableTransferHandler());
        this.tResultsDataMapTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (DataMapsTopComponent.this.tableResultModel.getColumnCount() > 0) {
                    TableRowSorter rowSorter = (TableRowSorter)DataMapsTopComponent.this.tResultsDataMapTable.getRowSorter();
                    ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
                    RowSorter.SortKey sortKey = new RowSorter.SortKey(0, SortOrder.DESCENDING);
                    keys.add(sortKey);
                    rowSorter.setSortKeys(keys);
                    rowSorter.sort();
                    rowSorter.setSortsOnUpdates(true);
                    TableColumnResizer.adjustColumnPreferredWidths(DataMapsTopComponent.this.tResultsDataMapTable);
                }
            }
        });
        this.cbShowContent.setSelected(!this.model.isSelectionMode());
        this.dmklr.allInstances();
        this.dmklr.addLookupListener(ev -> {
            if (!this.model.isSelectionMode()) {
                Lookup.Result lr = (Lookup.Result)ev.getSource();
                Collection instances = lr.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof DataMapKey)) continue;
                    this.dmk = (DataMapKey)o;
                    this.selectedMapName = this.dmk.getDmv().getMap();
                    this.selectedMapKey = this.dmk.getDmv().getKey();
                    if (this.dmk.getDmv().getKey().startsWith("~ Limit of")) {
                        Node[] nodes;
                        for (Node n : nodes = this.explorerManager.getRootContext().getChildren().getNodes()) {
                            Integer get;
                            DataMapNode dmn = (DataMapNode)n;
                            if (!dmn.getDataMapName().getName().equalsIgnoreCase(this.selectedMapName)) continue;
                            this.selectedMapKey = DEFAULT_FORMAT_OPTIONS;
                            Integer n2 = get = this.datamapLoadingKeys.get(dmn.getDataMapName().getName());
                            Integer n3 = get = Integer.valueOf(get + 1);
                            this.datamapLoadingKeys.replace(dmn.getDataMapName().getName(), get);
                            this.dmdh.setMap(this.datamapLoadingKeys);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"refreshing-datamaps.message"));
                                    ph.start();
                                    ph.switchToIndeterminate();
                                    RootNode node = new RootNode(Children.create((ChildFactory)new DataMapChildFactory(DataMapsTopComponent.DEFAULT_FORMAT_OPTIONS), (boolean)true));
                                    node.addNodeListener((NodeListener)DataMapsTopComponent.this.dataMapNodeListener);
                                    DataMapsTopComponent.this.explorerManager.setRootContext((Node)node);
                                    ph.finish();
                                }
                            });
                            break;
                        }
                    } else if (this.dmk.getValue() != null) {
                        this.eValue.setText(this.formatJS(this.dmk.getValue(), DEFAULT_FORMAT_OPTIONS));
                        this.eValue.setCaretPosition(0);
                        this.getValueMap(this.dmk.getValue());
                        this.memDB.dispose();
                        this.tableModel.resetData();
                        this.tableResultModel.resetData();
                        this.memDB.initDB(this.valueMap);
                    }
                    this.tfLastUpdated.setText(DTF.print(this.dmk.getDmv().getLastUpdated()));
                }
            }
        });
        this.dmnlr.allInstances();
        this.dmnlr.addLookupListener(ev -> {
            Lookup.Result lr = (Lookup.Result)ev.getSource();
            Collection instances = lr.allInstances();
            for (Object o : instances) {
                if (!(o instanceof DataMapName)) continue;
                this.selectedMapKey = null;
                this.selectedMapName = null;
                this.eValue.setText(DEFAULT_FORMAT_OPTIONS);
                this.eValue.setEnabled(false);
                this.tfLastUpdated.setText(DEFAULT_FORMAT_OPTIONS);
                this.bSortValue.setEnabled(false);
                this.memDB.dispose();
                this.tableModel.resetData();
                this.tableResultModel.resetData();
            }
        });
        final String searchText = NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.tfSearch.text");
        this.tfSearch.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DataMapsTopComponent.this.tfSearch.getText().equals(searchText)) {
                    DataMapsTopComponent.this.tfSearch.setText(DataMapsTopComponent.DEFAULT_FORMAT_OPTIONS);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DataMapsTopComponent.this.tfSearch.getText().isEmpty()) {
                    DataMapsTopComponent.this.tfSearch.setText(searchText);
                }
            }
        });
        JPopupMenu jPopupMenu = this.eValue.getPopupMenu();
        JMenuItem toggleEditMode = new JMenuItem(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jmenu.toggleEditMode"));
        jPopupMenu.add(toggleEditMode);
        toggleEditMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataMapsTopComponent.this.toggleEditMode();
            }
        });
        this.model.addScriptUpdatedEventListener(new DatamapEventListener(){

            @Override
            public void onToggleSelectionMode(DatamapEvent event) {
                DataMapsTopComponent.this.cbShowContent.setSelected(!DataMapsTopComponent.this.model.isSelectionMode());
                if (DataMapsTopComponent.this.model.isSelectionMode()) {
                    DataMapsTopComponent.this.eValue.setText(DataMapsTopComponent.DEFAULT_FORMAT_OPTIONS);
                    DataMapsTopComponent.this.tableModel.resetData();
                }
                if (DataMapsTopComponent.this.dmk != null && !DataMapsTopComponent.this.model.isSelectionMode()) {
                    if (DataMapsTopComponent.this.dmk.getValue() != null) {
                        DataMapsTopComponent.this.eValue.setText(DataMapsTopComponent.this.formatJS(DataMapsTopComponent.this.dmk.getValue(), DataMapsTopComponent.DEFAULT_FORMAT_OPTIONS));
                        DataMapsTopComponent.this.eValue.setCaretPosition(0);
                        DataMapsTopComponent.this.getValueMap(DataMapsTopComponent.this.dmk.getValue());
                        DataMapsTopComponent.this.tableModel.resetData();
                        DataMapsTopComponent.this.tableResultModel.resetData();
                        DataMapsTopComponent.this.memDB.dispose();
                        DataMapsTopComponent.this.memDB.initDB(DataMapsTopComponent.this.valueMap);
                    }
                } else {
                    DataMapsTopComponent.this.dmk = null;
                    DataMapsTopComponent.this.eValue.setText(DataMapsTopComponent.DEFAULT_FORMAT_OPTIONS);
                    DataMapsTopComponent.this.eValue.setCaretPosition(0);
                    DataMapsTopComponent.this.tfLastUpdated.setText(DataMapsTopComponent.DEFAULT_FORMAT_OPTIONS);
                    DataMapsTopComponent.this.tableModel.resetData();
                    DataMapsTopComponent.this.tableResultModel.resetData();
                    DataMapsTopComponent.this.memDB.dispose();
                }
            }
        });
        this.tfTableFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            public void filter() {
                if (DataMapsTopComponent.this.tDataMapTable.getColumnCount() != 0) {
                    DataMapsTopComponent.this.memDB.filter(DataMapsTopComponent.this.tfTableFilter.getText(), DataMapsTopComponent.this.cbNOT.isSelected());
                }
            }
        });
        this.cbNOT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataMapsTopComponent.this.tDataMapTable.getColumnCount() != 0 && !DataMapsTopComponent.this.tfTableFilter.getText().isEmpty()) {
                    DataMapsTopComponent.this.memDB.filter(DataMapsTopComponent.this.tfTableFilter.getText(), DataMapsTopComponent.this.cbNOT.isSelected());
                }
            }
        });
        this.tfRegex.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeButtonColor();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeButtonColor();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeButtonColor();
            }

            private void changeButtonColor() {
                if (DataMapsTopComponent.this.regexKey.equals(DataMapsTopComponent.this.tfRegex.getText())) {
                    DataMapsTopComponent.this.bFilter.setForeground(Color.black);
                } else {
                    DataMapsTopComponent.this.bFilter.setForeground(Color.red);
                }
            }
        });
        this.tfRegex.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && !DataMapsTopComponent.this.regexKey.equals(DataMapsTopComponent.this.tfRegex.getText())) {
                    DataMapsTopComponent.this.displayData();
                    DataMapsTopComponent.this.regexKey = DataMapsTopComponent.this.tfRegex.getText();
                    DataMapsTopComponent.this.bFilter.setForeground(Color.black);
                }
            }
        });
    }

    public void toggleEditMode() {
        this.eValue.setEnabled(!this.eValue.isEnabled());
        this.bSave.setEnabled(!this.bSave.isEnabled());
        this.bReset.setEnabled(!this.bReset.isEnabled());
    }

    public static void sortByDate() {
        ETableColumn column = (ETableColumn)outlineView.getOutline().getColumnModel().getColumn(0);
        column.setNestedComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof DataMapKeyNode && o2 instanceof DataMapKeyNode) {
                    return ((DataMapKeyNode)o1).compareTo((DataMapKeyNode)o2);
                }
                if (o1 instanceof DataMapNode && o2 instanceof DataMapNode) {
                    return ((DataMapNode)o1).compareTo((DataMapNode)o2);
                }
                return 0;
            }
        });
        outlineView.getOutline().setColumnSorted(0, true, 1);
    }

    public static void defaultSort() {
        ETableColumn column = (ETableColumn)outlineView.getOutline().getColumnModel().getColumn(0);
        column.setNestedComparator(null);
        outlineView.getOutline().setColumnSorted(0, true, 1);
    }

    private Invocable getScriptEngine() {
        Invocable r = null;
        if (this.se == null) {
            this.se = this.sem.getEngineByName("JavaScript");
            r = this.getScriptEngine();
        } else if (this.seInit) {
            r = (Invocable)((Object)this.se);
        } else {
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/jsbeautifier.js"));
            try {
                this.se.eval(reader);
                this.seInit = true;
                r = (Invocable)((Object)this.se);
            }
            catch (ScriptException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        return r;
    }

    private void getValueMap(String text) {
        if (text != null) {
            this.valueMap.clear();
            try {
                this.valueMap = (Map)this.mapper.readValue(text, HashMap.class);
            }
            catch (IOException ex) {
                this.bSortValue.setEnabled(false);
            }
            Object obj = null;
            if (this.valueMap.values().toArray().length != 0) {
                obj = this.valueMap.values().toArray()[0];
            }
            if (obj != null && obj instanceof HashMap) {
                HashMap map = (HashMap)obj;
                if (map.isEmpty()) {
                    this.bSortValue.setEnabled(false);
                } else {
                    this.innerValueMapKeys.clear();
                    this.innerValueMapKeys.add("map name");
                    this.innerValueMapKeys.addAll(map.keySet());
                    this.bSortValue.setEnabled(true);
                }
            } else {
                this.bSortValue.setEnabled(false);
            }
        }
    }

    public void sortValueByKey(String key, boolean desc) {
        HashMap hashMapValue = (HashMap)this.valueMap.values().toArray()[0];
        Object hashMapKeyValue = hashMapValue.get(key);
        Map<Object, Object> sortedMap = key.equals("map name") ? (LinkedHashMap)this.valueMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)) : (hashMapKeyValue instanceof Integer ? (Map)this.valueMap.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)((HashMap)e1.getValue()).get(key), (Integer)((HashMap)e2.getValue()).get(key))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)) : (Map)this.valueMap.entrySet().stream().sorted((e1, e2) -> String.valueOf(((HashMap)e1.getValue()).get(key)).compareTo(String.valueOf(((HashMap)e2.getValue()).get(key)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
        if (desc) {
            sortedMap = this.reverseMap(sortedMap);
        }
        try {
            this.eValue.setText(this.formatJS(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(sortedMap), DEFAULT_FORMAT_OPTIONS));
        }
        catch (JsonProcessingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private <T, Q> LinkedHashMap<T, Q> reverseMap(Map<T, Q> toReverse) {
        LinkedHashMap reversedMap = new LinkedHashMap();
        ArrayList<Object> reverseOrderedKeys = new ArrayList<Object>(toReverse.keySet());
        Collections.reverse(reverseOrderedKeys);
        reverseOrderedKeys.forEach(key -> reversedMap.put(key, toReverse.get(key)));
        return reversedMap;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.pmFunctions = new JPopupMenu();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.tfLastUpdated = new JTextField();
        this.bRefresh = new JButton();
        this.cbShowContent = new JCheckBox();
        this.jTabbedPane1 = new JTabbedPane();
        this.cp = new JPanel();
        this.jPanel5 = new JPanel();
        this.bSave = new JButton();
        this.bReset = new JButton();
        this.tfSearch = new JTextField();
        this.bSortValue = new JButton();
        this.cpText = new JPanel();
        this.pTable = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.spDataMapTable = new JScrollPane();
        this.tDataMapTable = new JTable();
        this.tfTableFilter = new JTextField();
        this.cbNOT = new JCheckBox();
        this.pFiltered = new JPanel();
        this.jLabel9 = new JLabel();
        this.spFilteredDataMapTable = new JScrollPane();
        this.tResultsDataMapTable = new JTable();
        this.jPanel6 = new JPanel();
        this.jPanel3 = new JPanel();
        this.bLagend = new JButton();
        this.jScrollPane2 = outlineView;
        this.jXCollapsiblePane = new JXCollapsiblePane();
        this.jPanel7 = new JPanel();
        this.bFilter = new JButton();
        this.tfRegex = new JTextField();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jPanel1.border.title")));
        this.jPanel1.setMaximumSize(new Dimension(Short.MAX_VALUE, 70));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(190, 70));
        this.jLabel1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/textfield1.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel1.text"));
        this.jLabel3.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/textfield2.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel3.text"));
        this.jLabel4.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/textfield3.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel4.text"));
        this.jLabel5.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/textfield4.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel5.text"));
        this.jLabel6.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/textfield5.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel6.text"));
        this.jLabel7.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/textfield6.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel7.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 0, 0).addComponent(this.jLabel6).addGap(0, 0, 0).addComponent(this.jLabel7)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, 0).addComponent(this.jLabel3).addGap(0, 0, 0).addComponent(this.jLabel4)));
        this.jSplitPane1.setDividerLocation(220);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel2.text"));
        this.tfLastUpdated.setEditable(false);
        this.tfLastUpdated.setText(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.tfLastUpdated.text"));
        this.tfLastUpdated.setMinimumSize(new Dimension(4, 230));
        this.bRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/arrow_refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.bRefresh.text"));
        this.bRefresh.setDefaultCapable(false);
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.bRefreshActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowContent, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.cbShowContent.text"));
        this.cbShowContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.cbShowContentActionPerformed(evt);
            }
        });
        this.cp.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.bSave, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.bSave.text"));
        this.bSave.setEnabled(false);
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.bSaveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.bReset.text"));
        this.bReset.setDefaultCapable(false);
        this.bReset.setEnabled(false);
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.bResetActionPerformed(evt);
            }
        });
        this.tfSearch.setText(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bSortValue, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.bSortValue.text"));
        this.bSortValue.setEnabled(false);
        this.bSortValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.bSortValueActionPerformed(evt);
            }
        });
        this.cpText.setLayout(new BorderLayout());
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cpText, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.tfSearch, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSortValue, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSave).addContainerGap()))));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.bSortValue).addComponent(this.bSave).addComponent(this.bReset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cpText, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.cp.add((Component)this.jPanel5, "Center");
        this.jTabbedPane1.addTab(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.cp.TabConstraints.tabTitle"), this.cp);
        this.jSplitPane2.setDividerLocation(400);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.8);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel8.text"));
        this.tDataMapTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.spDataMapTable.setViewportView(this.tDataMapTable);
        this.tfTableFilter.setText(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.tfTableFilter.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbNOT, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.cbNOT.text"));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfTableFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNOT)).addComponent(this.spDataMapTable, -1, 612, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfTableFilter, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.cbNOT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spDataMapTable, -1, 357, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setTopComponent(this.jPanel4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.jLabel9.text"));
        this.tResultsDataMapTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.spFilteredDataMapTable.setViewportView(this.tResultsDataMapTable);
        GroupLayout pFilteredLayout = new GroupLayout(this.pFiltered);
        this.pFiltered.setLayout(pFilteredLayout);
        pFilteredLayout.setHorizontalGroup(pFilteredLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pFilteredLayout.createSequentialGroup().addContainerGap().addGroup(pFilteredLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spFilteredDataMapTable, -1, 618, Short.MAX_VALUE).addGroup(pFilteredLayout.createSequentialGroup().addComponent(this.jLabel9).addContainerGap(-1, Short.MAX_VALUE)))));
        pFilteredLayout.setVerticalGroup(pFilteredLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pFilteredLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spFilteredDataMapTable, -1, 199, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setRightComponent(this.pFiltered);
        GroupLayout pTableLayout = new GroupLayout(this.pTable);
        this.pTable.setLayout(pTableLayout);
        pTableLayout.setHorizontalGroup(pTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, GroupLayout.Alignment.TRAILING));
        pTableLayout.setVerticalGroup(pTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, GroupLayout.Alignment.TRAILING, -1, 655, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.pTable.TabConstraints.tabTitle"), this.pTable);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLastUpdated, -2, 203, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bRefresh, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cbShowContent))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.cbShowContent)).addGroup(jPanel2Layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.bRefresh, -2, 30, -2)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfLastUpdated, -2, -1, -2).addComponent(this.jLabel2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jPanel6.setPreferredSize(new Dimension(150, 744));
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.bLagend, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.bLagend.text"));
        this.jPanel3.add((Component)this.bLagend, "Last");
        this.jPanel3.add((Component)this.jScrollPane2, "Center");
        this.jXCollapsiblePane.setCollapsed(true);
        this.jPanel3.add((Component)this.jXCollapsiblePane, "First");
        this.jPanel6.add((Component)this.jPanel3, "Center");
        Mnemonics.setLocalizedText((AbstractButton)this.bFilter, (String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.bFilter.text"));
        this.bFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataMapsTopComponent.this.bFilterActionPerformed(evt);
            }
        });
        this.tfRegex.setText(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.tfRegex.text"));
        this.tfRegex.setToolTipText(NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.tfRegex.toolTipText"));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addComponent(this.tfRegex, -1, 142, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bFilter)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bFilter).addComponent(this.tfRegex, -2, -1, -2)));
        this.jPanel6.add((Component)this.jPanel7, "First");
        this.jSplitPane1.setLeftComponent(this.jPanel6);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void bSortValueActionPerformed(ActionEvent evt) {
        final SortValueByKeyPanel svbkp = new SortValueByKeyPanel(this.innerValueMapKeys);
        DialogDescriptor des = new DialogDescriptor((Object)svbkp, NbBundle.getMessage(DataMapsTopComponent.class, (String)"SortValueByKeyPanel.lSortText.text"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DialogDescriptor.OK_OPTION) {
                    DataMapsTopComponent.this.sortValueByKey(svbkp.getSelectedKey(), svbkp.isDescSelected());
                }
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)des);
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        if (this.tfSearch.getText().isEmpty()) {
            this.eValue.setCaretPosition(0);
        }
        SearchContext context = new SearchContext();
        context.setSearchFor(this.tfSearch.getText());
        context.setMatchCase(false);
        context.setRegularExpression(true);
        context.setSearchForward(true);
        context.setWholeWord(false);
        context.setMarkAll(true);
        SearchEngine.find((JTextArea)this.eValue, (SearchContext)context);
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.deletedDataMapsModel.reset();
        this.displayData();
    }

    private void bSaveActionPerformed(ActionEvent evt) {
        this.model.updateDataMapValue(this.selectedMapName, this.selectedMapKey, this.eValue.getText());
        this.displayData();
    }

    private void bResetActionPerformed(ActionEvent evt) {
        DataMapKey dmk = (DataMapKey)Lookup.getDefault().lookup(DataMapKey.class);
        if (dmk != null) {
            this.eValue.setText(dmk.getDmv().getValue());
        }
    }

    private void cbShowContentActionPerformed(ActionEvent evt) {
        this.model.toggleSelectionMode();
    }

    private void bFilterActionPerformed(ActionEvent evt) {
        if (!this.regexKey.equals(this.tfRegex.getText())) {
            this.displayData();
            this.regexKey = this.tfRegex.getText();
            this.bFilter.setForeground(Color.black);
        }
    }

    public void componentOpened() {
        this.displayData();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("divider_location", String.valueOf(this.jSplitPane1.getDividerLocation()));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        String dividerLocation = p.getProperty("divider_location");
        if (dividerLocation != null) {
            this.jSplitPane1.setDividerLocation(Integer.valueOf(dividerLocation));
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private String formatJS(String text, String options) {
        try {
            Invocable in = this.getScriptEngine();
            return in != null ? (String)in.invokeFunction("js_beautify", text, options) : text;
        }
        catch (NoSuchMethodException | ScriptException ex) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)ex.getLocalizedMessage(), NbBundle.getMessage(DataMapsTopComponent.class, (String)"formatting_script_error"), -1, 2, null, null);
            DialogDisplayer.getDefault().notifyLater(nd);
            return text;
        }
    }

    private void displayData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DataMapsTopComponent.class, (String)"refreshing-datamaps.message"));
                ph.start();
                ph.switchToIndeterminate();
                List<String> datamapsNames = DataMapsTopComponent.this.model.getDatamapsNames();
                for (String datamapName : datamapsNames) {
                    DataMapsTopComponent.this.datamapLoadingKeys.put(datamapName, 1);
                }
                DataMapsTopComponent.this.dmdh.setMap(DataMapsTopComponent.this.datamapLoadingKeys);
                RootNode node = new RootNode(Children.create((ChildFactory)new DataMapChildFactory(DataMapsTopComponent.this.tfRegex.getText()), (boolean)true));
                node.addNodeListener((NodeListener)DataMapsTopComponent.this.dataMapNodeListener);
                DataMapsTopComponent.this.explorerManager.setRootContext((Node)node);
                ph.finish();
            }
        });
    }
}

